# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetByoipRangeResult',
    'AwaitableGetByoipRangeResult',
    'get_byoip_range',
    'get_byoip_range_output',
]

@pulumi.output_type
class GetByoipRangeResult:
    """
    A collection of values returned by getByoipRange.
    """
    def __init__(__self__, byoip_range_id=None, byoip_range_vcn_ipv6allocations=None, cidr_block=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, ipv6cidr_block=None, lifecycle_details=None, origin_asns=None, state=None, time_advertised=None, time_created=None, time_validated=None, time_withdrawn=None, validation_token=None):
        if byoip_range_id and not isinstance(byoip_range_id, str):
            raise TypeError("Expected argument 'byoip_range_id' to be a str")
        pulumi.set(__self__, "byoip_range_id", byoip_range_id)
        if byoip_range_vcn_ipv6allocations and not isinstance(byoip_range_vcn_ipv6allocations, list):
            raise TypeError("Expected argument 'byoip_range_vcn_ipv6allocations' to be a list")
        pulumi.set(__self__, "byoip_range_vcn_ipv6allocations", byoip_range_vcn_ipv6allocations)
        if cidr_block and not isinstance(cidr_block, str):
            raise TypeError("Expected argument 'cidr_block' to be a str")
        pulumi.set(__self__, "cidr_block", cidr_block)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipv6cidr_block and not isinstance(ipv6cidr_block, str):
            raise TypeError("Expected argument 'ipv6cidr_block' to be a str")
        pulumi.set(__self__, "ipv6cidr_block", ipv6cidr_block)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if origin_asns and not isinstance(origin_asns, list):
            raise TypeError("Expected argument 'origin_asns' to be a list")
        pulumi.set(__self__, "origin_asns", origin_asns)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_advertised and not isinstance(time_advertised, str):
            raise TypeError("Expected argument 'time_advertised' to be a str")
        pulumi.set(__self__, "time_advertised", time_advertised)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_validated and not isinstance(time_validated, str):
            raise TypeError("Expected argument 'time_validated' to be a str")
        pulumi.set(__self__, "time_validated", time_validated)
        if time_withdrawn and not isinstance(time_withdrawn, str):
            raise TypeError("Expected argument 'time_withdrawn' to be a str")
        pulumi.set(__self__, "time_withdrawn", time_withdrawn)
        if validation_token and not isinstance(validation_token, str):
            raise TypeError("Expected argument 'validation_token' to be a str")
        pulumi.set(__self__, "validation_token", validation_token)

    @property
    @pulumi.getter(name="byoipRangeId")
    def byoip_range_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `ByoipRange` resource to which the CIDR block belongs.
        """
        return pulumi.get(self, "byoip_range_id")

    @property
    @pulumi.getter(name="byoipRangeVcnIpv6allocations")
    def byoip_range_vcn_ipv6allocations(self) -> Sequence['outputs.GetByoipRangeByoipRangeVcnIpv6allocationResult']:
        """
        A list of `ByoipRangeVcnIpv6AllocationSummary` objects.
        """
        return pulumi.get(self, "byoip_range_vcn_ipv6allocations")

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> builtins.str:
        """
        The public IPv4 CIDR block being imported from on-premises to the Oracle cloud.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the BYOIP CIDR block.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv6cidrBlock")
    def ipv6cidr_block(self) -> builtins.str:
        """
        The IPv6 prefix being imported to the Oracle cloud. This prefix must be /48 or larger, and can be subdivided into sub-ranges used across multiple VCNs. A BYOIPv6 prefix can be also assigned across multiple VCNs, and each VCN must be /64 or larger. You may specify a ULA or private IPv6 prefix of /64 or larger to use in the VCN. IPv6-enabled subnets will remain a fixed /64 in size.
        """
        return pulumi.get(self, "ipv6cidr_block")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        The `ByoipRange` resource's current status.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="originAsns")
    def origin_asns(self) -> Sequence['outputs.GetByoipRangeOriginAsnResult']:
        """
        Information about the origin asn.
        """
        return pulumi.get(self, "origin_asns")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The `ByoipRange` resource's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeAdvertised")
    def time_advertised(self) -> builtins.str:
        """
        The date and time the `ByoipRange` resource was advertised to the internet by BGP, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_advertised")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the `ByoipRange` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeValidated")
    def time_validated(self) -> builtins.str:
        """
        The date and time the `ByoipRange` resource was validated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_validated")

    @property
    @pulumi.getter(name="timeWithdrawn")
    def time_withdrawn(self) -> builtins.str:
        """
        The date and time the `ByoipRange` resource was withdrawn from advertisement by BGP to the internet, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_withdrawn")

    @property
    @pulumi.getter(name="validationToken")
    def validation_token(self) -> builtins.str:
        """
        The validation token is an internally-generated ASCII string used in the validation process. See [Importing a CIDR block](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/BYOIP.htm#import_cidr) for details.
        """
        return pulumi.get(self, "validation_token")


class AwaitableGetByoipRangeResult(GetByoipRangeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetByoipRangeResult(
            byoip_range_id=self.byoip_range_id,
            byoip_range_vcn_ipv6allocations=self.byoip_range_vcn_ipv6allocations,
            cidr_block=self.cidr_block,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            ipv6cidr_block=self.ipv6cidr_block,
            lifecycle_details=self.lifecycle_details,
            origin_asns=self.origin_asns,
            state=self.state,
            time_advertised=self.time_advertised,
            time_created=self.time_created,
            time_validated=self.time_validated,
            time_withdrawn=self.time_withdrawn,
            validation_token=self.validation_token)


def get_byoip_range(byoip_range_id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetByoipRangeResult:
    """
    This data source provides details about a specific Byoip Range resource in Oracle Cloud Infrastructure Core service.

    Gets the `ByoipRange` resource. You must specify the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_byoip_range = oci.Core.get_byoip_range(byoip_range_id=test_byoip_range_oci_core_byoip_range["id"])
    ```


    :param builtins.str byoip_range_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `ByoipRange` resource containing the BYOIP CIDR block.
    """
    __args__ = dict()
    __args__['byoipRangeId'] = byoip_range_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getByoipRange:getByoipRange', __args__, opts=opts, typ=GetByoipRangeResult).value

    return AwaitableGetByoipRangeResult(
        byoip_range_id=pulumi.get(__ret__, 'byoip_range_id'),
        byoip_range_vcn_ipv6allocations=pulumi.get(__ret__, 'byoip_range_vcn_ipv6allocations'),
        cidr_block=pulumi.get(__ret__, 'cidr_block'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        ipv6cidr_block=pulumi.get(__ret__, 'ipv6cidr_block'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        origin_asns=pulumi.get(__ret__, 'origin_asns'),
        state=pulumi.get(__ret__, 'state'),
        time_advertised=pulumi.get(__ret__, 'time_advertised'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_validated=pulumi.get(__ret__, 'time_validated'),
        time_withdrawn=pulumi.get(__ret__, 'time_withdrawn'),
        validation_token=pulumi.get(__ret__, 'validation_token'))
def get_byoip_range_output(byoip_range_id: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetByoipRangeResult]:
    """
    This data source provides details about a specific Byoip Range resource in Oracle Cloud Infrastructure Core service.

    Gets the `ByoipRange` resource. You must specify the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_byoip_range = oci.Core.get_byoip_range(byoip_range_id=test_byoip_range_oci_core_byoip_range["id"])
    ```


    :param builtins.str byoip_range_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `ByoipRange` resource containing the BYOIP CIDR block.
    """
    __args__ = dict()
    __args__['byoipRangeId'] = byoip_range_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getByoipRange:getByoipRange', __args__, opts=opts, typ=GetByoipRangeResult)
    return __ret__.apply(lambda __response__: GetByoipRangeResult(
        byoip_range_id=pulumi.get(__response__, 'byoip_range_id'),
        byoip_range_vcn_ipv6allocations=pulumi.get(__response__, 'byoip_range_vcn_ipv6allocations'),
        cidr_block=pulumi.get(__response__, 'cidr_block'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        ipv6cidr_block=pulumi.get(__response__, 'ipv6cidr_block'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        origin_asns=pulumi.get(__response__, 'origin_asns'),
        state=pulumi.get(__response__, 'state'),
        time_advertised=pulumi.get(__response__, 'time_advertised'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_validated=pulumi.get(__response__, 'time_validated'),
        time_withdrawn=pulumi.get(__response__, 'time_withdrawn'),
        validation_token=pulumi.get(__response__, 'validation_token')))
