# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetByoipRangesResult',
    'AwaitableGetByoipRangesResult',
    'get_byoip_ranges',
    'get_byoip_ranges_output',
]

@pulumi.output_type
class GetByoipRangesResult:
    """
    A collection of values returned by getByoipRanges.
    """
    def __init__(__self__, byoip_range_collections=None, compartment_id=None, display_name=None, filters=None, id=None, state=None):
        if byoip_range_collections and not isinstance(byoip_range_collections, list):
            raise TypeError("Expected argument 'byoip_range_collections' to be a list")
        pulumi.set(__self__, "byoip_range_collections", byoip_range_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="byoipRangeCollections")
    def byoip_range_collections(self) -> Sequence['outputs.GetByoipRangesByoipRangeCollectionResult']:
        """
        The list of byoip_range_collection.
        """
        return pulumi.get(self, "byoip_range_collections")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the BYOIP CIDR block.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetByoipRangesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The `ByoipRange` resource's current state.
        """
        return pulumi.get(self, "state")


class AwaitableGetByoipRangesResult(GetByoipRangesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetByoipRangesResult(
            byoip_range_collections=self.byoip_range_collections,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_byoip_ranges(compartment_id: Optional[builtins.str] = None,
                     display_name: Optional[builtins.str] = None,
                     filters: Optional[Sequence[Union['GetByoipRangesFilterArgs', 'GetByoipRangesFilterArgsDict']]] = None,
                     state: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetByoipRangesResult:
    """
    This data source provides the list of Byoip Ranges in Oracle Cloud Infrastructure Core service.

    Lists the `ByoipRange` resources in the specified compartment.
    You can filter the list using query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_byoip_ranges = oci.Core.get_byoip_ranges(compartment_id=compartment_id,
        display_name=byoip_range_display_name,
        state=byoip_range_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state name exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getByoipRanges:getByoipRanges', __args__, opts=opts, typ=GetByoipRangesResult).value

    return AwaitableGetByoipRangesResult(
        byoip_range_collections=pulumi.get(__ret__, 'byoip_range_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_byoip_ranges_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                            display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetByoipRangesFilterArgs', 'GetByoipRangesFilterArgsDict']]]]] = None,
                            state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetByoipRangesResult]:
    """
    This data source provides the list of Byoip Ranges in Oracle Cloud Infrastructure Core service.

    Lists the `ByoipRange` resources in the specified compartment.
    You can filter the list using query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_byoip_ranges = oci.Core.get_byoip_ranges(compartment_id=compartment_id,
        display_name=byoip_range_display_name,
        state=byoip_range_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state name exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getByoipRanges:getByoipRanges', __args__, opts=opts, typ=GetByoipRangesResult)
    return __ret__.apply(lambda __response__: GetByoipRangesResult(
        byoip_range_collections=pulumi.get(__response__, 'byoip_range_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
