# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCloudAutonomousVmClustersResult',
    'AwaitableGetCloudAutonomousVmClustersResult',
    'get_cloud_autonomous_vm_clusters',
    'get_cloud_autonomous_vm_clusters_output',
]

@pulumi.output_type
class GetCloudAutonomousVmClustersResult:
    """
    A collection of values returned by getCloudAutonomousVmClusters.
    """
    def __init__(__self__, availability_domain=None, cloud_autonomous_vm_clusters=None, cloud_exadata_infrastructure_id=None, compartment_id=None, display_name=None, filters=None, id=None, state=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if cloud_autonomous_vm_clusters and not isinstance(cloud_autonomous_vm_clusters, list):
            raise TypeError("Expected argument 'cloud_autonomous_vm_clusters' to be a list")
        pulumi.set(__self__, "cloud_autonomous_vm_clusters", cloud_autonomous_vm_clusters)
        if cloud_exadata_infrastructure_id and not isinstance(cloud_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'cloud_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[builtins.str]:
        """
        The name of the availability domain that the cloud Autonomous VM cluster is located in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="cloudAutonomousVmClusters")
    def cloud_autonomous_vm_clusters(self) -> Sequence['outputs.GetCloudAutonomousVmClustersCloudAutonomousVmClusterResult']:
        """
        The list of cloud_autonomous_vm_clusters.
        """
        return pulumi.get(self, "cloud_autonomous_vm_clusters")

    @property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The user-friendly name for the cloud Autonomous VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCloudAutonomousVmClustersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "state")


class AwaitableGetCloudAutonomousVmClustersResult(GetCloudAutonomousVmClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudAutonomousVmClustersResult(
            availability_domain=self.availability_domain,
            cloud_autonomous_vm_clusters=self.cloud_autonomous_vm_clusters,
            cloud_exadata_infrastructure_id=self.cloud_exadata_infrastructure_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_cloud_autonomous_vm_clusters(availability_domain: Optional[builtins.str] = None,
                                     cloud_exadata_infrastructure_id: Optional[builtins.str] = None,
                                     compartment_id: Optional[builtins.str] = None,
                                     display_name: Optional[builtins.str] = None,
                                     filters: Optional[Sequence[Union['GetCloudAutonomousVmClustersFilterArgs', 'GetCloudAutonomousVmClustersFilterArgsDict']]] = None,
                                     state: Optional[builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudAutonomousVmClustersResult:
    """
    This data source provides the list of Cloud Autonomous Vm Clusters in Oracle Cloud Infrastructure Database service.

    Lists Autonomous Exadata VM clusters in the Oracle cloud. For Exadata Cloud@Customer systems, see [ListAutonomousVmClusters](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/AutonomousVmCluster/ListAutonomousVmClusters).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_autonomous_vm_clusters = oci.Database.get_cloud_autonomous_vm_clusters(compartment_id=compartment_id,
        availability_domain=cloud_autonomous_vm_cluster_availability_domain,
        cloud_exadata_infrastructure_id=test_cloud_exadata_infrastructure["id"],
        display_name=cloud_autonomous_vm_cluster_display_name,
        state=cloud_autonomous_vm_cluster_state)
    ```


    :param builtins.str availability_domain: A filter to return only resources that match the given availability domain exactly.
    :param builtins.str cloud_exadata_infrastructure_id: If provided, filters the results for the specified cloud Exadata infrastructure.
    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['cloudExadataInfrastructureId'] = cloud_exadata_infrastructure_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getCloudAutonomousVmClusters:getCloudAutonomousVmClusters', __args__, opts=opts, typ=GetCloudAutonomousVmClustersResult).value

    return AwaitableGetCloudAutonomousVmClustersResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        cloud_autonomous_vm_clusters=pulumi.get(__ret__, 'cloud_autonomous_vm_clusters'),
        cloud_exadata_infrastructure_id=pulumi.get(__ret__, 'cloud_exadata_infrastructure_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_cloud_autonomous_vm_clusters_output(availability_domain: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                            cloud_exadata_infrastructure_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                            display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCloudAutonomousVmClustersFilterArgs', 'GetCloudAutonomousVmClustersFilterArgsDict']]]]] = None,
                                            state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudAutonomousVmClustersResult]:
    """
    This data source provides the list of Cloud Autonomous Vm Clusters in Oracle Cloud Infrastructure Database service.

    Lists Autonomous Exadata VM clusters in the Oracle cloud. For Exadata Cloud@Customer systems, see [ListAutonomousVmClusters](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/AutonomousVmCluster/ListAutonomousVmClusters).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_autonomous_vm_clusters = oci.Database.get_cloud_autonomous_vm_clusters(compartment_id=compartment_id,
        availability_domain=cloud_autonomous_vm_cluster_availability_domain,
        cloud_exadata_infrastructure_id=test_cloud_exadata_infrastructure["id"],
        display_name=cloud_autonomous_vm_cluster_display_name,
        state=cloud_autonomous_vm_cluster_state)
    ```


    :param builtins.str availability_domain: A filter to return only resources that match the given availability domain exactly.
    :param builtins.str cloud_exadata_infrastructure_id: If provided, filters the results for the specified cloud Exadata infrastructure.
    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['cloudExadataInfrastructureId'] = cloud_exadata_infrastructure_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getCloudAutonomousVmClusters:getCloudAutonomousVmClusters', __args__, opts=opts, typ=GetCloudAutonomousVmClustersResult)
    return __ret__.apply(lambda __response__: GetCloudAutonomousVmClustersResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        cloud_autonomous_vm_clusters=pulumi.get(__response__, 'cloud_autonomous_vm_clusters'),
        cloud_exadata_infrastructure_id=pulumi.get(__response__, 'cloud_exadata_infrastructure_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
