# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbSystemStoragePerformancesResult',
    'AwaitableGetDbSystemStoragePerformancesResult',
    'get_db_system_storage_performances',
    'get_db_system_storage_performances_output',
]

@pulumi.output_type
class GetDbSystemStoragePerformancesResult:
    """
    A collection of values returned by getDbSystemStoragePerformances.
    """
    def __init__(__self__, db_system_storage_performances=None, filters=None, id=None, shape_type=None, storage_management=None):
        if db_system_storage_performances and not isinstance(db_system_storage_performances, list):
            raise TypeError("Expected argument 'db_system_storage_performances' to be a list")
        pulumi.set(__self__, "db_system_storage_performances", db_system_storage_performances)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if shape_type and not isinstance(shape_type, str):
            raise TypeError("Expected argument 'shape_type' to be a str")
        pulumi.set(__self__, "shape_type", shape_type)
        if storage_management and not isinstance(storage_management, str):
            raise TypeError("Expected argument 'storage_management' to be a str")
        pulumi.set(__self__, "storage_management", storage_management)

    @property
    @pulumi.getter(name="dbSystemStoragePerformances")
    def db_system_storage_performances(self) -> Sequence['outputs.GetDbSystemStoragePerformancesDbSystemStoragePerformanceResult']:
        """
        The list of db_system_storage_performances.
        """
        return pulumi.get(self, "db_system_storage_performances")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbSystemStoragePerformancesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="shapeType")
    def shape_type(self) -> Optional[builtins.str]:
        """
        ShapeType of the DbSystems,INTEL or AMD
        """
        return pulumi.get(self, "shape_type")

    @property
    @pulumi.getter(name="storageManagement")
    def storage_management(self) -> builtins.str:
        return pulumi.get(self, "storage_management")


class AwaitableGetDbSystemStoragePerformancesResult(GetDbSystemStoragePerformancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbSystemStoragePerformancesResult(
            db_system_storage_performances=self.db_system_storage_performances,
            filters=self.filters,
            id=self.id,
            shape_type=self.shape_type,
            storage_management=self.storage_management)


def get_db_system_storage_performances(filters: Optional[Sequence[Union['GetDbSystemStoragePerformancesFilterArgs', 'GetDbSystemStoragePerformancesFilterArgsDict']]] = None,
                                       shape_type: Optional[builtins.str] = None,
                                       storage_management: Optional[builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbSystemStoragePerformancesResult:
    """
    This data source provides the list of Db System Storage Performances in Oracle Cloud Infrastructure Database service.

    Gets a list of possible expected storage performance parameters of a VMDB System based on Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_system_storage_performances = oci.Database.get_db_system_storage_performances(storage_management=db_system_storage_performance_storage_management,
        shape_type=db_system_storage_performance_shape_type)
    ```


    :param builtins.str shape_type: Optional. Filters the performance results by shape type.
    :param builtins.str storage_management: The DB system storage management option. Used to list database versions available for that storage manager. Valid values are `ASM` and `LVM`.
           * ASM specifies Oracle Automatic Storage Management
           * LVM specifies logical volume manager, sometimes called logical disk manager.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['shapeType'] = shape_type
    __args__['storageManagement'] = storage_management
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbSystemStoragePerformances:getDbSystemStoragePerformances', __args__, opts=opts, typ=GetDbSystemStoragePerformancesResult).value

    return AwaitableGetDbSystemStoragePerformancesResult(
        db_system_storage_performances=pulumi.get(__ret__, 'db_system_storage_performances'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        shape_type=pulumi.get(__ret__, 'shape_type'),
        storage_management=pulumi.get(__ret__, 'storage_management'))
def get_db_system_storage_performances_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDbSystemStoragePerformancesFilterArgs', 'GetDbSystemStoragePerformancesFilterArgsDict']]]]] = None,
                                              shape_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              storage_management: Optional[pulumi.Input[builtins.str]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbSystemStoragePerformancesResult]:
    """
    This data source provides the list of Db System Storage Performances in Oracle Cloud Infrastructure Database service.

    Gets a list of possible expected storage performance parameters of a VMDB System based on Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_system_storage_performances = oci.Database.get_db_system_storage_performances(storage_management=db_system_storage_performance_storage_management,
        shape_type=db_system_storage_performance_shape_type)
    ```


    :param builtins.str shape_type: Optional. Filters the performance results by shape type.
    :param builtins.str storage_management: The DB system storage management option. Used to list database versions available for that storage manager. Valid values are `ASM` and `LVM`.
           * ASM specifies Oracle Automatic Storage Management
           * LVM specifies logical volume manager, sometimes called logical disk manager.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['shapeType'] = shape_type
    __args__['storageManagement'] = storage_management
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getDbSystemStoragePerformances:getDbSystemStoragePerformances', __args__, opts=opts, typ=GetDbSystemStoragePerformancesResult)
    return __ret__.apply(lambda __response__: GetDbSystemStoragePerformancesResult(
        db_system_storage_performances=pulumi.get(__response__, 'db_system_storage_performances'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        shape_type=pulumi.get(__response__, 'shape_type'),
        storage_management=pulumi.get(__response__, 'storage_management')))
