# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVmClusterNetworksResult',
    'AwaitableGetVmClusterNetworksResult',
    'get_vm_cluster_networks',
    'get_vm_cluster_networks_output',
]

@pulumi.output_type
class GetVmClusterNetworksResult:
    """
    A collection of values returned by getVmClusterNetworks.
    """
    def __init__(__self__, compartment_id=None, display_name=None, exadata_infrastructure_id=None, filters=None, id=None, state=None, vm_cluster_networks=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if exadata_infrastructure_id and not isinstance(exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vm_cluster_networks and not isinstance(vm_cluster_networks, list):
            raise TypeError("Expected argument 'vm_cluster_networks' to be a list")
        pulumi.set(__self__, "vm_cluster_networks", vm_cluster_networks)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The user-friendly name for the VM cluster network. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVmClusterNetworksFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the VM cluster network nodes. CREATING - The resource is being created REQUIRES_VALIDATION - The resource is created and may not be usable until it is validated. VALIDATING - The resource is being validated and not available to use. VALIDATED - The resource is validated and is available for consumption by VM cluster. VALIDATION_FAILED - The resource validation has failed and might require user input to be corrected. UPDATING - The resource is being updated and not available to use. ALLOCATED - The resource is currently being used by VM cluster. TERMINATING - The resource is being deleted and not available to use. TERMINATED - The resource is deleted and unavailable. FAILED - The resource is in a failed state due to validation or other errors.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vmClusterNetworks")
    def vm_cluster_networks(self) -> Sequence['outputs.GetVmClusterNetworksVmClusterNetworkResult']:
        """
        The list of vm_cluster_networks.
        """
        return pulumi.get(self, "vm_cluster_networks")


class AwaitableGetVmClusterNetworksResult(GetVmClusterNetworksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVmClusterNetworksResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            exadata_infrastructure_id=self.exadata_infrastructure_id,
            filters=self.filters,
            id=self.id,
            state=self.state,
            vm_cluster_networks=self.vm_cluster_networks)


def get_vm_cluster_networks(compartment_id: Optional[builtins.str] = None,
                            display_name: Optional[builtins.str] = None,
                            exadata_infrastructure_id: Optional[builtins.str] = None,
                            filters: Optional[Sequence[Union['GetVmClusterNetworksFilterArgs', 'GetVmClusterNetworksFilterArgsDict']]] = None,
                            state: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVmClusterNetworksResult:
    """
    This data source provides the list of Vm Cluster Networks in Oracle Cloud Infrastructure Database service.

    Gets a list of the VM cluster networks in the specified compartment. Applies to Exadata Cloud@Customer instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster_networks = oci.Database.get_vm_cluster_networks(compartment_id=compartment_id,
        exadata_infrastructure_id=test_exadata_infrastructure["id"],
        display_name=vm_cluster_network_display_name,
        state=vm_cluster_network_state)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param builtins.str exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['exadataInfrastructureId'] = exadata_infrastructure_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getVmClusterNetworks:getVmClusterNetworks', __args__, opts=opts, typ=GetVmClusterNetworksResult).value

    return AwaitableGetVmClusterNetworksResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__ret__, 'exadata_infrastructure_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        vm_cluster_networks=pulumi.get(__ret__, 'vm_cluster_networks'))
def get_vm_cluster_networks_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                   display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVmClusterNetworksFilterArgs', 'GetVmClusterNetworksFilterArgsDict']]]]] = None,
                                   state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVmClusterNetworksResult]:
    """
    This data source provides the list of Vm Cluster Networks in Oracle Cloud Infrastructure Database service.

    Gets a list of the VM cluster networks in the specified compartment. Applies to Exadata Cloud@Customer instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster_networks = oci.Database.get_vm_cluster_networks(compartment_id=compartment_id,
        exadata_infrastructure_id=test_exadata_infrastructure["id"],
        display_name=vm_cluster_network_display_name,
        state=vm_cluster_network_state)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param builtins.str exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['exadataInfrastructureId'] = exadata_infrastructure_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getVmClusterNetworks:getVmClusterNetworks', __args__, opts=opts, typ=GetVmClusterNetworksResult)
    return __ret__.apply(lambda __response__: GetVmClusterNetworksResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__response__, 'exadata_infrastructure_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        vm_cluster_networks=pulumi.get(__response__, 'vm_cluster_networks')))
