# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNamedCredentialResult',
    'AwaitableGetNamedCredentialResult',
    'get_named_credential',
    'get_named_credential_output',
]

@pulumi.output_type
class GetNamedCredentialResult:
    """
    A collection of values returned by getNamedCredential.
    """
    def __init__(__self__, associated_resource=None, compartment_id=None, contents=None, defined_tags=None, description=None, freeform_tags=None, id=None, lifecycle_details=None, name=None, named_credential_id=None, scope=None, state=None, system_tags=None, time_created=None, time_updated=None, type=None):
        if associated_resource and not isinstance(associated_resource, str):
            raise TypeError("Expected argument 'associated_resource' to be a str")
        pulumi.set(__self__, "associated_resource", associated_resource)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if contents and not isinstance(contents, list):
            raise TypeError("Expected argument 'contents' to be a list")
        pulumi.set(__self__, "contents", contents)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if named_credential_id and not isinstance(named_credential_id, str):
            raise TypeError("Expected argument 'named_credential_id' to be a str")
        pulumi.set(__self__, "named_credential_id", named_credential_id)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="associatedResource")
    def associated_resource(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that  is associated to the named credential.
        """
        return pulumi.get(self, "associated_resource")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def contents(self) -> Sequence['outputs.GetNamedCredentialContentResult']:
        """
        The details of the named credential.
        """
        return pulumi.get(self, "contents")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The information specified by the user about the named credential.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the named credential.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        The details of the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the named credential.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namedCredentialId")
    def named_credential_id(self) -> builtins.str:
        return pulumi.get(self, "named_credential_id")

    @property
    @pulumi.getter
    def scope(self) -> builtins.str:
        """
        The scope of the named credential.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current lifecycle state of the named credential.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the named credential was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the named credential was last updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of resource associated with the named credential.
        """
        return pulumi.get(self, "type")


class AwaitableGetNamedCredentialResult(GetNamedCredentialResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamedCredentialResult(
            associated_resource=self.associated_resource,
            compartment_id=self.compartment_id,
            contents=self.contents,
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            name=self.name,
            named_credential_id=self.named_credential_id,
            scope=self.scope,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type)


def get_named_credential(named_credential_id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamedCredentialResult:
    """
    This data source provides details about a specific Named Credential resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the named credential specified by namedCredentialId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_named_credential = oci.DatabaseManagement.get_named_credential(named_credential_id=test_named_credential_oci_database_management_named_credential["id"])
    ```


    :param builtins.str named_credential_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the named credential.
    """
    __args__ = dict()
    __args__['namedCredentialId'] = named_credential_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getNamedCredential:getNamedCredential', __args__, opts=opts, typ=GetNamedCredentialResult).value

    return AwaitableGetNamedCredentialResult(
        associated_resource=pulumi.get(__ret__, 'associated_resource'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        contents=pulumi.get(__ret__, 'contents'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        name=pulumi.get(__ret__, 'name'),
        named_credential_id=pulumi.get(__ret__, 'named_credential_id'),
        scope=pulumi.get(__ret__, 'scope'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'))
def get_named_credential_output(named_credential_id: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNamedCredentialResult]:
    """
    This data source provides details about a specific Named Credential resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the named credential specified by namedCredentialId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_named_credential = oci.DatabaseManagement.get_named_credential(named_credential_id=test_named_credential_oci_database_management_named_credential["id"])
    ```


    :param builtins.str named_credential_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the named credential.
    """
    __args__ = dict()
    __args__['namedCredentialId'] = named_credential_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getNamedCredential:getNamedCredential', __args__, opts=opts, typ=GetNamedCredentialResult)
    return __ret__.apply(lambda __response__: GetNamedCredentialResult(
        associated_resource=pulumi.get(__response__, 'associated_resource'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        contents=pulumi.get(__response__, 'contents'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        name=pulumi.get(__response__, 'name'),
        named_credential_id=pulumi.get(__response__, 'named_credential_id'),
        scope=pulumi.get(__response__, 'scope'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type')))
