# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceArgs', 'Workspace']

@pulumi.input_type
class WorkspaceArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dns_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 dns_server_zone: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_force_operation: Optional[pulumi.Input[builtins.bool]] = None,
                 is_private_network_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 quiesce_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 registry_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 registry_id: Optional[pulumi.Input[builtins.str]] = None,
                 registry_name: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Workspace resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the workspace.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly display name for the workspace. Does not have to be unique, and can be modified. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user defined description for the workspace.
        :param pulumi.Input[builtins.str] dns_server_ip: The IP of the custom DNS.
        :param pulumi.Input[builtins.str] dns_server_zone: The DNS zone of the custom DNS to use to resolve names.
        :param pulumi.Input[builtins.str] endpoint_compartment_id: DCMS PRivate Endpoint Compartment Identifier
        :param pulumi.Input[builtins.str] endpoint_id: DCMS Private Endpoint ID associated with workspace if the pvt networking is enabled
        :param pulumi.Input[builtins.str] endpoint_name: DCMS Private Endpoint Name
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_private_network_enabled: Specifies whether the private network connection is enabled or disabled.
        :param pulumi.Input[builtins.str] registry_compartment_id: DCMS Data Asset Registry Compartment Identifier
        :param pulumi.Input[builtins.str] registry_id: DCMS Data Asset Registry ID to which the workspace is associated
        :param pulumi.Input[builtins.str] registry_name: DCMS Data Asset Registry display name
        :param pulumi.Input[builtins.str] subnet_id: The OCID of the subnet for customer connected databases.
        :param pulumi.Input[builtins.str] vcn_id: The OCID of the VCN the subnet is in.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_server_ip is not None:
            pulumi.set(__self__, "dns_server_ip", dns_server_ip)
        if dns_server_zone is not None:
            pulumi.set(__self__, "dns_server_zone", dns_server_zone)
        if endpoint_compartment_id is not None:
            pulumi.set(__self__, "endpoint_compartment_id", endpoint_compartment_id)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_force_operation is not None:
            pulumi.set(__self__, "is_force_operation", is_force_operation)
        if is_private_network_enabled is not None:
            pulumi.set(__self__, "is_private_network_enabled", is_private_network_enabled)
        if quiesce_timeout is not None:
            pulumi.set(__self__, "quiesce_timeout", quiesce_timeout)
        if registry_compartment_id is not None:
            pulumi.set(__self__, "registry_compartment_id", registry_compartment_id)
        if registry_id is not None:
            pulumi.set(__self__, "registry_id", registry_id)
        if registry_name is not None:
            pulumi.set(__self__, "registry_name", registry_name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the compartment containing the workspace.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) A user-friendly display name for the workspace. Does not have to be unique, and can be modified. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user defined description for the workspace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP of the custom DNS.
        """
        return pulumi.get(self, "dns_server_ip")

    @dns_server_ip.setter
    def dns_server_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_server_ip", value)

    @property
    @pulumi.getter(name="dnsServerZone")
    def dns_server_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DNS zone of the custom DNS to use to resolve names.
        """
        return pulumi.get(self, "dns_server_zone")

    @dns_server_zone.setter
    def dns_server_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_server_zone", value)

    @property
    @pulumi.getter(name="endpointCompartmentId")
    def endpoint_compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DCMS PRivate Endpoint Compartment Identifier
        """
        return pulumi.get(self, "endpoint_compartment_id")

    @endpoint_compartment_id.setter
    def endpoint_compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_compartment_id", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DCMS Private Endpoint ID associated with workspace if the pvt networking is enabled
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DCMS Private Endpoint Name
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isForceOperation")
    def is_force_operation(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "is_force_operation")

    @is_force_operation.setter
    def is_force_operation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_force_operation", value)

    @property
    @pulumi.getter(name="isPrivateNetworkEnabled")
    def is_private_network_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the private network connection is enabled or disabled.
        """
        return pulumi.get(self, "is_private_network_enabled")

    @is_private_network_enabled.setter
    def is_private_network_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_private_network_enabled", value)

    @property
    @pulumi.getter(name="quiesceTimeout")
    def quiesce_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "quiesce_timeout")

    @quiesce_timeout.setter
    def quiesce_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "quiesce_timeout", value)

    @property
    @pulumi.getter(name="registryCompartmentId")
    def registry_compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DCMS Data Asset Registry Compartment Identifier
        """
        return pulumi.get(self, "registry_compartment_id")

    @registry_compartment_id.setter
    def registry_compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registry_compartment_id", value)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DCMS Data Asset Registry ID to which the workspace is associated
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registry_id", value)

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DCMS Data Asset Registry display name
        """
        return pulumi.get(self, "registry_name")

    @registry_name.setter
    def registry_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registry_name", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the subnet for customer connected databases.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the VCN the subnet is in.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vcn_id", value)


@pulumi.input_type
class _WorkspaceState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dns_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 dns_server_zone: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_force_operation: Optional[pulumi.Input[builtins.bool]] = None,
                 is_private_network_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 quiesce_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 registry_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 registry_id: Optional[pulumi.Input[builtins.str]] = None,
                 registry_name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 state_message: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Workspace resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the workspace.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user defined description for the workspace.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly display name for the workspace. Does not have to be unique, and can be modified. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] dns_server_ip: The IP of the custom DNS.
        :param pulumi.Input[builtins.str] dns_server_zone: The DNS zone of the custom DNS to use to resolve names.
        :param pulumi.Input[builtins.str] endpoint_compartment_id: DCMS PRivate Endpoint Compartment Identifier
        :param pulumi.Input[builtins.str] endpoint_id: DCMS Private Endpoint ID associated with workspace if the pvt networking is enabled
        :param pulumi.Input[builtins.str] endpoint_name: DCMS Private Endpoint Name
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_private_network_enabled: Specifies whether the private network connection is enabled or disabled.
        :param pulumi.Input[builtins.str] registry_compartment_id: DCMS Data Asset Registry Compartment Identifier
        :param pulumi.Input[builtins.str] registry_id: DCMS Data Asset Registry ID to which the workspace is associated
        :param pulumi.Input[builtins.str] registry_name: DCMS Data Asset Registry display name
        :param pulumi.Input[builtins.str] state: Lifecycle states for workspaces in Data Integration Service CREATING - The resource is being created and may not be usable until the entire metadata is defined UPDATING - The resource is being updated and may not be usable until all changes are commited DELETING - The resource is being deleted and might require deep cleanup of children. ACTIVE   - The resource is valid and available for access INACTIVE - The resource might be incomplete in its definition or might have been made unavailable for administrative reasons DELETED  - The resource has been deleted and isn't available FAILED   - The resource is in a failed state due to validation or other errors STARTING - The resource is being started and may not be usable until becomes ACTIVE again STOPPING - The resource is in the process of Stopping and may not be usable until it Stops or fails STOPPED  - The resource is in Stopped state due to stop operation.
        :param pulumi.Input[builtins.str] state_message: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        :param pulumi.Input[builtins.str] subnet_id: The OCID of the subnet for customer connected databases.
        :param pulumi.Input[builtins.str] time_created: The date and time the workspace was created, in the timestamp format defined by RFC3339.
        :param pulumi.Input[builtins.str] time_updated: The date and time the workspace was updated, in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[builtins.str] vcn_id: The OCID of the VCN the subnet is in.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dns_server_ip is not None:
            pulumi.set(__self__, "dns_server_ip", dns_server_ip)
        if dns_server_zone is not None:
            pulumi.set(__self__, "dns_server_zone", dns_server_zone)
        if endpoint_compartment_id is not None:
            pulumi.set(__self__, "endpoint_compartment_id", endpoint_compartment_id)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_force_operation is not None:
            pulumi.set(__self__, "is_force_operation", is_force_operation)
        if is_private_network_enabled is not None:
            pulumi.set(__self__, "is_private_network_enabled", is_private_network_enabled)
        if quiesce_timeout is not None:
            pulumi.set(__self__, "quiesce_timeout", quiesce_timeout)
        if registry_compartment_id is not None:
            pulumi.set(__self__, "registry_compartment_id", registry_compartment_id)
        if registry_id is not None:
            pulumi.set(__self__, "registry_id", registry_id)
        if registry_name is not None:
            pulumi.set(__self__, "registry_name", registry_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_message is not None:
            pulumi.set(__self__, "state_message", state_message)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment containing the workspace.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user defined description for the workspace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly display name for the workspace. Does not have to be unique, and can be modified. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP of the custom DNS.
        """
        return pulumi.get(self, "dns_server_ip")

    @dns_server_ip.setter
    def dns_server_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_server_ip", value)

    @property
    @pulumi.getter(name="dnsServerZone")
    def dns_server_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DNS zone of the custom DNS to use to resolve names.
        """
        return pulumi.get(self, "dns_server_zone")

    @dns_server_zone.setter
    def dns_server_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_server_zone", value)

    @property
    @pulumi.getter(name="endpointCompartmentId")
    def endpoint_compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DCMS PRivate Endpoint Compartment Identifier
        """
        return pulumi.get(self, "endpoint_compartment_id")

    @endpoint_compartment_id.setter
    def endpoint_compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_compartment_id", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DCMS Private Endpoint ID associated with workspace if the pvt networking is enabled
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DCMS Private Endpoint Name
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isForceOperation")
    def is_force_operation(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "is_force_operation")

    @is_force_operation.setter
    def is_force_operation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_force_operation", value)

    @property
    @pulumi.getter(name="isPrivateNetworkEnabled")
    def is_private_network_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the private network connection is enabled or disabled.
        """
        return pulumi.get(self, "is_private_network_enabled")

    @is_private_network_enabled.setter
    def is_private_network_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_private_network_enabled", value)

    @property
    @pulumi.getter(name="quiesceTimeout")
    def quiesce_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "quiesce_timeout")

    @quiesce_timeout.setter
    def quiesce_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "quiesce_timeout", value)

    @property
    @pulumi.getter(name="registryCompartmentId")
    def registry_compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DCMS Data Asset Registry Compartment Identifier
        """
        return pulumi.get(self, "registry_compartment_id")

    @registry_compartment_id.setter
    def registry_compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registry_compartment_id", value)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DCMS Data Asset Registry ID to which the workspace is associated
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registry_id", value)

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DCMS Data Asset Registry display name
        """
        return pulumi.get(self, "registry_name")

    @registry_name.setter
    def registry_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registry_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lifecycle states for workspaces in Data Integration Service CREATING - The resource is being created and may not be usable until the entire metadata is defined UPDATING - The resource is being updated and may not be usable until all changes are commited DELETING - The resource is being deleted and might require deep cleanup of children. ACTIVE   - The resource is valid and available for access INACTIVE - The resource might be incomplete in its definition or might have been made unavailable for administrative reasons DELETED  - The resource has been deleted and isn't available FAILED   - The resource is in a failed state due to validation or other errors STARTING - The resource is being started and may not be usable until becomes ACTIVE again STOPPING - The resource is in the process of Stopping and may not be usable until it Stops or fails STOPPED  - The resource is in Stopped state due to stop operation.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        """
        return pulumi.get(self, "state_message")

    @state_message.setter
    def state_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state_message", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the subnet for customer connected databases.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the workspace was created, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the workspace was updated, in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the VCN the subnet is in.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vcn_id", value)


class Workspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dns_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 dns_server_zone: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_force_operation: Optional[pulumi.Input[builtins.bool]] = None,
                 is_private_network_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 quiesce_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 registry_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 registry_id: Optional[pulumi.Input[builtins.str]] = None,
                 registry_name: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Workspace resource in Oracle Cloud Infrastructure Data Integration service.

        Creates a new Data Integration workspace ready for performing data integration tasks. To retrieve the OCID for the new workspace, use the opc-work-request-id returned by this API and call the [GetWorkRequest](https://docs.cloud.oracle.com/iaas/api/#/en/data-integration/latest/WorkRequest/GetWorkRequest) API.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace = oci.data_integration.Workspace("test_workspace",
            compartment_id=compartment_id,
            display_name=workspace_display_name,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=workspace_description,
            dns_server_ip=workspace_dns_server_ip,
            dns_server_zone=workspace_dns_server_zone,
            endpoint_compartment_id=test_compartment["id"],
            endpoint_id=test_endpoint["id"],
            endpoint_name=workspace_endpoint_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_private_network_enabled=workspace_is_private_network_enabled,
            registry_compartment_id=test_compartment["id"],
            registry_id=test_registry["id"],
            registry_name=test_registry["name"],
            subnet_id=test_subnet["id"],
            vcn_id=test_vcn["id"])
        ```

        ## Import

        Workspaces can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspace:Workspace test_workspace "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the workspace.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user defined description for the workspace.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly display name for the workspace. Does not have to be unique, and can be modified. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] dns_server_ip: The IP of the custom DNS.
        :param pulumi.Input[builtins.str] dns_server_zone: The DNS zone of the custom DNS to use to resolve names.
        :param pulumi.Input[builtins.str] endpoint_compartment_id: DCMS PRivate Endpoint Compartment Identifier
        :param pulumi.Input[builtins.str] endpoint_id: DCMS Private Endpoint ID associated with workspace if the pvt networking is enabled
        :param pulumi.Input[builtins.str] endpoint_name: DCMS Private Endpoint Name
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_private_network_enabled: Specifies whether the private network connection is enabled or disabled.
        :param pulumi.Input[builtins.str] registry_compartment_id: DCMS Data Asset Registry Compartment Identifier
        :param pulumi.Input[builtins.str] registry_id: DCMS Data Asset Registry ID to which the workspace is associated
        :param pulumi.Input[builtins.str] registry_name: DCMS Data Asset Registry display name
        :param pulumi.Input[builtins.str] subnet_id: The OCID of the subnet for customer connected databases.
        :param pulumi.Input[builtins.str] vcn_id: The OCID of the VCN the subnet is in.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Workspace resource in Oracle Cloud Infrastructure Data Integration service.

        Creates a new Data Integration workspace ready for performing data integration tasks. To retrieve the OCID for the new workspace, use the opc-work-request-id returned by this API and call the [GetWorkRequest](https://docs.cloud.oracle.com/iaas/api/#/en/data-integration/latest/WorkRequest/GetWorkRequest) API.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace = oci.data_integration.Workspace("test_workspace",
            compartment_id=compartment_id,
            display_name=workspace_display_name,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=workspace_description,
            dns_server_ip=workspace_dns_server_ip,
            dns_server_zone=workspace_dns_server_zone,
            endpoint_compartment_id=test_compartment["id"],
            endpoint_id=test_endpoint["id"],
            endpoint_name=workspace_endpoint_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_private_network_enabled=workspace_is_private_network_enabled,
            registry_compartment_id=test_compartment["id"],
            registry_id=test_registry["id"],
            registry_name=test_registry["name"],
            subnet_id=test_subnet["id"],
            vcn_id=test_vcn["id"])
        ```

        ## Import

        Workspaces can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspace:Workspace test_workspace "id"
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dns_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 dns_server_zone: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_force_operation: Optional[pulumi.Input[builtins.bool]] = None,
                 is_private_network_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 quiesce_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 registry_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 registry_id: Optional[pulumi.Input[builtins.str]] = None,
                 registry_name: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceArgs.__new__(WorkspaceArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["dns_server_ip"] = dns_server_ip
            __props__.__dict__["dns_server_zone"] = dns_server_zone
            __props__.__dict__["endpoint_compartment_id"] = endpoint_compartment_id
            __props__.__dict__["endpoint_id"] = endpoint_id
            __props__.__dict__["endpoint_name"] = endpoint_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_force_operation"] = is_force_operation
            __props__.__dict__["is_private_network_enabled"] = is_private_network_enabled
            __props__.__dict__["quiesce_timeout"] = quiesce_timeout
            __props__.__dict__["registry_compartment_id"] = registry_compartment_id
            __props__.__dict__["registry_id"] = registry_id
            __props__.__dict__["registry_name"] = registry_name
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["vcn_id"] = vcn_id
            __props__.__dict__["state"] = None
            __props__.__dict__["state_message"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Workspace, __self__).__init__(
            'oci:DataIntegration/workspace:Workspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            dns_server_ip: Optional[pulumi.Input[builtins.str]] = None,
            dns_server_zone: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_force_operation: Optional[pulumi.Input[builtins.bool]] = None,
            is_private_network_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            quiesce_timeout: Optional[pulumi.Input[builtins.int]] = None,
            registry_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            registry_id: Optional[pulumi.Input[builtins.str]] = None,
            registry_name: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            state_message: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            vcn_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Workspace':
        """
        Get an existing Workspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the workspace.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user defined description for the workspace.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly display name for the workspace. Does not have to be unique, and can be modified. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] dns_server_ip: The IP of the custom DNS.
        :param pulumi.Input[builtins.str] dns_server_zone: The DNS zone of the custom DNS to use to resolve names.
        :param pulumi.Input[builtins.str] endpoint_compartment_id: DCMS PRivate Endpoint Compartment Identifier
        :param pulumi.Input[builtins.str] endpoint_id: DCMS Private Endpoint ID associated with workspace if the pvt networking is enabled
        :param pulumi.Input[builtins.str] endpoint_name: DCMS Private Endpoint Name
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_private_network_enabled: Specifies whether the private network connection is enabled or disabled.
        :param pulumi.Input[builtins.str] registry_compartment_id: DCMS Data Asset Registry Compartment Identifier
        :param pulumi.Input[builtins.str] registry_id: DCMS Data Asset Registry ID to which the workspace is associated
        :param pulumi.Input[builtins.str] registry_name: DCMS Data Asset Registry display name
        :param pulumi.Input[builtins.str] state: Lifecycle states for workspaces in Data Integration Service CREATING - The resource is being created and may not be usable until the entire metadata is defined UPDATING - The resource is being updated and may not be usable until all changes are commited DELETING - The resource is being deleted and might require deep cleanup of children. ACTIVE   - The resource is valid and available for access INACTIVE - The resource might be incomplete in its definition or might have been made unavailable for administrative reasons DELETED  - The resource has been deleted and isn't available FAILED   - The resource is in a failed state due to validation or other errors STARTING - The resource is being started and may not be usable until becomes ACTIVE again STOPPING - The resource is in the process of Stopping and may not be usable until it Stops or fails STOPPED  - The resource is in Stopped state due to stop operation.
        :param pulumi.Input[builtins.str] state_message: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        :param pulumi.Input[builtins.str] subnet_id: The OCID of the subnet for customer connected databases.
        :param pulumi.Input[builtins.str] time_created: The date and time the workspace was created, in the timestamp format defined by RFC3339.
        :param pulumi.Input[builtins.str] time_updated: The date and time the workspace was updated, in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[builtins.str] vcn_id: The OCID of the VCN the subnet is in.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceState.__new__(_WorkspaceState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dns_server_ip"] = dns_server_ip
        __props__.__dict__["dns_server_zone"] = dns_server_zone
        __props__.__dict__["endpoint_compartment_id"] = endpoint_compartment_id
        __props__.__dict__["endpoint_id"] = endpoint_id
        __props__.__dict__["endpoint_name"] = endpoint_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_force_operation"] = is_force_operation
        __props__.__dict__["is_private_network_enabled"] = is_private_network_enabled
        __props__.__dict__["quiesce_timeout"] = quiesce_timeout
        __props__.__dict__["registry_compartment_id"] = registry_compartment_id
        __props__.__dict__["registry_id"] = registry_id
        __props__.__dict__["registry_name"] = registry_name
        __props__.__dict__["state"] = state
        __props__.__dict__["state_message"] = state_message
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["vcn_id"] = vcn_id
        return Workspace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment containing the workspace.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user defined description for the workspace.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly display name for the workspace. Does not have to be unique, and can be modified. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> pulumi.Output[builtins.str]:
        """
        The IP of the custom DNS.
        """
        return pulumi.get(self, "dns_server_ip")

    @property
    @pulumi.getter(name="dnsServerZone")
    def dns_server_zone(self) -> pulumi.Output[builtins.str]:
        """
        The DNS zone of the custom DNS to use to resolve names.
        """
        return pulumi.get(self, "dns_server_zone")

    @property
    @pulumi.getter(name="endpointCompartmentId")
    def endpoint_compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        DCMS PRivate Endpoint Compartment Identifier
        """
        return pulumi.get(self, "endpoint_compartment_id")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> pulumi.Output[builtins.str]:
        """
        DCMS Private Endpoint ID associated with workspace if the pvt networking is enabled
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Output[builtins.str]:
        """
        DCMS Private Endpoint Name
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isForceOperation")
    def is_force_operation(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "is_force_operation")

    @property
    @pulumi.getter(name="isPrivateNetworkEnabled")
    def is_private_network_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether the private network connection is enabled or disabled.
        """
        return pulumi.get(self, "is_private_network_enabled")

    @property
    @pulumi.getter(name="quiesceTimeout")
    def quiesce_timeout(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "quiesce_timeout")

    @property
    @pulumi.getter(name="registryCompartmentId")
    def registry_compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        DCMS Data Asset Registry Compartment Identifier
        """
        return pulumi.get(self, "registry_compartment_id")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Output[builtins.str]:
        """
        DCMS Data Asset Registry ID to which the workspace is associated
        """
        return pulumi.get(self, "registry_id")

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> pulumi.Output[builtins.str]:
        """
        DCMS Data Asset Registry display name
        """
        return pulumi.get(self, "registry_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Lifecycle states for workspaces in Data Integration Service CREATING - The resource is being created and may not be usable until the entire metadata is defined UPDATING - The resource is being updated and may not be usable until all changes are commited DELETING - The resource is being deleted and might require deep cleanup of children. ACTIVE   - The resource is valid and available for access INACTIVE - The resource might be incomplete in its definition or might have been made unavailable for administrative reasons DELETED  - The resource has been deleted and isn't available FAILED   - The resource is in a failed state due to validation or other errors STARTING - The resource is being started and may not be usable until becomes ACTIVE again STOPPING - The resource is in the process of Stopping and may not be usable until it Stops or fails STOPPED  - The resource is in Stopped state due to stop operation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the subnet for customer connected databases.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the workspace was created, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the workspace was updated, in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the VCN the subnet is in.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

