# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDatasetResult',
    'AwaitableGetDatasetResult',
    'get_dataset',
    'get_dataset_output',
]

@pulumi.output_type
class GetDatasetResult:
    """
    A collection of values returned by getDataset.
    """
    def __init__(__self__, additional_properties=None, annotation_format=None, compartment_id=None, dataset_format_details=None, dataset_id=None, dataset_source_details=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, initial_import_dataset_configurations=None, initial_record_generation_configurations=None, label_sets=None, labeling_instructions=None, lifecycle_details=None, lifecycle_substate=None, state=None, time_created=None, time_updated=None):
        if additional_properties and not isinstance(additional_properties, dict):
            raise TypeError("Expected argument 'additional_properties' to be a dict")
        pulumi.set(__self__, "additional_properties", additional_properties)
        if annotation_format and not isinstance(annotation_format, str):
            raise TypeError("Expected argument 'annotation_format' to be a str")
        pulumi.set(__self__, "annotation_format", annotation_format)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if dataset_format_details and not isinstance(dataset_format_details, list):
            raise TypeError("Expected argument 'dataset_format_details' to be a list")
        pulumi.set(__self__, "dataset_format_details", dataset_format_details)
        if dataset_id and not isinstance(dataset_id, str):
            raise TypeError("Expected argument 'dataset_id' to be a str")
        pulumi.set(__self__, "dataset_id", dataset_id)
        if dataset_source_details and not isinstance(dataset_source_details, list):
            raise TypeError("Expected argument 'dataset_source_details' to be a list")
        pulumi.set(__self__, "dataset_source_details", dataset_source_details)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if initial_import_dataset_configurations and not isinstance(initial_import_dataset_configurations, list):
            raise TypeError("Expected argument 'initial_import_dataset_configurations' to be a list")
        pulumi.set(__self__, "initial_import_dataset_configurations", initial_import_dataset_configurations)
        if initial_record_generation_configurations and not isinstance(initial_record_generation_configurations, list):
            raise TypeError("Expected argument 'initial_record_generation_configurations' to be a list")
        pulumi.set(__self__, "initial_record_generation_configurations", initial_record_generation_configurations)
        if label_sets and not isinstance(label_sets, list):
            raise TypeError("Expected argument 'label_sets' to be a list")
        pulumi.set(__self__, "label_sets", label_sets)
        if labeling_instructions and not isinstance(labeling_instructions, str):
            raise TypeError("Expected argument 'labeling_instructions' to be a str")
        pulumi.set(__self__, "labeling_instructions", labeling_instructions)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_substate and not isinstance(lifecycle_substate, str):
            raise TypeError("Expected argument 'lifecycle_substate' to be a str")
        pulumi.set(__self__, "lifecycle_substate", lifecycle_substate)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Mapping[str, builtins.str]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_properties")

    @property
    @pulumi.getter(name="annotationFormat")
    def annotation_format(self) -> builtins.str:
        """
        The annotation format name required for labeling records.
        """
        return pulumi.get(self, "annotation_format")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment of the resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="datasetFormatDetails")
    def dataset_format_details(self) -> Sequence['outputs.GetDatasetDatasetFormatDetailResult']:
        """
        It specifies how to process the data. Supported formats include DOCUMENT, IMAGE, and TEXT.
        """
        return pulumi.get(self, "dataset_format_details")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetSourceDetails")
    def dataset_source_details(self) -> Sequence['outputs.GetDatasetDatasetSourceDetailResult']:
        """
        This allows the customer to specify the source of the dataset.
        """
        return pulumi.get(self, "dataset_source_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        The defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A user provided description of the dataset
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the Dataset.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="initialImportDatasetConfigurations")
    def initial_import_dataset_configurations(self) -> Sequence['outputs.GetDatasetInitialImportDatasetConfigurationResult']:
        """
        Initial import dataset configuration. Allows user to create dataset from existing dataset files.
        """
        return pulumi.get(self, "initial_import_dataset_configurations")

    @property
    @pulumi.getter(name="initialRecordGenerationConfigurations")
    def initial_record_generation_configurations(self) -> Sequence['outputs.GetDatasetInitialRecordGenerationConfigurationResult']:
        """
        The initial generate records configuration. It generates records from the dataset's source.
        """
        return pulumi.get(self, "initial_record_generation_configurations")

    @property
    @pulumi.getter(name="labelSets")
    def label_sets(self) -> Sequence['outputs.GetDatasetLabelSetResult']:
        """
        An ordered collection of labels that are unique by name.
        """
        return pulumi.get(self, "label_sets")

    @property
    @pulumi.getter(name="labelingInstructions")
    def labeling_instructions(self) -> builtins.str:
        """
        The labeling instructions for human labelers in rich text format
        """
        return pulumi.get(self, "labeling_instructions")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in FAILED or NEEDS_ATTENTION state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleSubstate")
    def lifecycle_substate(self) -> builtins.str:
        """
        The sub-state of the dataset. IMPORT_DATASET - The dataset is being imported.
        """
        return pulumi.get(self, "lifecycle_substate")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The state of a dataset. CREATING - The dataset is being created.  It will transition to ACTIVE when it is ready for labeling. ACTIVE   - The dataset is ready for labeling. UPDATING - The dataset is being updated.  It and its related resources may be unavailable for other updates until it returns to ACTIVE. NEEDS_ATTENTION - A dataset updation operation has failed due to validation or other errors and needs attention. DELETING - The dataset and its related resources are being deleted. DELETED  - The dataset has been deleted and is no longer available. FAILED   - The dataset has failed due to validation or other errors.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the resource was created, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the resource was last updated, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDatasetResult(GetDatasetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatasetResult(
            additional_properties=self.additional_properties,
            annotation_format=self.annotation_format,
            compartment_id=self.compartment_id,
            dataset_format_details=self.dataset_format_details,
            dataset_id=self.dataset_id,
            dataset_source_details=self.dataset_source_details,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            initial_import_dataset_configurations=self.initial_import_dataset_configurations,
            initial_record_generation_configurations=self.initial_record_generation_configurations,
            label_sets=self.label_sets,
            labeling_instructions=self.labeling_instructions,
            lifecycle_details=self.lifecycle_details,
            lifecycle_substate=self.lifecycle_substate,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_dataset(dataset_id: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatasetResult:
    """
    This data source provides details about a specific Dataset resource in Oracle Cloud Infrastructure Data Labeling Service service.

    Gets a Dataset by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dataset = oci.DataLabellingService.get_dataset(dataset_id=test_dataset_oci_data_labeling_service_dataset["id"])
    ```


    :param builtins.str dataset_id: Unique Dataset OCID
    """
    __args__ = dict()
    __args__['datasetId'] = dataset_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataLabellingService/getDataset:getDataset', __args__, opts=opts, typ=GetDatasetResult).value

    return AwaitableGetDatasetResult(
        additional_properties=pulumi.get(__ret__, 'additional_properties'),
        annotation_format=pulumi.get(__ret__, 'annotation_format'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        dataset_format_details=pulumi.get(__ret__, 'dataset_format_details'),
        dataset_id=pulumi.get(__ret__, 'dataset_id'),
        dataset_source_details=pulumi.get(__ret__, 'dataset_source_details'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        initial_import_dataset_configurations=pulumi.get(__ret__, 'initial_import_dataset_configurations'),
        initial_record_generation_configurations=pulumi.get(__ret__, 'initial_record_generation_configurations'),
        label_sets=pulumi.get(__ret__, 'label_sets'),
        labeling_instructions=pulumi.get(__ret__, 'labeling_instructions'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        lifecycle_substate=pulumi.get(__ret__, 'lifecycle_substate'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_dataset_output(dataset_id: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatasetResult]:
    """
    This data source provides details about a specific Dataset resource in Oracle Cloud Infrastructure Data Labeling Service service.

    Gets a Dataset by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dataset = oci.DataLabellingService.get_dataset(dataset_id=test_dataset_oci_data_labeling_service_dataset["id"])
    ```


    :param builtins.str dataset_id: Unique Dataset OCID
    """
    __args__ = dict()
    __args__['datasetId'] = dataset_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataLabellingService/getDataset:getDataset', __args__, opts=opts, typ=GetDatasetResult)
    return __ret__.apply(lambda __response__: GetDatasetResult(
        additional_properties=pulumi.get(__response__, 'additional_properties'),
        annotation_format=pulumi.get(__response__, 'annotation_format'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        dataset_format_details=pulumi.get(__response__, 'dataset_format_details'),
        dataset_id=pulumi.get(__response__, 'dataset_id'),
        dataset_source_details=pulumi.get(__response__, 'dataset_source_details'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        initial_import_dataset_configurations=pulumi.get(__response__, 'initial_import_dataset_configurations'),
        initial_record_generation_configurations=pulumi.get(__response__, 'initial_record_generation_configurations'),
        label_sets=pulumi.get(__response__, 'label_sets'),
        labeling_instructions=pulumi.get(__response__, 'labeling_instructions'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        lifecycle_substate=pulumi.get(__response__, 'lifecycle_substate'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
