# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMlApplicationImplementationResult',
    'AwaitableGetMlApplicationImplementationResult',
    'get_ml_application_implementation',
    'get_ml_application_implementation_output',
]

@pulumi.output_type
class GetMlApplicationImplementationResult:
    """
    A collection of values returned by getMlApplicationImplementation.
    """
    def __init__(__self__, allowed_migration_destinations=None, application_components=None, compartment_id=None, configuration_schemas=None, defined_tags=None, description=None, freeform_tags=None, id=None, lifecycle_details=None, loggings=None, ml_application_id=None, ml_application_implementation_id=None, ml_application_name=None, ml_application_package=None, ml_application_package_arguments=None, name=None, opc_ml_app_package_args=None, package_version=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if allowed_migration_destinations and not isinstance(allowed_migration_destinations, list):
            raise TypeError("Expected argument 'allowed_migration_destinations' to be a list")
        pulumi.set(__self__, "allowed_migration_destinations", allowed_migration_destinations)
        if application_components and not isinstance(application_components, list):
            raise TypeError("Expected argument 'application_components' to be a list")
        pulumi.set(__self__, "application_components", application_components)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_schemas and not isinstance(configuration_schemas, list):
            raise TypeError("Expected argument 'configuration_schemas' to be a list")
        pulumi.set(__self__, "configuration_schemas", configuration_schemas)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if loggings and not isinstance(loggings, list):
            raise TypeError("Expected argument 'loggings' to be a list")
        pulumi.set(__self__, "loggings", loggings)
        if ml_application_id and not isinstance(ml_application_id, str):
            raise TypeError("Expected argument 'ml_application_id' to be a str")
        pulumi.set(__self__, "ml_application_id", ml_application_id)
        if ml_application_implementation_id and not isinstance(ml_application_implementation_id, str):
            raise TypeError("Expected argument 'ml_application_implementation_id' to be a str")
        pulumi.set(__self__, "ml_application_implementation_id", ml_application_implementation_id)
        if ml_application_name and not isinstance(ml_application_name, str):
            raise TypeError("Expected argument 'ml_application_name' to be a str")
        pulumi.set(__self__, "ml_application_name", ml_application_name)
        if ml_application_package and not isinstance(ml_application_package, dict):
            raise TypeError("Expected argument 'ml_application_package' to be a dict")
        pulumi.set(__self__, "ml_application_package", ml_application_package)
        if ml_application_package_arguments and not isinstance(ml_application_package_arguments, list):
            raise TypeError("Expected argument 'ml_application_package_arguments' to be a list")
        pulumi.set(__self__, "ml_application_package_arguments", ml_application_package_arguments)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if opc_ml_app_package_args and not isinstance(opc_ml_app_package_args, dict):
            raise TypeError("Expected argument 'opc_ml_app_package_args' to be a dict")
        pulumi.set(__self__, "opc_ml_app_package_args", opc_ml_app_package_args)
        if package_version and not isinstance(package_version, str):
            raise TypeError("Expected argument 'package_version' to be a str")
        pulumi.set(__self__, "package_version", package_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="allowedMigrationDestinations")
    def allowed_migration_destinations(self) -> Sequence[builtins.str]:
        """
        List of ML Application Implementation OCIDs for which migration from this implementation is allowed. Migration means that if consumers change implementation for their instances to implementation with OCID from this list, instance components will be updated in place otherwise new instance components are created based on the new implementation and old instance components are removed.
        """
        return pulumi.get(self, "allowed_migration_destinations")

    @property
    @pulumi.getter(name="applicationComponents")
    def application_components(self) -> Sequence['outputs.GetMlApplicationImplementationApplicationComponentResult']:
        """
        List of application components (OCI resources shared for all MlApplicationInstances). These have been created automatically based on their definitions in the ML Application package.
        """
        return pulumi.get(self, "application_components")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment where ML Application Implementation is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configurationSchemas")
    def configuration_schemas(self) -> Sequence['outputs.GetMlApplicationImplementationConfigurationSchemaResult']:
        """
        Schema of configuration which needs to be provided for each ML Application Instance. It is defined in the ML Application package descriptor.
        """
        return pulumi.get(self, "configuration_schemas")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        short description of the argument
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the MlApplicationImplementation. Unique identifier that is immutable after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def loggings(self) -> Sequence['outputs.GetMlApplicationImplementationLoggingResult']:
        """
        Configuration of Logging for ML Application Implementation.
        """
        return pulumi.get(self, "loggings")

    @property
    @pulumi.getter(name="mlApplicationId")
    def ml_application_id(self) -> builtins.str:
        """
        The OCID of the ML Application implemented by this ML Application Implementation.
        """
        return pulumi.get(self, "ml_application_id")

    @property
    @pulumi.getter(name="mlApplicationImplementationId")
    def ml_application_implementation_id(self) -> builtins.str:
        return pulumi.get(self, "ml_application_implementation_id")

    @property
    @pulumi.getter(name="mlApplicationName")
    def ml_application_name(self) -> builtins.str:
        """
        The name of ML Application (based on mlApplicationId)
        """
        return pulumi.get(self, "ml_application_name")

    @property
    @pulumi.getter(name="mlApplicationPackage")
    def ml_application_package(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "ml_application_package")

    @property
    @pulumi.getter(name="mlApplicationPackageArguments")
    def ml_application_package_arguments(self) -> Sequence['outputs.GetMlApplicationImplementationMlApplicationPackageArgumentResult']:
        """
        List of ML Application package arguments provided during ML Application package upload.
        """
        return pulumi.get(self, "ml_application_package_arguments")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        ML Application Implementation name which is unique for given ML Application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="opcMlAppPackageArgs")
    def opc_ml_app_package_args(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "opc_ml_app_package_args")

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> builtins.str:
        """
        The version of ML Application Package (e.g. "1.2" or "2.0.4") defined in ML Application package descriptor. Value is not mandatory only for CREATING state otherwise it must be always presented.
        """
        return pulumi.get(self, "package_version")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the MlApplicationImplementation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        Creation time of MlApplicationImplementation creation in the format defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        Time of last MlApplicationImplementation update in the format defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMlApplicationImplementationResult(GetMlApplicationImplementationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMlApplicationImplementationResult(
            allowed_migration_destinations=self.allowed_migration_destinations,
            application_components=self.application_components,
            compartment_id=self.compartment_id,
            configuration_schemas=self.configuration_schemas,
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            loggings=self.loggings,
            ml_application_id=self.ml_application_id,
            ml_application_implementation_id=self.ml_application_implementation_id,
            ml_application_name=self.ml_application_name,
            ml_application_package=self.ml_application_package,
            ml_application_package_arguments=self.ml_application_package_arguments,
            name=self.name,
            opc_ml_app_package_args=self.opc_ml_app_package_args,
            package_version=self.package_version,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_ml_application_implementation(ml_application_implementation_id: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMlApplicationImplementationResult:
    """
    This data source provides details about a specific Ml Application Implementation resource in Oracle Cloud Infrastructure Data Science service.

    Gets a MlApplicationImplementation by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ml_application_implementation = oci.DataScience.get_ml_application_implementation(ml_application_implementation_id=test_ml_application_implementation_oci_datascience_ml_application_implementation["id"])
    ```


    :param builtins.str ml_application_implementation_id: unique MlApplicationImplementation identifier
    """
    __args__ = dict()
    __args__['mlApplicationImplementationId'] = ml_application_implementation_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getMlApplicationImplementation:getMlApplicationImplementation', __args__, opts=opts, typ=GetMlApplicationImplementationResult).value

    return AwaitableGetMlApplicationImplementationResult(
        allowed_migration_destinations=pulumi.get(__ret__, 'allowed_migration_destinations'),
        application_components=pulumi.get(__ret__, 'application_components'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        configuration_schemas=pulumi.get(__ret__, 'configuration_schemas'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        loggings=pulumi.get(__ret__, 'loggings'),
        ml_application_id=pulumi.get(__ret__, 'ml_application_id'),
        ml_application_implementation_id=pulumi.get(__ret__, 'ml_application_implementation_id'),
        ml_application_name=pulumi.get(__ret__, 'ml_application_name'),
        ml_application_package=pulumi.get(__ret__, 'ml_application_package'),
        ml_application_package_arguments=pulumi.get(__ret__, 'ml_application_package_arguments'),
        name=pulumi.get(__ret__, 'name'),
        opc_ml_app_package_args=pulumi.get(__ret__, 'opc_ml_app_package_args'),
        package_version=pulumi.get(__ret__, 'package_version'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_ml_application_implementation_output(ml_application_implementation_id: Optional[pulumi.Input[builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMlApplicationImplementationResult]:
    """
    This data source provides details about a specific Ml Application Implementation resource in Oracle Cloud Infrastructure Data Science service.

    Gets a MlApplicationImplementation by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ml_application_implementation = oci.DataScience.get_ml_application_implementation(ml_application_implementation_id=test_ml_application_implementation_oci_datascience_ml_application_implementation["id"])
    ```


    :param builtins.str ml_application_implementation_id: unique MlApplicationImplementation identifier
    """
    __args__ = dict()
    __args__['mlApplicationImplementationId'] = ml_application_implementation_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataScience/getMlApplicationImplementation:getMlApplicationImplementation', __args__, opts=opts, typ=GetMlApplicationImplementationResult)
    return __ret__.apply(lambda __response__: GetMlApplicationImplementationResult(
        allowed_migration_destinations=pulumi.get(__response__, 'allowed_migration_destinations'),
        application_components=pulumi.get(__response__, 'application_components'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        configuration_schemas=pulumi.get(__response__, 'configuration_schemas'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        loggings=pulumi.get(__response__, 'loggings'),
        ml_application_id=pulumi.get(__response__, 'ml_application_id'),
        ml_application_implementation_id=pulumi.get(__response__, 'ml_application_implementation_id'),
        ml_application_name=pulumi.get(__response__, 'ml_application_name'),
        ml_application_package=pulumi.get(__response__, 'ml_application_package'),
        ml_application_package_arguments=pulumi.get(__response__, 'ml_application_package_arguments'),
        name=pulumi.get(__response__, 'name'),
        opc_ml_app_package_args=pulumi.get(__response__, 'opc_ml_app_package_args'),
        package_version=pulumi.get(__response__, 'package_version'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
