# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDrProtectionGroupResult',
    'AwaitableGetDrProtectionGroupResult',
    'get_dr_protection_group',
    'get_dr_protection_group_output',
]

@pulumi.output_type
class GetDrProtectionGroupResult:
    """
    A collection of values returned by getDrProtectionGroup.
    """
    def __init__(__self__, associations=None, compartment_id=None, defined_tags=None, disassociate_trigger=None, display_name=None, dr_protection_group_id=None, freeform_tags=None, id=None, life_cycle_details=None, lifecycle_sub_state=None, log_locations=None, members=None, peer_id=None, peer_region=None, role=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if associations and not isinstance(associations, list):
            raise TypeError("Expected argument 'associations' to be a list")
        pulumi.set(__self__, "associations", associations)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if disassociate_trigger and not isinstance(disassociate_trigger, int):
            raise TypeError("Expected argument 'disassociate_trigger' to be a int")
        pulumi.set(__self__, "disassociate_trigger", disassociate_trigger)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dr_protection_group_id and not isinstance(dr_protection_group_id, str):
            raise TypeError("Expected argument 'dr_protection_group_id' to be a str")
        pulumi.set(__self__, "dr_protection_group_id", dr_protection_group_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if life_cycle_details and not isinstance(life_cycle_details, str):
            raise TypeError("Expected argument 'life_cycle_details' to be a str")
        pulumi.set(__self__, "life_cycle_details", life_cycle_details)
        if lifecycle_sub_state and not isinstance(lifecycle_sub_state, str):
            raise TypeError("Expected argument 'lifecycle_sub_state' to be a str")
        pulumi.set(__self__, "lifecycle_sub_state", lifecycle_sub_state)
        if log_locations and not isinstance(log_locations, list):
            raise TypeError("Expected argument 'log_locations' to be a list")
        pulumi.set(__self__, "log_locations", log_locations)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if peer_id and not isinstance(peer_id, str):
            raise TypeError("Expected argument 'peer_id' to be a str")
        pulumi.set(__self__, "peer_id", peer_id)
        if peer_region and not isinstance(peer_region, str):
            raise TypeError("Expected argument 'peer_region' to be a str")
        pulumi.set(__self__, "peer_region", peer_region)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def associations(self) -> Sequence['outputs.GetDrProtectionGroupAssociationResult']:
        return pulumi.get(self, "associations")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment containing the DR protection group.  Example: `ocid1.compartment.oc1..uniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="disassociateTrigger")
    def disassociate_trigger(self) -> builtins.int:
        return pulumi.get(self, "disassociate_trigger")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name of the DR protection group.  Example: `EBS PHX Group`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> builtins.str:
        return pulumi.get(self, "dr_protection_group_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the virtual node pool in OKE cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifeCycleDetails")
    def life_cycle_details(self) -> builtins.str:
        """
        A message describing the DR protection group's current state in more detail.
        """
        return pulumi.get(self, "life_cycle_details")

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> builtins.str:
        """
        The current sub-state of the DR protection group.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Sequence['outputs.GetDrProtectionGroupLogLocationResult']:
        """
        The details of an object storage log location for a DR protection group.
        """
        return pulumi.get(self, "log_locations")

    @property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetDrProtectionGroupMemberResult']:
        """
        A list of DR protection group members.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> builtins.str:
        """
        The OCID of the peer DR protection group.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "peer_id")

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> builtins.str:
        """
        The region of the peer DR protection group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        The role of the DR protection group.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the DR protection group.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the DR protection group was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the DR protection group was updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDrProtectionGroupResult(GetDrProtectionGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDrProtectionGroupResult(
            associations=self.associations,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            disassociate_trigger=self.disassociate_trigger,
            display_name=self.display_name,
            dr_protection_group_id=self.dr_protection_group_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            life_cycle_details=self.life_cycle_details,
            lifecycle_sub_state=self.lifecycle_sub_state,
            log_locations=self.log_locations,
            members=self.members,
            peer_id=self.peer_id,
            peer_region=self.peer_region,
            role=self.role,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_dr_protection_group(dr_protection_group_id: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDrProtectionGroupResult:
    """
    This data source provides details about a specific Dr Protection Group resource in Oracle Cloud Infrastructure Disaster Recovery service.

    Get the DR protection group identified by *drProtectionGroupId*.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dr_protection_group = oci.DisasterRecovery.get_dr_protection_group(dr_protection_group_id=test_dr_protection_group_oci_disaster_recovery_dr_protection_group["id"])
    ```


    :param builtins.str dr_protection_group_id: The OCID of the DR protection group.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
    """
    __args__ = dict()
    __args__['drProtectionGroupId'] = dr_protection_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DisasterRecovery/getDrProtectionGroup:getDrProtectionGroup', __args__, opts=opts, typ=GetDrProtectionGroupResult).value

    return AwaitableGetDrProtectionGroupResult(
        associations=pulumi.get(__ret__, 'associations'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        disassociate_trigger=pulumi.get(__ret__, 'disassociate_trigger'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dr_protection_group_id=pulumi.get(__ret__, 'dr_protection_group_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        life_cycle_details=pulumi.get(__ret__, 'life_cycle_details'),
        lifecycle_sub_state=pulumi.get(__ret__, 'lifecycle_sub_state'),
        log_locations=pulumi.get(__ret__, 'log_locations'),
        members=pulumi.get(__ret__, 'members'),
        peer_id=pulumi.get(__ret__, 'peer_id'),
        peer_region=pulumi.get(__ret__, 'peer_region'),
        role=pulumi.get(__ret__, 'role'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_dr_protection_group_output(dr_protection_group_id: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDrProtectionGroupResult]:
    """
    This data source provides details about a specific Dr Protection Group resource in Oracle Cloud Infrastructure Disaster Recovery service.

    Get the DR protection group identified by *drProtectionGroupId*.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dr_protection_group = oci.DisasterRecovery.get_dr_protection_group(dr_protection_group_id=test_dr_protection_group_oci_disaster_recovery_dr_protection_group["id"])
    ```


    :param builtins.str dr_protection_group_id: The OCID of the DR protection group.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
    """
    __args__ = dict()
    __args__['drProtectionGroupId'] = dr_protection_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DisasterRecovery/getDrProtectionGroup:getDrProtectionGroup', __args__, opts=opts, typ=GetDrProtectionGroupResult)
    return __ret__.apply(lambda __response__: GetDrProtectionGroupResult(
        associations=pulumi.get(__response__, 'associations'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        disassociate_trigger=pulumi.get(__response__, 'disassociate_trigger'),
        display_name=pulumi.get(__response__, 'display_name'),
        dr_protection_group_id=pulumi.get(__response__, 'dr_protection_group_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        life_cycle_details=pulumi.get(__response__, 'life_cycle_details'),
        lifecycle_sub_state=pulumi.get(__response__, 'lifecycle_sub_state'),
        log_locations=pulumi.get(__response__, 'log_locations'),
        members=pulumi.get(__response__, 'members'),
        peer_id=pulumi.get(__response__, 'peer_id'),
        peer_region=pulumi.get(__response__, 'peer_region'),
        role=pulumi.get(__response__, 'role'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
