# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEmailReturnPathsResult',
    'AwaitableGetEmailReturnPathsResult',
    'get_email_return_paths',
    'get_email_return_paths_output',
]

@pulumi.output_type
class GetEmailReturnPathsResult:
    """
    A collection of values returned by getEmailReturnPaths.
    """
    def __init__(__self__, compartment_id=None, email_return_path_collections=None, filters=None, id=None, name=None, parent_resource_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if email_return_path_collections and not isinstance(email_return_path_collections, list):
            raise TypeError("Expected argument 'email_return_path_collections' to be a list")
        pulumi.set(__self__, "email_return_path_collections", email_return_path_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent_resource_id and not isinstance(parent_resource_id, str):
            raise TypeError("Expected argument 'parent_resource_id' to be a str")
        pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains this email return path.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="emailReturnPathCollections")
    def email_return_path_collections(self) -> Sequence['outputs.GetEmailReturnPathsEmailReturnPathCollectionResult']:
        """
        The list of email_return_path_collection.
        """
        return pulumi.get(self, "email_return_path_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEmailReturnPathsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the email return path.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The email return path domain in the Internet Domain Name System (DNS).  Example: `iad1.rp.example.com`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the EmailDomain that this email return path belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the email return path.
        """
        return pulumi.get(self, "state")


class AwaitableGetEmailReturnPathsResult(GetEmailReturnPathsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEmailReturnPathsResult(
            compartment_id=self.compartment_id,
            email_return_path_collections=self.email_return_path_collections,
            filters=self.filters,
            id=self.id,
            name=self.name,
            parent_resource_id=self.parent_resource_id,
            state=self.state)


def get_email_return_paths(compartment_id: Optional[builtins.str] = None,
                           filters: Optional[Sequence[Union['GetEmailReturnPathsFilterArgs', 'GetEmailReturnPathsFilterArgsDict']]] = None,
                           id: Optional[builtins.str] = None,
                           name: Optional[builtins.str] = None,
                           parent_resource_id: Optional[builtins.str] = None,
                           state: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEmailReturnPathsResult:
    """
    This data source provides the list of Email Return Paths in Oracle Cloud Infrastructure Email service.

    Lists email return paths in the specified compartment or emaildomain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_email_return_paths = oci.Email.get_email_return_paths(compartment_id=compartment_id,
        id=email_return_path_id,
        name=email_return_path_name,
        parent_resource_id=test_resource["id"],
        state=email_return_path_state)
    ```


    :param builtins.str compartment_id: The OCID for the compartment.
    :param builtins.str id: A filter to only return resources that match the given id exactly.
    :param builtins.str name: A filter to only return resources that match the given name exactly.
    :param builtins.str parent_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Email Domain to which this Email Return Path belongs.
    :param builtins.str state: Filter returned list by specified lifecycle state. This parameter is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['parentResourceId'] = parent_resource_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Email/getEmailReturnPaths:getEmailReturnPaths', __args__, opts=opts, typ=GetEmailReturnPathsResult).value

    return AwaitableGetEmailReturnPathsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        email_return_path_collections=pulumi.get(__ret__, 'email_return_path_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        parent_resource_id=pulumi.get(__ret__, 'parent_resource_id'),
        state=pulumi.get(__ret__, 'state'))
def get_email_return_paths_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetEmailReturnPathsFilterArgs', 'GetEmailReturnPathsFilterArgsDict']]]]] = None,
                                  id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  parent_resource_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEmailReturnPathsResult]:
    """
    This data source provides the list of Email Return Paths in Oracle Cloud Infrastructure Email service.

    Lists email return paths in the specified compartment or emaildomain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_email_return_paths = oci.Email.get_email_return_paths(compartment_id=compartment_id,
        id=email_return_path_id,
        name=email_return_path_name,
        parent_resource_id=test_resource["id"],
        state=email_return_path_state)
    ```


    :param builtins.str compartment_id: The OCID for the compartment.
    :param builtins.str id: A filter to only return resources that match the given id exactly.
    :param builtins.str name: A filter to only return resources that match the given name exactly.
    :param builtins.str parent_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Email Domain to which this Email Return Path belongs.
    :param builtins.str state: Filter returned list by specified lifecycle state. This parameter is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['parentResourceId'] = parent_resource_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Email/getEmailReturnPaths:getEmailReturnPaths', __args__, opts=opts, typ=GetEmailReturnPathsResult)
    return __ret__.apply(lambda __response__: GetEmailReturnPathsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        email_return_path_collections=pulumi.get(__response__, 'email_return_path_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        parent_resource_id=pulumi.get(__response__, 'parent_resource_id'),
        state=pulumi.get(__response__, 'state')))
