# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFileSystemQuotaRuleResult',
    'AwaitableGetFileSystemQuotaRuleResult',
    'get_file_system_quota_rule',
    'get_file_system_quota_rule_output',
]

@pulumi.output_type
class GetFileSystemQuotaRuleResult:
    """
    A collection of values returned by getFileSystemQuotaRule.
    """
    def __init__(__self__, are_violators_only=None, display_name=None, file_system_id=None, id=None, is_hard_quota=None, principal_id=None, principal_type=None, quota_limit_in_gigabytes=None, quota_rule_id=None, time_created=None, time_updated=None):
        if are_violators_only and not isinstance(are_violators_only, str):
            raise TypeError("Expected argument 'are_violators_only' to be a str")
        pulumi.set(__self__, "are_violators_only", are_violators_only)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if file_system_id and not isinstance(file_system_id, str):
            raise TypeError("Expected argument 'file_system_id' to be a str")
        pulumi.set(__self__, "file_system_id", file_system_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_hard_quota and not isinstance(is_hard_quota, bool):
            raise TypeError("Expected argument 'is_hard_quota' to be a bool")
        pulumi.set(__self__, "is_hard_quota", is_hard_quota)
        if principal_id and not isinstance(principal_id, int):
            raise TypeError("Expected argument 'principal_id' to be a int")
        pulumi.set(__self__, "principal_id", principal_id)
        if principal_type and not isinstance(principal_type, str):
            raise TypeError("Expected argument 'principal_type' to be a str")
        pulumi.set(__self__, "principal_type", principal_type)
        if quota_limit_in_gigabytes and not isinstance(quota_limit_in_gigabytes, int):
            raise TypeError("Expected argument 'quota_limit_in_gigabytes' to be a int")
        pulumi.set(__self__, "quota_limit_in_gigabytes", quota_limit_in_gigabytes)
        if quota_rule_id and not isinstance(quota_rule_id, str):
            raise TypeError("Expected argument 'quota_rule_id' to be a str")
        pulumi.set(__self__, "quota_rule_id", quota_rule_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="areViolatorsOnly")
    def are_violators_only(self) -> Optional[builtins.str]:
        return pulumi.get(self, "are_violators_only")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. Example: `UserXYZ's quota`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file System.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The identifier of the quota rule. It is the base64 encoded string of the tuple <principalId, principalType, isHardQuota>.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isHardQuota")
    def is_hard_quota(self) -> builtins.bool:
        """
        The flag is an identifier to tell whether the quota rule will be enforced. If `isHardQuota` is false, the quota rule will be enforced so the usage cannot exceed the hard quota limit. If `isHardQuota` is true, usage can exceed the soft quota limit. An alarm or notification will be sent to the customer, if the specific usage exceeds.
        """
        return pulumi.get(self, "is_hard_quota")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.int:
        """
        An identifier for the owner of this usage and quota rule. Unix-like operating systems use this integer value to identify a user or group to manage access control.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> builtins.str:
        """
        The type of the owner of this quota rule and usage.
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="quotaLimitInGigabytes")
    def quota_limit_in_gigabytes(self) -> builtins.int:
        """
        The value of the quota rule. The unit is Gigabyte.
        """
        return pulumi.get(self, "quota_limit_in_gigabytes")

    @property
    @pulumi.getter(name="quotaRuleId")
    def quota_rule_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "quota_rule_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the quota rule was started, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the quota rule was last updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetFileSystemQuotaRuleResult(GetFileSystemQuotaRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFileSystemQuotaRuleResult(
            are_violators_only=self.are_violators_only,
            display_name=self.display_name,
            file_system_id=self.file_system_id,
            id=self.id,
            is_hard_quota=self.is_hard_quota,
            principal_id=self.principal_id,
            principal_type=self.principal_type,
            quota_limit_in_gigabytes=self.quota_limit_in_gigabytes,
            quota_rule_id=self.quota_rule_id,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_file_system_quota_rule(are_violators_only: Optional[builtins.str] = None,
                               file_system_id: Optional[builtins.str] = None,
                               quota_rule_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFileSystemQuotaRuleResult:
    """
    This data source provides details about a specific File System Quota Rule resource in Oracle Cloud Infrastructure File Storage service.

    Get an FS level, user or group quota rule given the `fileSystemId` and `quotaRuleId` parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_file_system_quota_rule = oci.FileStorage.get_file_system_quota_rule(file_system_id=test_file_system["id"],
        quota_rule_id=test_rule["id"])
    ```


    :param builtins.str file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
    :param builtins.str quota_rule_id: The identifier of the quota rule. It is the base64 encoded string of the tuple <principalId, principalType, isHardQuota>.
    """
    __args__ = dict()
    __args__['areViolatorsOnly'] = are_violators_only
    __args__['fileSystemId'] = file_system_id
    __args__['quotaRuleId'] = quota_rule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FileStorage/getFileSystemQuotaRule:getFileSystemQuotaRule', __args__, opts=opts, typ=GetFileSystemQuotaRuleResult).value

    return AwaitableGetFileSystemQuotaRuleResult(
        are_violators_only=pulumi.get(__ret__, 'are_violators_only'),
        display_name=pulumi.get(__ret__, 'display_name'),
        file_system_id=pulumi.get(__ret__, 'file_system_id'),
        id=pulumi.get(__ret__, 'id'),
        is_hard_quota=pulumi.get(__ret__, 'is_hard_quota'),
        principal_id=pulumi.get(__ret__, 'principal_id'),
        principal_type=pulumi.get(__ret__, 'principal_type'),
        quota_limit_in_gigabytes=pulumi.get(__ret__, 'quota_limit_in_gigabytes'),
        quota_rule_id=pulumi.get(__ret__, 'quota_rule_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_file_system_quota_rule_output(are_violators_only: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      file_system_id: Optional[pulumi.Input[builtins.str]] = None,
                                      quota_rule_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFileSystemQuotaRuleResult]:
    """
    This data source provides details about a specific File System Quota Rule resource in Oracle Cloud Infrastructure File Storage service.

    Get an FS level, user or group quota rule given the `fileSystemId` and `quotaRuleId` parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_file_system_quota_rule = oci.FileStorage.get_file_system_quota_rule(file_system_id=test_file_system["id"],
        quota_rule_id=test_rule["id"])
    ```


    :param builtins.str file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
    :param builtins.str quota_rule_id: The identifier of the quota rule. It is the base64 encoded string of the tuple <principalId, principalType, isHardQuota>.
    """
    __args__ = dict()
    __args__['areViolatorsOnly'] = are_violators_only
    __args__['fileSystemId'] = file_system_id
    __args__['quotaRuleId'] = quota_rule_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FileStorage/getFileSystemQuotaRule:getFileSystemQuotaRule', __args__, opts=opts, typ=GetFileSystemQuotaRuleResult)
    return __ret__.apply(lambda __response__: GetFileSystemQuotaRuleResult(
        are_violators_only=pulumi.get(__response__, 'are_violators_only'),
        display_name=pulumi.get(__response__, 'display_name'),
        file_system_id=pulumi.get(__response__, 'file_system_id'),
        id=pulumi.get(__response__, 'id'),
        is_hard_quota=pulumi.get(__response__, 'is_hard_quota'),
        principal_id=pulumi.get(__response__, 'principal_id'),
        principal_type=pulumi.get(__response__, 'principal_type'),
        quota_limit_in_gigabytes=pulumi.get(__response__, 'quota_limit_in_gigabytes'),
        quota_rule_id=pulumi.get(__response__, 'quota_rule_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
