# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCompliancePolicyRuleResult',
    'AwaitableGetCompliancePolicyRuleResult',
    'get_compliance_policy_rule',
    'get_compliance_policy_rule_output',
]

@pulumi.output_type
class GetCompliancePolicyRuleResult:
    """
    A collection of values returned by getCompliancePolicyRule.
    """
    def __init__(__self__, compartment_id=None, compliance_policy_id=None, compliance_policy_rule_id=None, defined_tags=None, display_name=None, freeform_tags=None, grace_period=None, id=None, lifecycle_details=None, patch_selections=None, patch_types=None, product_versions=None, severities=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compliance_policy_id and not isinstance(compliance_policy_id, str):
            raise TypeError("Expected argument 'compliance_policy_id' to be a str")
        pulumi.set(__self__, "compliance_policy_id", compliance_policy_id)
        if compliance_policy_rule_id and not isinstance(compliance_policy_rule_id, str):
            raise TypeError("Expected argument 'compliance_policy_rule_id' to be a str")
        pulumi.set(__self__, "compliance_policy_rule_id", compliance_policy_rule_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if grace_period and not isinstance(grace_period, str):
            raise TypeError("Expected argument 'grace_period' to be a str")
        pulumi.set(__self__, "grace_period", grace_period)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if patch_selections and not isinstance(patch_selections, list):
            raise TypeError("Expected argument 'patch_selections' to be a list")
        pulumi.set(__self__, "patch_selections", patch_selections)
        if patch_types and not isinstance(patch_types, list):
            raise TypeError("Expected argument 'patch_types' to be a list")
        pulumi.set(__self__, "patch_types", patch_types)
        if product_versions and not isinstance(product_versions, list):
            raise TypeError("Expected argument 'product_versions' to be a list")
        pulumi.set(__self__, "product_versions", product_versions)
        if severities and not isinstance(severities, list):
            raise TypeError("Expected argument 'severities' to be a list")
        pulumi.set(__self__, "severities", severities)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment the CompliancePolicyRule belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compliancePolicyId")
    def compliance_policy_id(self) -> builtins.str:
        """
        Unique OCID of the CompliancePolicy.
        """
        return pulumi.get(self, "compliance_policy_id")

    @property
    @pulumi.getter(name="compliancePolicyRuleId")
    def compliance_policy_rule_id(self) -> builtins.str:
        return pulumi.get(self, "compliance_policy_rule_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> builtins.str:
        """
        Grace period in days,weeks,months or years the exemption is applicable for the rule. This enables a grace period when Fleet Application Management doesn't report the product as noncompliant when patch is not applied.
        """
        return pulumi.get(self, "grace_period")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique OCID of the CompliancePolicyRule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message that describes the current state of the CompliancePolicyRule in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="patchSelections")
    def patch_selections(self) -> Sequence['outputs.GetCompliancePolicyRulePatchSelectionResult']:
        """
        Patch Selection Details
        """
        return pulumi.get(self, "patch_selections")

    @property
    @pulumi.getter(name="patchTypes")
    def patch_types(self) -> Sequence[builtins.str]:
        """
        PlatformConfiguration OCID for the patch type to which this CompliancePolicyRule applies.
        """
        return pulumi.get(self, "patch_types")

    @property
    @pulumi.getter(name="productVersions")
    def product_versions(self) -> Sequence['outputs.GetCompliancePolicyRuleProductVersionResult']:
        """
        A specific product version or a specific version and succeeding. Example: 12.1 or 12.1 and above for Oracle WebLogic Application server. The policy applies to the next version only, and not to other versions such as, 12.1.x.
        """
        return pulumi.get(self, "product_versions")

    @property
    @pulumi.getter
    def severities(self) -> Sequence[builtins.str]:
        """
        Severity to which this CompliancePolicyRule applies.
        """
        return pulumi.get(self, "severities")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the CompliancePolicyRule.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the CompliancePolicyRule was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the CompliancePolicyRule was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetCompliancePolicyRuleResult(GetCompliancePolicyRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCompliancePolicyRuleResult(
            compartment_id=self.compartment_id,
            compliance_policy_id=self.compliance_policy_id,
            compliance_policy_rule_id=self.compliance_policy_rule_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            grace_period=self.grace_period,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            patch_selections=self.patch_selections,
            patch_types=self.patch_types,
            product_versions=self.product_versions,
            severities=self.severities,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_compliance_policy_rule(compliance_policy_rule_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCompliancePolicyRuleResult:
    """
    This data source provides details about a specific Compliance Policy Rule resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets information about a CompliancePolicyRule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compliance_policy_rule = oci.FleetAppsManagement.get_compliance_policy_rule(compliance_policy_rule_id=test_compliance_policy_rule_oci_fleet_apps_management_compliance_policy_rule["id"])
    ```


    :param builtins.str compliance_policy_rule_id: unique CompliancePolicyRule identifier.
    """
    __args__ = dict()
    __args__['compliancePolicyRuleId'] = compliance_policy_rule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getCompliancePolicyRule:getCompliancePolicyRule', __args__, opts=opts, typ=GetCompliancePolicyRuleResult).value

    return AwaitableGetCompliancePolicyRuleResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compliance_policy_id=pulumi.get(__ret__, 'compliance_policy_id'),
        compliance_policy_rule_id=pulumi.get(__ret__, 'compliance_policy_rule_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        grace_period=pulumi.get(__ret__, 'grace_period'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        patch_selections=pulumi.get(__ret__, 'patch_selections'),
        patch_types=pulumi.get(__ret__, 'patch_types'),
        product_versions=pulumi.get(__ret__, 'product_versions'),
        severities=pulumi.get(__ret__, 'severities'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_compliance_policy_rule_output(compliance_policy_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCompliancePolicyRuleResult]:
    """
    This data source provides details about a specific Compliance Policy Rule resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets information about a CompliancePolicyRule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compliance_policy_rule = oci.FleetAppsManagement.get_compliance_policy_rule(compliance_policy_rule_id=test_compliance_policy_rule_oci_fleet_apps_management_compliance_policy_rule["id"])
    ```


    :param builtins.str compliance_policy_rule_id: unique CompliancePolicyRule identifier.
    """
    __args__ = dict()
    __args__['compliancePolicyRuleId'] = compliance_policy_rule_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getCompliancePolicyRule:getCompliancePolicyRule', __args__, opts=opts, typ=GetCompliancePolicyRuleResult)
    return __ret__.apply(lambda __response__: GetCompliancePolicyRuleResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compliance_policy_id=pulumi.get(__response__, 'compliance_policy_id'),
        compliance_policy_rule_id=pulumi.get(__response__, 'compliance_policy_rule_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        grace_period=pulumi.get(__response__, 'grace_period'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        patch_selections=pulumi.get(__response__, 'patch_selections'),
        patch_types=pulumi.get(__response__, 'patch_types'),
        product_versions=pulumi.get(__response__, 'product_versions'),
        severities=pulumi.get(__response__, 'severities'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
