# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPatchResult',
    'AwaitableGetPatchResult',
    'get_patch',
    'get_patch_output',
]

@pulumi.output_type
class GetPatchResult:
    """
    A collection of values returned by getPatch.
    """
    def __init__(__self__, artifact_details=None, compartment_id=None, defined_tags=None, dependent_patches=None, description=None, freeform_tags=None, id=None, lifecycle_details=None, name=None, patch_id=None, patch_types=None, products=None, resource_region=None, severity=None, state=None, system_tags=None, time_created=None, time_released=None, time_updated=None, type=None):
        if artifact_details and not isinstance(artifact_details, list):
            raise TypeError("Expected argument 'artifact_details' to be a list")
        pulumi.set(__self__, "artifact_details", artifact_details)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if dependent_patches and not isinstance(dependent_patches, list):
            raise TypeError("Expected argument 'dependent_patches' to be a list")
        pulumi.set(__self__, "dependent_patches", dependent_patches)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if patch_id and not isinstance(patch_id, str):
            raise TypeError("Expected argument 'patch_id' to be a str")
        pulumi.set(__self__, "patch_id", patch_id)
        if patch_types and not isinstance(patch_types, list):
            raise TypeError("Expected argument 'patch_types' to be a list")
        pulumi.set(__self__, "patch_types", patch_types)
        if products and not isinstance(products, list):
            raise TypeError("Expected argument 'products' to be a list")
        pulumi.set(__self__, "products", products)
        if resource_region and not isinstance(resource_region, str):
            raise TypeError("Expected argument 'resource_region' to be a str")
        pulumi.set(__self__, "resource_region", resource_region)
        if severity and not isinstance(severity, str):
            raise TypeError("Expected argument 'severity' to be a str")
        pulumi.set(__self__, "severity", severity)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_released and not isinstance(time_released, str):
            raise TypeError("Expected argument 'time_released' to be a str")
        pulumi.set(__self__, "time_released", time_released)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="artifactDetails")
    def artifact_details(self) -> Sequence['outputs.GetPatchArtifactDetailResult']:
        """
        Patch artifact description and content details.
        """
        return pulumi.get(self, "artifact_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="dependentPatches")
    def dependent_patches(self) -> Sequence['outputs.GetPatchDependentPatchResult']:
        """
        Dependent Patches for this patch.
        """
        return pulumi.get(self, "dependent_patches")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A user-friendly name. Should be unique within the tenancy, and cannot be changed after creation.  Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="patchId")
    def patch_id(self) -> builtins.str:
        return pulumi.get(self, "patch_id")

    @property
    @pulumi.getter(name="patchTypes")
    def patch_types(self) -> Sequence['outputs.GetPatchPatchTypeResult']:
        """
        Patch Type
        """
        return pulumi.get(self, "patch_types")

    @property
    @pulumi.getter
    def products(self) -> Sequence['outputs.GetPatchProductResult']:
        """
        Product
        """
        return pulumi.get(self, "products")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> builtins.str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter
    def severity(self) -> builtins.str:
        """
        Patch Severity.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the Patch.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> builtins.str:
        """
        Date when the patch was released.
        """
        return pulumi.get(self, "time_released")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Provide information on who defined the patch. Example: For Custom Patches the value will be USER_DEFINED For Oracle Defined Patches the value will be ORACLE_DEFINED
        """
        return pulumi.get(self, "type")


class AwaitableGetPatchResult(GetPatchResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPatchResult(
            artifact_details=self.artifact_details,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            dependent_patches=self.dependent_patches,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            name=self.name,
            patch_id=self.patch_id,
            patch_types=self.patch_types,
            products=self.products,
            resource_region=self.resource_region,
            severity=self.severity,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_released=self.time_released,
            time_updated=self.time_updated,
            type=self.type)


def get_patch(patch_id: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPatchResult:
    """
    This data source provides details about a specific Patch resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a Patch by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_patch = oci.FleetAppsManagement.get_patch(patch_id=test_patch_oci_fleet_apps_management_patch["id"])
    ```


    :param builtins.str patch_id: unique Patch identifier
    """
    __args__ = dict()
    __args__['patchId'] = patch_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getPatch:getPatch', __args__, opts=opts, typ=GetPatchResult).value

    return AwaitableGetPatchResult(
        artifact_details=pulumi.get(__ret__, 'artifact_details'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        dependent_patches=pulumi.get(__ret__, 'dependent_patches'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        name=pulumi.get(__ret__, 'name'),
        patch_id=pulumi.get(__ret__, 'patch_id'),
        patch_types=pulumi.get(__ret__, 'patch_types'),
        products=pulumi.get(__ret__, 'products'),
        resource_region=pulumi.get(__ret__, 'resource_region'),
        severity=pulumi.get(__ret__, 'severity'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_released=pulumi.get(__ret__, 'time_released'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'))
def get_patch_output(patch_id: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPatchResult]:
    """
    This data source provides details about a specific Patch resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a Patch by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_patch = oci.FleetAppsManagement.get_patch(patch_id=test_patch_oci_fleet_apps_management_patch["id"])
    ```


    :param builtins.str patch_id: unique Patch identifier
    """
    __args__ = dict()
    __args__['patchId'] = patch_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getPatch:getPatch', __args__, opts=opts, typ=GetPatchResult)
    return __ret__.apply(lambda __response__: GetPatchResult(
        artifact_details=pulumi.get(__response__, 'artifact_details'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        dependent_patches=pulumi.get(__response__, 'dependent_patches'),
        description=pulumi.get(__response__, 'description'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        name=pulumi.get(__response__, 'name'),
        patch_id=pulumi.get(__response__, 'patch_id'),
        patch_types=pulumi.get(__response__, 'patch_types'),
        products=pulumi.get(__response__, 'products'),
        resource_region=pulumi.get(__response__, 'resource_region'),
        severity=pulumi.get(__response__, 'severity'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_released=pulumi.get(__response__, 'time_released'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type')))
