# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPatchesResult',
    'AwaitableGetPatchesResult',
    'get_patches',
    'get_patches_output',
]

@pulumi.output_type
class GetPatchesResult:
    """
    A collection of values returned by getPatches.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, patch_collections=None, patch_type_id=None, product_id=None, should_compliance_policy_rules_be_applied=None, state=None, time_released_greater_than_or_equal_to=None, time_released_less_than=None, type=None, version=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if patch_collections and not isinstance(patch_collections, list):
            raise TypeError("Expected argument 'patch_collections' to be a list")
        pulumi.set(__self__, "patch_collections", patch_collections)
        if patch_type_id and not isinstance(patch_type_id, str):
            raise TypeError("Expected argument 'patch_type_id' to be a str")
        pulumi.set(__self__, "patch_type_id", patch_type_id)
        if product_id and not isinstance(product_id, str):
            raise TypeError("Expected argument 'product_id' to be a str")
        pulumi.set(__self__, "product_id", product_id)
        if should_compliance_policy_rules_be_applied and not isinstance(should_compliance_policy_rules_be_applied, bool):
            raise TypeError("Expected argument 'should_compliance_policy_rules_be_applied' to be a bool")
        pulumi.set(__self__, "should_compliance_policy_rules_be_applied", should_compliance_policy_rules_be_applied)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_released_greater_than_or_equal_to and not isinstance(time_released_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_released_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_released_greater_than_or_equal_to", time_released_greater_than_or_equal_to)
        if time_released_less_than and not isinstance(time_released_less_than, str):
            raise TypeError("Expected argument 'time_released_less_than' to be a str")
        pulumi.set(__self__, "time_released_less_than", time_released_less_than)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPatchesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Should be unique within the tenancy, and cannot be changed after creation.  Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="patchCollections")
    def patch_collections(self) -> Sequence['outputs.GetPatchesPatchCollectionResult']:
        """
        The list of patch_collection.
        """
        return pulumi.get(self, "patch_collections")

    @property
    @pulumi.getter(name="patchTypeId")
    def patch_type_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "patch_type_id")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="shouldCompliancePolicyRulesBeApplied")
    def should_compliance_policy_rules_be_applied(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "should_compliance_policy_rules_be_applied")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Patch.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeReleasedGreaterThanOrEqualTo")
    def time_released_greater_than_or_equal_to(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_released_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeReleasedLessThan")
    def time_released_less_than(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_released_less_than")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Provide information on who defined the patch. Example: For Custom Patches the value will be USER_DEFINED For Oracle Defined Patches the value will be ORACLE_DEFINED
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        product version.
        """
        return pulumi.get(self, "version")


class AwaitableGetPatchesResult(GetPatchesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPatchesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            patch_collections=self.patch_collections,
            patch_type_id=self.patch_type_id,
            product_id=self.product_id,
            should_compliance_policy_rules_be_applied=self.should_compliance_policy_rules_be_applied,
            state=self.state,
            time_released_greater_than_or_equal_to=self.time_released_greater_than_or_equal_to,
            time_released_less_than=self.time_released_less_than,
            type=self.type,
            version=self.version)


def get_patches(compartment_id: Optional[builtins.str] = None,
                filters: Optional[Sequence[Union['GetPatchesFilterArgs', 'GetPatchesFilterArgsDict']]] = None,
                id: Optional[builtins.str] = None,
                name: Optional[builtins.str] = None,
                patch_type_id: Optional[builtins.str] = None,
                product_id: Optional[builtins.str] = None,
                should_compliance_policy_rules_be_applied: Optional[builtins.bool] = None,
                state: Optional[builtins.str] = None,
                time_released_greater_than_or_equal_to: Optional[builtins.str] = None,
                time_released_less_than: Optional[builtins.str] = None,
                type: Optional[builtins.str] = None,
                version: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPatchesResult:
    """
    This data source provides the list of Patches in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of Patches.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_patches = oci.FleetAppsManagement.get_patches(compartment_id=compartment_id,
        id=patch_id,
        name=patch_name,
        patch_type_id=test_patch_type["id"],
        product_id=test_product["id"],
        should_compliance_policy_rules_be_applied=patch_should_compliance_policy_rules_be_applied,
        state=patch_state,
        time_released_greater_than_or_equal_to=patch_time_released_greater_than_or_equal_to,
        time_released_less_than=patch_time_released_less_than,
        type=patch_type,
        version=patch_version)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str id: unique Patch identifier
    :param builtins.str name: A filter to return only resources that match the entire name given.
    :param builtins.str patch_type_id: Patch Type platformConfigurationId associated with the Patch.
    :param builtins.str product_id: Product platformConfigurationId associated with the Patch.
    :param builtins.bool should_compliance_policy_rules_be_applied: Filter patch based on compliance policy rules for the Product
    :param builtins.str state: The current state of the Patch.
    :param builtins.str time_released_greater_than_or_equal_to: Patch Released Date
    :param builtins.str time_released_less_than: Patch Released Date
    :param builtins.str type: DefinedBy type.
    :param builtins.str version: Product version
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['patchTypeId'] = patch_type_id
    __args__['productId'] = product_id
    __args__['shouldCompliancePolicyRulesBeApplied'] = should_compliance_policy_rules_be_applied
    __args__['state'] = state
    __args__['timeReleasedGreaterThanOrEqualTo'] = time_released_greater_than_or_equal_to
    __args__['timeReleasedLessThan'] = time_released_less_than
    __args__['type'] = type
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getPatches:getPatches', __args__, opts=opts, typ=GetPatchesResult).value

    return AwaitableGetPatchesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        patch_collections=pulumi.get(__ret__, 'patch_collections'),
        patch_type_id=pulumi.get(__ret__, 'patch_type_id'),
        product_id=pulumi.get(__ret__, 'product_id'),
        should_compliance_policy_rules_be_applied=pulumi.get(__ret__, 'should_compliance_policy_rules_be_applied'),
        state=pulumi.get(__ret__, 'state'),
        time_released_greater_than_or_equal_to=pulumi.get(__ret__, 'time_released_greater_than_or_equal_to'),
        time_released_less_than=pulumi.get(__ret__, 'time_released_less_than'),
        type=pulumi.get(__ret__, 'type'),
        version=pulumi.get(__ret__, 'version'))
def get_patches_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPatchesFilterArgs', 'GetPatchesFilterArgsDict']]]]] = None,
                       id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       patch_type_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       product_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       should_compliance_policy_rules_be_applied: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                       state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       time_released_greater_than_or_equal_to: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       time_released_less_than: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPatchesResult]:
    """
    This data source provides the list of Patches in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of Patches.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_patches = oci.FleetAppsManagement.get_patches(compartment_id=compartment_id,
        id=patch_id,
        name=patch_name,
        patch_type_id=test_patch_type["id"],
        product_id=test_product["id"],
        should_compliance_policy_rules_be_applied=patch_should_compliance_policy_rules_be_applied,
        state=patch_state,
        time_released_greater_than_or_equal_to=patch_time_released_greater_than_or_equal_to,
        time_released_less_than=patch_time_released_less_than,
        type=patch_type,
        version=patch_version)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str id: unique Patch identifier
    :param builtins.str name: A filter to return only resources that match the entire name given.
    :param builtins.str patch_type_id: Patch Type platformConfigurationId associated with the Patch.
    :param builtins.str product_id: Product platformConfigurationId associated with the Patch.
    :param builtins.bool should_compliance_policy_rules_be_applied: Filter patch based on compliance policy rules for the Product
    :param builtins.str state: The current state of the Patch.
    :param builtins.str time_released_greater_than_or_equal_to: Patch Released Date
    :param builtins.str time_released_less_than: Patch Released Date
    :param builtins.str type: DefinedBy type.
    :param builtins.str version: Product version
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['patchTypeId'] = patch_type_id
    __args__['productId'] = product_id
    __args__['shouldCompliancePolicyRulesBeApplied'] = should_compliance_policy_rules_be_applied
    __args__['state'] = state
    __args__['timeReleasedGreaterThanOrEqualTo'] = time_released_greater_than_or_equal_to
    __args__['timeReleasedLessThan'] = time_released_less_than
    __args__['type'] = type
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getPatches:getPatches', __args__, opts=opts, typ=GetPatchesResult)
    return __ret__.apply(lambda __response__: GetPatchesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        patch_collections=pulumi.get(__response__, 'patch_collections'),
        patch_type_id=pulumi.get(__response__, 'patch_type_id'),
        product_id=pulumi.get(__response__, 'product_id'),
        should_compliance_policy_rules_be_applied=pulumi.get(__response__, 'should_compliance_policy_rules_be_applied'),
        state=pulumi.get(__response__, 'state'),
        time_released_greater_than_or_equal_to=pulumi.get(__response__, 'time_released_greater_than_or_equal_to'),
        time_released_less_than=pulumi.get(__response__, 'time_released_less_than'),
        type=pulumi.get(__response__, 'type'),
        version=pulumi.get(__response__, 'version')))
