# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEndpointResult',
    'AwaitableGetEndpointResult',
    'get_endpoint',
    'get_endpoint_output',
]

@pulumi.output_type
class GetEndpointResult:
    """
    A collection of values returned by getEndpoint.
    """
    def __init__(__self__, compartment_id=None, content_moderation_configs=None, dedicated_ai_cluster_id=None, defined_tags=None, description=None, display_name=None, endpoint_id=None, freeform_tags=None, id=None, lifecycle_details=None, model_id=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if content_moderation_configs and not isinstance(content_moderation_configs, list):
            raise TypeError("Expected argument 'content_moderation_configs' to be a list")
        pulumi.set(__self__, "content_moderation_configs", content_moderation_configs)
        if dedicated_ai_cluster_id and not isinstance(dedicated_ai_cluster_id, str):
            raise TypeError("Expected argument 'dedicated_ai_cluster_id' to be a str")
        pulumi.set(__self__, "dedicated_ai_cluster_id", dedicated_ai_cluster_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if endpoint_id and not isinstance(endpoint_id, str):
            raise TypeError("Expected argument 'endpoint_id' to be a str")
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if model_id and not isinstance(model_id, str):
            raise TypeError("Expected argument 'model_id' to be a str")
        pulumi.set(__self__, "model_id", model_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="contentModerationConfigs")
    def content_moderation_configs(self) -> Sequence['outputs.GetEndpointContentModerationConfigResult']:
        return pulumi.get(self, "content_moderation_configs")

    @property
    @pulumi.getter(name="dedicatedAiClusterId")
    def dedicated_ai_cluster_id(self) -> builtins.str:
        return pulumi.get(self, "dedicated_ai_cluster_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        An optional description of the endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> builtins.str:
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> builtins.str:
        """
        The OCID of the model that's used to create this endpoint.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time that the endpoint was updated in the format of an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetEndpointResult(GetEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEndpointResult(
            compartment_id=self.compartment_id,
            content_moderation_configs=self.content_moderation_configs,
            dedicated_ai_cluster_id=self.dedicated_ai_cluster_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            endpoint_id=self.endpoint_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            model_id=self.model_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_endpoint(endpoint_id: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEndpointResult:
    """
    This data source provides details about a specific Endpoint resource in Oracle Cloud Infrastructure Generative AI service.

    Gets information about an endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_endpoint = oci.GenerativeAi.get_endpoint(endpoint_id=test_endpoint_oci_generative_ai_endpoint["id"])
    ```


    :param builtins.str endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the endpoint.
    """
    __args__ = dict()
    __args__['endpointId'] = endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GenerativeAi/getEndpoint:getEndpoint', __args__, opts=opts, typ=GetEndpointResult).value

    return AwaitableGetEndpointResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        content_moderation_configs=pulumi.get(__ret__, 'content_moderation_configs'),
        dedicated_ai_cluster_id=pulumi.get(__ret__, 'dedicated_ai_cluster_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        endpoint_id=pulumi.get(__ret__, 'endpoint_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        model_id=pulumi.get(__ret__, 'model_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_endpoint_output(endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEndpointResult]:
    """
    This data source provides details about a specific Endpoint resource in Oracle Cloud Infrastructure Generative AI service.

    Gets information about an endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_endpoint = oci.GenerativeAi.get_endpoint(endpoint_id=test_endpoint_oci_generative_ai_endpoint["id"])
    ```


    :param builtins.str endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the endpoint.
    """
    __args__ = dict()
    __args__['endpointId'] = endpoint_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GenerativeAi/getEndpoint:getEndpoint', __args__, opts=opts, typ=GetEndpointResult)
    return __ret__.apply(lambda __response__: GetEndpointResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        content_moderation_configs=pulumi.get(__response__, 'content_moderation_configs'),
        dedicated_ai_cluster_id=pulumi.get(__response__, 'dedicated_ai_cluster_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        endpoint_id=pulumi.get(__response__, 'endpoint_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        model_id=pulumi.get(__response__, 'model_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
