# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ShardedDatabaseCatalogDetailArgs',
    'ShardedDatabaseCatalogDetailArgsDict',
    'ShardedDatabaseCatalogDetailEncryptionKeyDetailsArgs',
    'ShardedDatabaseCatalogDetailEncryptionKeyDetailsArgsDict',
    'ShardedDatabaseConnectionStringArgs',
    'ShardedDatabaseConnectionStringArgsDict',
    'ShardedDatabaseGsmArgs',
    'ShardedDatabaseGsmArgsDict',
    'ShardedDatabasePatchOperationArgs',
    'ShardedDatabasePatchOperationArgsDict',
    'ShardedDatabaseShardDetailArgs',
    'ShardedDatabaseShardDetailArgsDict',
    'ShardedDatabaseShardDetailEncryptionKeyDetailsArgs',
    'ShardedDatabaseShardDetailEncryptionKeyDetailsArgsDict',
    'GetPrivateEndpointsFilterArgs',
    'GetPrivateEndpointsFilterArgsDict',
    'GetShardedDatabasesFilterArgs',
    'GetShardedDatabasesFilterArgsDict',
]

MYPY = False

if not MYPY:
    class ShardedDatabaseCatalogDetailArgsDict(TypedDict):
        admin_password: pulumi.Input[builtins.str]
        """
        Admin password for the catalog database.
        """
        cloud_autonomous_vm_cluster_id: pulumi.Input[builtins.str]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        """
        compute_count: pulumi.Input[builtins.float]
        """
        The compute count for the catalog database. It has to be in multiple of 2.
        """
        data_storage_size_in_gbs: pulumi.Input[builtins.float]
        """
        The data disk group size to be allocated in GBs for the catalog database.
        """
        is_auto_scaling_enabled: pulumi.Input[builtins.bool]
        """
        Determines the auto-scaling mode for the catalog database.
        """
        container_database_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Identifier of the underlying container database.
        """
        container_database_parent_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Identifier of the underlying container database parent.
        """
        encryption_key_details: NotRequired[pulumi.Input['ShardedDatabaseCatalogDetailEncryptionKeyDetailsArgsDict']]
        """
        Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails are not specified for catalog, then Oracle managed key will be used for catalog. For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
        """
        metadata: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Additional metadata related to shard's underlying supporting resource.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the shard.
        """
        peer_cloud_autonomous_vm_cluster_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        """
        shard_group: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the shard-group to which the shard belongs.
        """
        status: NotRequired[pulumi.Input[builtins.str]]
        """
        Status of shard or catalog or gsm for the sharded database.
        """
        supporting_resource_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Identifier of the underlying supporting resource.
        """
        time_created: NotRequired[pulumi.Input[builtins.str]]
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        time_ssl_certificate_expires: NotRequired[pulumi.Input[builtins.str]]
        """
        The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        """
        time_updated: NotRequired[pulumi.Input[builtins.str]]
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
elif False:
    ShardedDatabaseCatalogDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ShardedDatabaseCatalogDetailArgs:
    def __init__(__self__, *,
                 admin_password: pulumi.Input[builtins.str],
                 cloud_autonomous_vm_cluster_id: pulumi.Input[builtins.str],
                 compute_count: pulumi.Input[builtins.float],
                 data_storage_size_in_gbs: pulumi.Input[builtins.float],
                 is_auto_scaling_enabled: pulumi.Input[builtins.bool],
                 container_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 container_database_parent_id: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_key_details: Optional[pulumi.Input['ShardedDatabaseCatalogDetailEncryptionKeyDetailsArgs']] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peer_cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 shard_group: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 supporting_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_ssl_certificate_expires: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] admin_password: Admin password for the catalog database.
        :param pulumi.Input[builtins.str] cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.float] compute_count: The compute count for the catalog database. It has to be in multiple of 2.
        :param pulumi.Input[builtins.float] data_storage_size_in_gbs: The data disk group size to be allocated in GBs for the catalog database.
        :param pulumi.Input[builtins.bool] is_auto_scaling_enabled: Determines the auto-scaling mode for the catalog database.
        :param pulumi.Input[builtins.str] container_database_id: Identifier of the underlying container database.
        :param pulumi.Input[builtins.str] container_database_parent_id: Identifier of the underlying container database parent.
        :param pulumi.Input['ShardedDatabaseCatalogDetailEncryptionKeyDetailsArgs'] encryption_key_details: Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails are not specified for catalog, then Oracle managed key will be used for catalog. For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Additional metadata related to shard's underlying supporting resource.
        :param pulumi.Input[builtins.str] name: Name of the shard.
        :param pulumi.Input[builtins.str] peer_cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] shard_group: Name of the shard-group to which the shard belongs.
        :param pulumi.Input[builtins.str] status: Status of shard or catalog or gsm for the sharded database.
        :param pulumi.Input[builtins.str] supporting_resource_id: Identifier of the underlying supporting resource.
        :param pulumi.Input[builtins.str] time_created: The time the the Sharded Database was created. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_ssl_certificate_expires: The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_updated: The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "cloud_autonomous_vm_cluster_id", cloud_autonomous_vm_cluster_id)
        pulumi.set(__self__, "compute_count", compute_count)
        pulumi.set(__self__, "data_storage_size_in_gbs", data_storage_size_in_gbs)
        pulumi.set(__self__, "is_auto_scaling_enabled", is_auto_scaling_enabled)
        if container_database_id is not None:
            pulumi.set(__self__, "container_database_id", container_database_id)
        if container_database_parent_id is not None:
            pulumi.set(__self__, "container_database_parent_id", container_database_parent_id)
        if encryption_key_details is not None:
            pulumi.set(__self__, "encryption_key_details", encryption_key_details)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_cloud_autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "peer_cloud_autonomous_vm_cluster_id", peer_cloud_autonomous_vm_cluster_id)
        if shard_group is not None:
            pulumi.set(__self__, "shard_group", shard_group)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if supporting_resource_id is not None:
            pulumi.set(__self__, "supporting_resource_id", supporting_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_ssl_certificate_expires is not None:
            pulumi.set(__self__, "time_ssl_certificate_expires", time_ssl_certificate_expires)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Input[builtins.str]:
        """
        Admin password for the catalog database.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="cloudAutonomousVmClusterId")
    def cloud_autonomous_vm_cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "cloud_autonomous_vm_cluster_id")

    @cloud_autonomous_vm_cluster_id.setter
    def cloud_autonomous_vm_cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cloud_autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Input[builtins.float]:
        """
        The compute count for the catalog database. It has to be in multiple of 2.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "compute_count", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGbs")
    def data_storage_size_in_gbs(self) -> pulumi.Input[builtins.float]:
        """
        The data disk group size to be allocated in GBs for the catalog database.
        """
        return pulumi.get(self, "data_storage_size_in_gbs")

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "data_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Determines the auto-scaling mode for the catalog database.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @is_auto_scaling_enabled.setter
    def is_auto_scaling_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_auto_scaling_enabled", value)

    @property
    @pulumi.getter(name="containerDatabaseId")
    def container_database_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the underlying container database.
        """
        return pulumi.get(self, "container_database_id")

    @container_database_id.setter
    def container_database_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_database_id", value)

    @property
    @pulumi.getter(name="containerDatabaseParentId")
    def container_database_parent_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the underlying container database parent.
        """
        return pulumi.get(self, "container_database_parent_id")

    @container_database_parent_id.setter
    def container_database_parent_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_database_parent_id", value)

    @property
    @pulumi.getter(name="encryptionKeyDetails")
    def encryption_key_details(self) -> Optional[pulumi.Input['ShardedDatabaseCatalogDetailEncryptionKeyDetailsArgs']]:
        """
        Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails are not specified for catalog, then Oracle managed key will be used for catalog. For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
        """
        return pulumi.get(self, "encryption_key_details")

    @encryption_key_details.setter
    def encryption_key_details(self, value: Optional[pulumi.Input['ShardedDatabaseCatalogDetailEncryptionKeyDetailsArgs']]):
        pulumi.set(self, "encryption_key_details", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Additional metadata related to shard's underlying supporting resource.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the shard.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peerCloudAutonomousVmClusterId")
    def peer_cloud_autonomous_vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_cloud_autonomous_vm_cluster_id")

    @peer_cloud_autonomous_vm_cluster_id.setter
    def peer_cloud_autonomous_vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_cloud_autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="shardGroup")
    def shard_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the shard-group to which the shard belongs.
        """
        return pulumi.get(self, "shard_group")

    @shard_group.setter
    def shard_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shard_group", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of shard or catalog or gsm for the sharded database.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="supportingResourceId")
    def supporting_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the underlying supporting resource.
        """
        return pulumi.get(self, "supporting_resource_id")

    @supporting_resource_id.setter
    def supporting_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "supporting_resource_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeSslCertificateExpires")
    def time_ssl_certificate_expires(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_ssl_certificate_expires")

    @time_ssl_certificate_expires.setter
    def time_ssl_certificate_expires(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_ssl_certificate_expires", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


if not MYPY:
    class ShardedDatabaseCatalogDetailEncryptionKeyDetailsArgsDict(TypedDict):
        kms_key_id: pulumi.Input[builtins.str]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key in vault identified by vaultId in customer tenancy  that is used as the master encryption key.
        """
        vault_id: pulumi.Input[builtins.str]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vault in customer tenancy where KMS key is present. For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only, which is also replicated in the region of standby shard.
        """
        kms_key_version_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key version for key identified by kmsKeyId that is used in data encryption (TDE) operations.
        """
elif False:
    ShardedDatabaseCatalogDetailEncryptionKeyDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ShardedDatabaseCatalogDetailEncryptionKeyDetailsArgs:
    def __init__(__self__, *,
                 kms_key_id: pulumi.Input[builtins.str],
                 vault_id: pulumi.Input[builtins.str],
                 kms_key_version_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key in vault identified by vaultId in customer tenancy  that is used as the master encryption key.
        :param pulumi.Input[builtins.str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vault in customer tenancy where KMS key is present. For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only, which is also replicated in the region of standby shard.
        :param pulumi.Input[builtins.str] kms_key_version_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key version for key identified by kmsKeyId that is used in data encryption (TDE) operations.
        """
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "vault_id", vault_id)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key in vault identified by vaultId in customer tenancy  that is used as the master encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vault in customer tenancy where KMS key is present. For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only, which is also replicated in the region of standby shard.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key version for key identified by kmsKeyId that is used in data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_version_id")

    @kms_key_version_id.setter
    def kms_key_version_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_version_id", value)


if not MYPY:
    class ShardedDatabaseConnectionStringArgsDict(TypedDict):
        all_connection_strings: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Collection of connection strings.
        """
elif False:
    ShardedDatabaseConnectionStringArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ShardedDatabaseConnectionStringArgs:
    def __init__(__self__, *,
                 all_connection_strings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] all_connection_strings: Collection of connection strings.
        """
        if all_connection_strings is not None:
            pulumi.set(__self__, "all_connection_strings", all_connection_strings)

    @property
    @pulumi.getter(name="allConnectionStrings")
    def all_connection_strings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Collection of connection strings.
        """
        return pulumi.get(self, "all_connection_strings")

    @all_connection_strings.setter
    def all_connection_strings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "all_connection_strings", value)


if not MYPY:
    class ShardedDatabaseGsmArgsDict(TypedDict):
        compute_count: NotRequired[pulumi.Input[builtins.float]]
        """
        The compute amount available to the underlying autonomous database associated with shard.
        """
        data_storage_size_in_gbs: NotRequired[pulumi.Input[builtins.float]]
        """
        The data disk group size to be allocated in GBs.
        """
        metadata: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Additional metadata related to shard's underlying supporting resource.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the shard.
        """
        status: NotRequired[pulumi.Input[builtins.str]]
        """
        Status of shard or catalog or gsm for the sharded database.
        """
        supporting_resource_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Identifier of the underlying supporting resource.
        """
        time_created: NotRequired[pulumi.Input[builtins.str]]
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        time_ssl_certificate_expires: NotRequired[pulumi.Input[builtins.str]]
        """
        The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        """
        time_updated: NotRequired[pulumi.Input[builtins.str]]
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
elif False:
    ShardedDatabaseGsmArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ShardedDatabaseGsmArgs:
    def __init__(__self__, *,
                 compute_count: Optional[pulumi.Input[builtins.float]] = None,
                 data_storage_size_in_gbs: Optional[pulumi.Input[builtins.float]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 supporting_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_ssl_certificate_expires: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.float] compute_count: The compute amount available to the underlying autonomous database associated with shard.
        :param pulumi.Input[builtins.float] data_storage_size_in_gbs: The data disk group size to be allocated in GBs.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Additional metadata related to shard's underlying supporting resource.
        :param pulumi.Input[builtins.str] name: Name of the shard.
        :param pulumi.Input[builtins.str] status: Status of shard or catalog or gsm for the sharded database.
        :param pulumi.Input[builtins.str] supporting_resource_id: Identifier of the underlying supporting resource.
        :param pulumi.Input[builtins.str] time_created: The time the the Sharded Database was created. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_ssl_certificate_expires: The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_updated: The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if data_storage_size_in_gbs is not None:
            pulumi.set(__self__, "data_storage_size_in_gbs", data_storage_size_in_gbs)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if supporting_resource_id is not None:
            pulumi.set(__self__, "supporting_resource_id", supporting_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_ssl_certificate_expires is not None:
            pulumi.set(__self__, "time_ssl_certificate_expires", time_ssl_certificate_expires)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The compute amount available to the underlying autonomous database associated with shard.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "compute_count", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGbs")
    def data_storage_size_in_gbs(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The data disk group size to be allocated in GBs.
        """
        return pulumi.get(self, "data_storage_size_in_gbs")

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "data_storage_size_in_gbs", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Additional metadata related to shard's underlying supporting resource.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the shard.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of shard or catalog or gsm for the sharded database.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="supportingResourceId")
    def supporting_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the underlying supporting resource.
        """
        return pulumi.get(self, "supporting_resource_id")

    @supporting_resource_id.setter
    def supporting_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "supporting_resource_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeSslCertificateExpires")
    def time_ssl_certificate_expires(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_ssl_certificate_expires")

    @time_ssl_certificate_expires.setter
    def time_ssl_certificate_expires(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_ssl_certificate_expires", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


if not MYPY:
    class ShardedDatabasePatchOperationArgsDict(TypedDict):
        operation: pulumi.Input[builtins.str]
        """
        (Updatable) The operation can be one of these values: `INSERT`, `MERGE`, `REMOVE`
        """
        selection: pulumi.Input[builtins.str]
        """
        (Updatable)
        """
        value: pulumi.Input[builtins.str]
        """
        (Updatable)
        """
elif False:
    ShardedDatabasePatchOperationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ShardedDatabasePatchOperationArgs:
    def __init__(__self__, *,
                 operation: pulumi.Input[builtins.str],
                 selection: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] operation: (Updatable) The operation can be one of these values: `INSERT`, `MERGE`, `REMOVE`
        :param pulumi.Input[builtins.str] selection: (Updatable)
        :param pulumi.Input[builtins.str] value: (Updatable)
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "selection", selection)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The operation can be one of these values: `INSERT`, `MERGE`, `REMOVE`
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def selection(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable)
        """
        return pulumi.get(self, "selection")

    @selection.setter
    def selection(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "selection", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable)
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ShardedDatabaseShardDetailArgsDict(TypedDict):
        admin_password: pulumi.Input[builtins.str]
        """
        Admin password for shard database.
        """
        cloud_autonomous_vm_cluster_id: pulumi.Input[builtins.str]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        """
        compute_count: pulumi.Input[builtins.float]
        """
        The compute count for the shard database. It has to be in multiples of 2.
        """
        data_storage_size_in_gbs: pulumi.Input[builtins.float]
        """
        The data disk group size to be allocated in GBs for the shard database.
        """
        is_auto_scaling_enabled: pulumi.Input[builtins.bool]
        """
        Determines the auto-scaling mode for the shard database.
        """
        container_database_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Identifier of the underlying container database.
        """
        container_database_parent_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Identifier of the underlying container database parent.
        """
        encryption_key_details: NotRequired[pulumi.Input['ShardedDatabaseShardDetailEncryptionKeyDetailsArgsDict']]
        """
        Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails are not specified for catalog, then Oracle managed key will be used for catalog. For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
        """
        metadata: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Additional metadata related to shard's underlying supporting resource.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the shard.
        """
        peer_cloud_autonomous_vm_cluster_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        """
        shard_group: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the shard-group to which the shard belongs.
        """
        shard_space: NotRequired[pulumi.Input[builtins.str]]
        """
        The shard space name for the shard database. Shard space for existing shard cannot be changed, once shard is created. Shard space name shall be used while creation of new shards. For User defined sharding, every shard must have a unique shard space name. For system defined sharding, shard space name is not required.
        """
        status: NotRequired[pulumi.Input[builtins.str]]
        """
        Status of shard or catalog or gsm for the sharded database.
        """
        supporting_resource_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Identifier of the underlying supporting resource.
        """
        time_created: NotRequired[pulumi.Input[builtins.str]]
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        time_ssl_certificate_expires: NotRequired[pulumi.Input[builtins.str]]
        """
        The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        """
        time_updated: NotRequired[pulumi.Input[builtins.str]]
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
elif False:
    ShardedDatabaseShardDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ShardedDatabaseShardDetailArgs:
    def __init__(__self__, *,
                 admin_password: pulumi.Input[builtins.str],
                 cloud_autonomous_vm_cluster_id: pulumi.Input[builtins.str],
                 compute_count: pulumi.Input[builtins.float],
                 data_storage_size_in_gbs: pulumi.Input[builtins.float],
                 is_auto_scaling_enabled: pulumi.Input[builtins.bool],
                 container_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 container_database_parent_id: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_key_details: Optional[pulumi.Input['ShardedDatabaseShardDetailEncryptionKeyDetailsArgs']] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peer_cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 shard_group: Optional[pulumi.Input[builtins.str]] = None,
                 shard_space: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 supporting_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_ssl_certificate_expires: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] admin_password: Admin password for shard database.
        :param pulumi.Input[builtins.str] cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.float] compute_count: The compute count for the shard database. It has to be in multiples of 2.
        :param pulumi.Input[builtins.float] data_storage_size_in_gbs: The data disk group size to be allocated in GBs for the shard database.
        :param pulumi.Input[builtins.bool] is_auto_scaling_enabled: Determines the auto-scaling mode for the shard database.
        :param pulumi.Input[builtins.str] container_database_id: Identifier of the underlying container database.
        :param pulumi.Input[builtins.str] container_database_parent_id: Identifier of the underlying container database parent.
        :param pulumi.Input['ShardedDatabaseShardDetailEncryptionKeyDetailsArgs'] encryption_key_details: Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails are not specified for catalog, then Oracle managed key will be used for catalog. For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Additional metadata related to shard's underlying supporting resource.
        :param pulumi.Input[builtins.str] name: Name of the shard.
        :param pulumi.Input[builtins.str] peer_cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] shard_group: Name of the shard-group to which the shard belongs.
        :param pulumi.Input[builtins.str] shard_space: The shard space name for the shard database. Shard space for existing shard cannot be changed, once shard is created. Shard space name shall be used while creation of new shards. For User defined sharding, every shard must have a unique shard space name. For system defined sharding, shard space name is not required.
        :param pulumi.Input[builtins.str] status: Status of shard or catalog or gsm for the sharded database.
        :param pulumi.Input[builtins.str] supporting_resource_id: Identifier of the underlying supporting resource.
        :param pulumi.Input[builtins.str] time_created: The time the the Sharded Database was created. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_ssl_certificate_expires: The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_updated: The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "cloud_autonomous_vm_cluster_id", cloud_autonomous_vm_cluster_id)
        pulumi.set(__self__, "compute_count", compute_count)
        pulumi.set(__self__, "data_storage_size_in_gbs", data_storage_size_in_gbs)
        pulumi.set(__self__, "is_auto_scaling_enabled", is_auto_scaling_enabled)
        if container_database_id is not None:
            pulumi.set(__self__, "container_database_id", container_database_id)
        if container_database_parent_id is not None:
            pulumi.set(__self__, "container_database_parent_id", container_database_parent_id)
        if encryption_key_details is not None:
            pulumi.set(__self__, "encryption_key_details", encryption_key_details)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_cloud_autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "peer_cloud_autonomous_vm_cluster_id", peer_cloud_autonomous_vm_cluster_id)
        if shard_group is not None:
            pulumi.set(__self__, "shard_group", shard_group)
        if shard_space is not None:
            pulumi.set(__self__, "shard_space", shard_space)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if supporting_resource_id is not None:
            pulumi.set(__self__, "supporting_resource_id", supporting_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_ssl_certificate_expires is not None:
            pulumi.set(__self__, "time_ssl_certificate_expires", time_ssl_certificate_expires)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Input[builtins.str]:
        """
        Admin password for shard database.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="cloudAutonomousVmClusterId")
    def cloud_autonomous_vm_cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "cloud_autonomous_vm_cluster_id")

    @cloud_autonomous_vm_cluster_id.setter
    def cloud_autonomous_vm_cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cloud_autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Input[builtins.float]:
        """
        The compute count for the shard database. It has to be in multiples of 2.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "compute_count", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGbs")
    def data_storage_size_in_gbs(self) -> pulumi.Input[builtins.float]:
        """
        The data disk group size to be allocated in GBs for the shard database.
        """
        return pulumi.get(self, "data_storage_size_in_gbs")

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "data_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Determines the auto-scaling mode for the shard database.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @is_auto_scaling_enabled.setter
    def is_auto_scaling_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_auto_scaling_enabled", value)

    @property
    @pulumi.getter(name="containerDatabaseId")
    def container_database_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the underlying container database.
        """
        return pulumi.get(self, "container_database_id")

    @container_database_id.setter
    def container_database_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_database_id", value)

    @property
    @pulumi.getter(name="containerDatabaseParentId")
    def container_database_parent_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the underlying container database parent.
        """
        return pulumi.get(self, "container_database_parent_id")

    @container_database_parent_id.setter
    def container_database_parent_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_database_parent_id", value)

    @property
    @pulumi.getter(name="encryptionKeyDetails")
    def encryption_key_details(self) -> Optional[pulumi.Input['ShardedDatabaseShardDetailEncryptionKeyDetailsArgs']]:
        """
        Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails are not specified for catalog, then Oracle managed key will be used for catalog. For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
        """
        return pulumi.get(self, "encryption_key_details")

    @encryption_key_details.setter
    def encryption_key_details(self, value: Optional[pulumi.Input['ShardedDatabaseShardDetailEncryptionKeyDetailsArgs']]):
        pulumi.set(self, "encryption_key_details", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Additional metadata related to shard's underlying supporting resource.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the shard.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peerCloudAutonomousVmClusterId")
    def peer_cloud_autonomous_vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_cloud_autonomous_vm_cluster_id")

    @peer_cloud_autonomous_vm_cluster_id.setter
    def peer_cloud_autonomous_vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_cloud_autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="shardGroup")
    def shard_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the shard-group to which the shard belongs.
        """
        return pulumi.get(self, "shard_group")

    @shard_group.setter
    def shard_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shard_group", value)

    @property
    @pulumi.getter(name="shardSpace")
    def shard_space(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The shard space name for the shard database. Shard space for existing shard cannot be changed, once shard is created. Shard space name shall be used while creation of new shards. For User defined sharding, every shard must have a unique shard space name. For system defined sharding, shard space name is not required.
        """
        return pulumi.get(self, "shard_space")

    @shard_space.setter
    def shard_space(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shard_space", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of shard or catalog or gsm for the sharded database.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="supportingResourceId")
    def supporting_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the underlying supporting resource.
        """
        return pulumi.get(self, "supporting_resource_id")

    @supporting_resource_id.setter
    def supporting_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "supporting_resource_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeSslCertificateExpires")
    def time_ssl_certificate_expires(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_ssl_certificate_expires")

    @time_ssl_certificate_expires.setter
    def time_ssl_certificate_expires(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_ssl_certificate_expires", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


if not MYPY:
    class ShardedDatabaseShardDetailEncryptionKeyDetailsArgsDict(TypedDict):
        kms_key_id: pulumi.Input[builtins.str]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key in vault identified by vaultId in customer tenancy  that is used as the master encryption key.
        """
        vault_id: pulumi.Input[builtins.str]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vault in customer tenancy where KMS key is present. For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only, which is also replicated in the region of standby shard.
        """
        kms_key_version_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key version for key identified by kmsKeyId that is used in data encryption (TDE) operations.
        """
elif False:
    ShardedDatabaseShardDetailEncryptionKeyDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ShardedDatabaseShardDetailEncryptionKeyDetailsArgs:
    def __init__(__self__, *,
                 kms_key_id: pulumi.Input[builtins.str],
                 vault_id: pulumi.Input[builtins.str],
                 kms_key_version_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key in vault identified by vaultId in customer tenancy  that is used as the master encryption key.
        :param pulumi.Input[builtins.str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vault in customer tenancy where KMS key is present. For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only, which is also replicated in the region of standby shard.
        :param pulumi.Input[builtins.str] kms_key_version_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key version for key identified by kmsKeyId that is used in data encryption (TDE) operations.
        """
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "vault_id", vault_id)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key in vault identified by vaultId in customer tenancy  that is used as the master encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vault in customer tenancy where KMS key is present. For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only, which is also replicated in the region of standby shard.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key version for key identified by kmsKeyId that is used in data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_version_id")

    @kms_key_version_id.setter
    def kms_key_version_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_version_id", value)


if not MYPY:
    class GetPrivateEndpointsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetPrivateEndpointsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPrivateEndpointsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetShardedDatabasesFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Name of the shard.
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetShardedDatabasesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetShardedDatabasesFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name of the shard.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the shard.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


