# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPipelineRunningProcessesResult',
    'AwaitableGetPipelineRunningProcessesResult',
    'get_pipeline_running_processes',
    'get_pipeline_running_processes_output',
]

@pulumi.output_type
class GetPipelineRunningProcessesResult:
    """
    A collection of values returned by getPipelineRunningProcesses.
    """
    def __init__(__self__, filters=None, id=None, pipeline_id=None, pipeline_running_process_collections=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if pipeline_id and not isinstance(pipeline_id, str):
            raise TypeError("Expected argument 'pipeline_id' to be a str")
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        if pipeline_running_process_collections and not isinstance(pipeline_running_process_collections, list):
            raise TypeError("Expected argument 'pipeline_running_process_collections' to be a list")
        pulumi.set(__self__, "pipeline_running_process_collections", pipeline_running_process_collections)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPipelineRunningProcessesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> builtins.str:
        return pulumi.get(self, "pipeline_id")

    @property
    @pulumi.getter(name="pipelineRunningProcessCollections")
    def pipeline_running_process_collections(self) -> Sequence['outputs.GetPipelineRunningProcessesPipelineRunningProcessCollectionResult']:
        """
        The list of pipeline_running_process_collection.
        """
        return pulumi.get(self, "pipeline_running_process_collections")


class AwaitableGetPipelineRunningProcessesResult(GetPipelineRunningProcessesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPipelineRunningProcessesResult(
            filters=self.filters,
            id=self.id,
            pipeline_id=self.pipeline_id,
            pipeline_running_process_collections=self.pipeline_running_process_collections)


def get_pipeline_running_processes(filters: Optional[Sequence[Union['GetPipelineRunningProcessesFilterArgs', 'GetPipelineRunningProcessesFilterArgsDict']]] = None,
                                   pipeline_id: Optional[builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPipelineRunningProcessesResult:
    """
    This data source provides the list of Pipeline Running Processes in Oracle Cloud Infrastructure Golden Gate service.

    Retrieves a Pipeline's running replication process's status like Capture/Apply.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pipeline_running_processes = oci.GoldenGate.get_pipeline_running_processes(pipeline_id=test_pipeline["id"])
    ```


    :param builtins.str pipeline_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline created.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['pipelineId'] = pipeline_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getPipelineRunningProcesses:getPipelineRunningProcesses', __args__, opts=opts, typ=GetPipelineRunningProcessesResult).value

    return AwaitableGetPipelineRunningProcessesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        pipeline_id=pulumi.get(__ret__, 'pipeline_id'),
        pipeline_running_process_collections=pulumi.get(__ret__, 'pipeline_running_process_collections'))
def get_pipeline_running_processes_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPipelineRunningProcessesFilterArgs', 'GetPipelineRunningProcessesFilterArgsDict']]]]] = None,
                                          pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPipelineRunningProcessesResult]:
    """
    This data source provides the list of Pipeline Running Processes in Oracle Cloud Infrastructure Golden Gate service.

    Retrieves a Pipeline's running replication process's status like Capture/Apply.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pipeline_running_processes = oci.GoldenGate.get_pipeline_running_processes(pipeline_id=test_pipeline["id"])
    ```


    :param builtins.str pipeline_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline created.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['pipelineId'] = pipeline_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getPipelineRunningProcesses:getPipelineRunningProcesses', __args__, opts=opts, typ=GetPipelineRunningProcessesResult)
    return __ret__.apply(lambda __response__: GetPipelineRunningProcessesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        pipeline_id=pulumi.get(__response__, 'pipeline_id'),
        pipeline_running_process_collections=pulumi.get(__response__, 'pipeline_running_process_collections')))
