# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPingProbeResultsResult',
    'AwaitableGetPingProbeResultsResult',
    'get_ping_probe_results',
    'get_ping_probe_results_output',
]

@pulumi.output_type
class GetPingProbeResultsResult:
    """
    A collection of values returned by getPingProbeResults.
    """
    def __init__(__self__, filters=None, id=None, ping_probe_results=None, probe_configuration_id=None, start_time_greater_than_or_equal_to=None, start_time_less_than_or_equal_to=None, target=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ping_probe_results and not isinstance(ping_probe_results, list):
            raise TypeError("Expected argument 'ping_probe_results' to be a list")
        pulumi.set(__self__, "ping_probe_results", ping_probe_results)
        if probe_configuration_id and not isinstance(probe_configuration_id, str):
            raise TypeError("Expected argument 'probe_configuration_id' to be a str")
        pulumi.set(__self__, "probe_configuration_id", probe_configuration_id)
        if start_time_greater_than_or_equal_to and not isinstance(start_time_greater_than_or_equal_to, float):
            raise TypeError("Expected argument 'start_time_greater_than_or_equal_to' to be a float")
        pulumi.set(__self__, "start_time_greater_than_or_equal_to", start_time_greater_than_or_equal_to)
        if start_time_less_than_or_equal_to and not isinstance(start_time_less_than_or_equal_to, float):
            raise TypeError("Expected argument 'start_time_less_than_or_equal_to' to be a float")
        pulumi.set(__self__, "start_time_less_than_or_equal_to", start_time_less_than_or_equal_to)
        if target and not isinstance(target, str):
            raise TypeError("Expected argument 'target' to be a str")
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPingProbeResultsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="pingProbeResults")
    def ping_probe_results(self) -> Sequence['outputs.GetPingProbeResultsPingProbeResultResult']:
        """
        The list of ping_probe_results.
        """
        return pulumi.get(self, "ping_probe_results")

    @property
    @pulumi.getter(name="probeConfigurationId")
    def probe_configuration_id(self) -> builtins.str:
        """
        The OCID of the monitor or on-demand probe responsible for creating this result.
        """
        return pulumi.get(self, "probe_configuration_id")

    @property
    @pulumi.getter(name="startTimeGreaterThanOrEqualTo")
    def start_time_greater_than_or_equal_to(self) -> Optional[builtins.float]:
        return pulumi.get(self, "start_time_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="startTimeLessThanOrEqualTo")
    def start_time_less_than_or_equal_to(self) -> Optional[builtins.float]:
        return pulumi.get(self, "start_time_less_than_or_equal_to")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.str]:
        """
        The target hostname or IP address of the probe.
        """
        return pulumi.get(self, "target")


class AwaitableGetPingProbeResultsResult(GetPingProbeResultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPingProbeResultsResult(
            filters=self.filters,
            id=self.id,
            ping_probe_results=self.ping_probe_results,
            probe_configuration_id=self.probe_configuration_id,
            start_time_greater_than_or_equal_to=self.start_time_greater_than_or_equal_to,
            start_time_less_than_or_equal_to=self.start_time_less_than_or_equal_to,
            target=self.target)


def get_ping_probe_results(filters: Optional[Sequence[Union['GetPingProbeResultsFilterArgs', 'GetPingProbeResultsFilterArgsDict']]] = None,
                           probe_configuration_id: Optional[builtins.str] = None,
                           start_time_greater_than_or_equal_to: Optional[builtins.float] = None,
                           start_time_less_than_or_equal_to: Optional[builtins.float] = None,
                           target: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPingProbeResultsResult:
    """
    This data source provides the list of Ping Probe Results in Oracle Cloud Infrastructure Health Checks service.

    Returns the results for the specified probe, where the `probeConfigurationId`
    is the OCID of either a monitor or an on-demand probe.

    Results are paginated based on `page` and `limit`.  The `opc-next-page` header provides
    a URL for fetching the next page.  Use `sortOrder` to set the order of the
    results.  If `sortOrder` is unspecified, results are sorted in ascending order by
    `startTime`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ping_probe_results = oci.HealthChecks.get_ping_probe_results(probe_configuration_id=test_probe_configuration["id"],
        start_time_greater_than_or_equal_to=ping_probe_result_start_time_greater_than_or_equal_to,
        start_time_less_than_or_equal_to=ping_probe_result_start_time_less_than_or_equal_to,
        target=ping_probe_result_target)
    ```


    :param builtins.str probe_configuration_id: The OCID of a monitor or on-demand probe.
    :param builtins.float start_time_greater_than_or_equal_to: Returns results with a `startTime` equal to or greater than the specified value.
    :param builtins.float start_time_less_than_or_equal_to: Returns results with a `startTime` equal to or less than the specified value.
    :param builtins.str target: Filters results that match the `target`.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['probeConfigurationId'] = probe_configuration_id
    __args__['startTimeGreaterThanOrEqualTo'] = start_time_greater_than_or_equal_to
    __args__['startTimeLessThanOrEqualTo'] = start_time_less_than_or_equal_to
    __args__['target'] = target
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:HealthChecks/getPingProbeResults:getPingProbeResults', __args__, opts=opts, typ=GetPingProbeResultsResult).value

    return AwaitableGetPingProbeResultsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ping_probe_results=pulumi.get(__ret__, 'ping_probe_results'),
        probe_configuration_id=pulumi.get(__ret__, 'probe_configuration_id'),
        start_time_greater_than_or_equal_to=pulumi.get(__ret__, 'start_time_greater_than_or_equal_to'),
        start_time_less_than_or_equal_to=pulumi.get(__ret__, 'start_time_less_than_or_equal_to'),
        target=pulumi.get(__ret__, 'target'))
def get_ping_probe_results_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPingProbeResultsFilterArgs', 'GetPingProbeResultsFilterArgsDict']]]]] = None,
                                  probe_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                                  start_time_greater_than_or_equal_to: Optional[pulumi.Input[Optional[builtins.float]]] = None,
                                  start_time_less_than_or_equal_to: Optional[pulumi.Input[Optional[builtins.float]]] = None,
                                  target: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPingProbeResultsResult]:
    """
    This data source provides the list of Ping Probe Results in Oracle Cloud Infrastructure Health Checks service.

    Returns the results for the specified probe, where the `probeConfigurationId`
    is the OCID of either a monitor or an on-demand probe.

    Results are paginated based on `page` and `limit`.  The `opc-next-page` header provides
    a URL for fetching the next page.  Use `sortOrder` to set the order of the
    results.  If `sortOrder` is unspecified, results are sorted in ascending order by
    `startTime`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ping_probe_results = oci.HealthChecks.get_ping_probe_results(probe_configuration_id=test_probe_configuration["id"],
        start_time_greater_than_or_equal_to=ping_probe_result_start_time_greater_than_or_equal_to,
        start_time_less_than_or_equal_to=ping_probe_result_start_time_less_than_or_equal_to,
        target=ping_probe_result_target)
    ```


    :param builtins.str probe_configuration_id: The OCID of a monitor or on-demand probe.
    :param builtins.float start_time_greater_than_or_equal_to: Returns results with a `startTime` equal to or greater than the specified value.
    :param builtins.float start_time_less_than_or_equal_to: Returns results with a `startTime` equal to or less than the specified value.
    :param builtins.str target: Filters results that match the `target`.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['probeConfigurationId'] = probe_configuration_id
    __args__['startTimeGreaterThanOrEqualTo'] = start_time_greater_than_or_equal_to
    __args__['startTimeLessThanOrEqualTo'] = start_time_less_than_or_equal_to
    __args__['target'] = target
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:HealthChecks/getPingProbeResults:getPingProbeResults', __args__, opts=opts, typ=GetPingProbeResultsResult)
    return __ret__.apply(lambda __response__: GetPingProbeResultsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ping_probe_results=pulumi.get(__response__, 'ping_probe_results'),
        probe_configuration_id=pulumi.get(__response__, 'probe_configuration_id'),
        start_time_greater_than_or_equal_to=pulumi.get(__response__, 'start_time_greater_than_or_equal_to'),
        start_time_less_than_or_equal_to=pulumi.get(__response__, 'start_time_less_than_or_equal_to'),
        target=pulumi.get(__response__, 'target')))
