# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAuthenticationPolicyResult',
    'AwaitableGetAuthenticationPolicyResult',
    'get_authentication_policy',
    'get_authentication_policy_output',
]

@pulumi.output_type
class GetAuthenticationPolicyResult:
    """
    A collection of values returned by getAuthenticationPolicy.
    """
    def __init__(__self__, compartment_id=None, id=None, network_policies=None, password_policies=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_policies and not isinstance(network_policies, list):
            raise TypeError("Expected argument 'network_policies' to be a list")
        pulumi.set(__self__, "network_policies", network_policies)
        if password_policies and not isinstance(password_policies, list):
            raise TypeError("Expected argument 'password_policies' to be a list")
        pulumi.set(__self__, "password_policies", password_policies)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="networkPolicies")
    def network_policies(self) -> Sequence['outputs.GetAuthenticationPolicyNetworkPolicyResult']:
        """
        Network policy, Consists of a list of Network Source ids.
        """
        return pulumi.get(self, "network_policies")

    @property
    @pulumi.getter(name="passwordPolicies")
    def password_policies(self) -> Sequence['outputs.GetAuthenticationPolicyPasswordPolicyResult']:
        """
        Password policy, currently set for the given compartment.
        """
        return pulumi.get(self, "password_policies")


class AwaitableGetAuthenticationPolicyResult(GetAuthenticationPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthenticationPolicyResult(
            compartment_id=self.compartment_id,
            id=self.id,
            network_policies=self.network_policies,
            password_policies=self.password_policies)


def get_authentication_policy(compartment_id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthenticationPolicyResult:
    """
    This data source provides details about a specific Authentication Policy resource in Oracle Cloud Infrastructure Identity service.

    Gets the authentication policy for the given tenancy. You must specify your tenant’s OCID as the value for
    the compartment ID (remember that the tenancy is simply the root compartment).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_authentication_policy = oci.Identity.get_authentication_policy(compartment_id=tenancy_ocid)
    ```


    :param builtins.str compartment_id: The OCID of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getAuthenticationPolicy:getAuthenticationPolicy', __args__, opts=opts, typ=GetAuthenticationPolicyResult).value

    return AwaitableGetAuthenticationPolicyResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        network_policies=pulumi.get(__ret__, 'network_policies'),
        password_policies=pulumi.get(__ret__, 'password_policies'))
def get_authentication_policy_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuthenticationPolicyResult]:
    """
    This data source provides details about a specific Authentication Policy resource in Oracle Cloud Infrastructure Identity service.

    Gets the authentication policy for the given tenancy. You must specify your tenant’s OCID as the value for
    the compartment ID (remember that the tenancy is simply the root compartment).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_authentication_policy = oci.Identity.get_authentication_policy(compartment_id=tenancy_ocid)
    ```


    :param builtins.str compartment_id: The OCID of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getAuthenticationPolicy:getAuthenticationPolicy', __args__, opts=opts, typ=GetAuthenticationPolicyResult)
    return __ret__.apply(lambda __response__: GetAuthenticationPolicyResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        network_policies=pulumi.get(__response__, 'network_policies'),
        password_policies=pulumi.get(__response__, 'password_policies')))
