# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFleetAdvancedFeatureConfigurationResult',
    'AwaitableGetFleetAdvancedFeatureConfigurationResult',
    'get_fleet_advanced_feature_configuration',
    'get_fleet_advanced_feature_configuration_output',
]

@pulumi.output_type
class GetFleetAdvancedFeatureConfigurationResult:
    """
    A collection of values returned by getFleetAdvancedFeatureConfiguration.
    """
    def __init__(__self__, advanced_usage_trackings=None, analytic_bucket_name=None, analytic_namespace=None, crypto_event_analyses=None, fleet_id=None, id=None, java_migration_analyses=None, jfr_recordings=None, lcms=None, performance_tuning_analyses=None, time_last_modified=None):
        if advanced_usage_trackings and not isinstance(advanced_usage_trackings, list):
            raise TypeError("Expected argument 'advanced_usage_trackings' to be a list")
        pulumi.set(__self__, "advanced_usage_trackings", advanced_usage_trackings)
        if analytic_bucket_name and not isinstance(analytic_bucket_name, str):
            raise TypeError("Expected argument 'analytic_bucket_name' to be a str")
        pulumi.set(__self__, "analytic_bucket_name", analytic_bucket_name)
        if analytic_namespace and not isinstance(analytic_namespace, str):
            raise TypeError("Expected argument 'analytic_namespace' to be a str")
        pulumi.set(__self__, "analytic_namespace", analytic_namespace)
        if crypto_event_analyses and not isinstance(crypto_event_analyses, list):
            raise TypeError("Expected argument 'crypto_event_analyses' to be a list")
        pulumi.set(__self__, "crypto_event_analyses", crypto_event_analyses)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if java_migration_analyses and not isinstance(java_migration_analyses, list):
            raise TypeError("Expected argument 'java_migration_analyses' to be a list")
        pulumi.set(__self__, "java_migration_analyses", java_migration_analyses)
        if jfr_recordings and not isinstance(jfr_recordings, list):
            raise TypeError("Expected argument 'jfr_recordings' to be a list")
        pulumi.set(__self__, "jfr_recordings", jfr_recordings)
        if lcms and not isinstance(lcms, list):
            raise TypeError("Expected argument 'lcms' to be a list")
        pulumi.set(__self__, "lcms", lcms)
        if performance_tuning_analyses and not isinstance(performance_tuning_analyses, list):
            raise TypeError("Expected argument 'performance_tuning_analyses' to be a list")
        pulumi.set(__self__, "performance_tuning_analyses", performance_tuning_analyses)
        if time_last_modified and not isinstance(time_last_modified, str):
            raise TypeError("Expected argument 'time_last_modified' to be a str")
        pulumi.set(__self__, "time_last_modified", time_last_modified)

    @property
    @pulumi.getter(name="advancedUsageTrackings")
    def advanced_usage_trackings(self) -> Sequence['outputs.GetFleetAdvancedFeatureConfigurationAdvancedUsageTrackingResult']:
        """
        AdvancedUsageTracking configuration
        """
        return pulumi.get(self, "advanced_usage_trackings")

    @property
    @pulumi.getter(name="analyticBucketName")
    def analytic_bucket_name(self) -> builtins.str:
        """
        Bucket name required to store JFR and related data.
        """
        return pulumi.get(self, "analytic_bucket_name")

    @property
    @pulumi.getter(name="analyticNamespace")
    def analytic_namespace(self) -> builtins.str:
        """
        Namespace for the Fleet advanced feature.
        """
        return pulumi.get(self, "analytic_namespace")

    @property
    @pulumi.getter(name="cryptoEventAnalyses")
    def crypto_event_analyses(self) -> Sequence['outputs.GetFleetAdvancedFeatureConfigurationCryptoEventAnalysisResult']:
        """
        CryptoEventAnalysis configuration
        """
        return pulumi.get(self, "crypto_event_analyses")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> builtins.str:
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="javaMigrationAnalyses")
    def java_migration_analyses(self) -> Sequence['outputs.GetFleetAdvancedFeatureConfigurationJavaMigrationAnalysisResult']:
        """
        JavaMigrationAnalysis configuration
        """
        return pulumi.get(self, "java_migration_analyses")

    @property
    @pulumi.getter(name="jfrRecordings")
    def jfr_recordings(self) -> Sequence['outputs.GetFleetAdvancedFeatureConfigurationJfrRecordingResult']:
        """
        JfrRecording configuration
        """
        return pulumi.get(self, "jfr_recordings")

    @property
    @pulumi.getter
    def lcms(self) -> Sequence['outputs.GetFleetAdvancedFeatureConfigurationLcmResult']:
        """
        Enable lifecycle management and set post action configurations.
        """
        return pulumi.get(self, "lcms")

    @property
    @pulumi.getter(name="performanceTuningAnalyses")
    def performance_tuning_analyses(self) -> Sequence['outputs.GetFleetAdvancedFeatureConfigurationPerformanceTuningAnalysisResult']:
        """
        Performance tuning analysis configuration
        """
        return pulumi.get(self, "performance_tuning_analyses")

    @property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> builtins.str:
        """
        The date and time of the last modification to the Fleet Agent Configuration (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_modified")


class AwaitableGetFleetAdvancedFeatureConfigurationResult(GetFleetAdvancedFeatureConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetAdvancedFeatureConfigurationResult(
            advanced_usage_trackings=self.advanced_usage_trackings,
            analytic_bucket_name=self.analytic_bucket_name,
            analytic_namespace=self.analytic_namespace,
            crypto_event_analyses=self.crypto_event_analyses,
            fleet_id=self.fleet_id,
            id=self.id,
            java_migration_analyses=self.java_migration_analyses,
            jfr_recordings=self.jfr_recordings,
            lcms=self.lcms,
            performance_tuning_analyses=self.performance_tuning_analyses,
            time_last_modified=self.time_last_modified)


def get_fleet_advanced_feature_configuration(fleet_id: Optional[builtins.str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetAdvancedFeatureConfigurationResult:
    """
    This data source provides details about a specific Fleet Advanced Feature Configuration resource in Oracle Cloud Infrastructure Jms service.

    Returns Fleet level advanced feature configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_advanced_feature_configuration = oci.Jms.get_fleet_advanced_feature_configuration(fleet_id=test_fleet["id"])
    ```


    :param builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetAdvancedFeatureConfiguration:getFleetAdvancedFeatureConfiguration', __args__, opts=opts, typ=GetFleetAdvancedFeatureConfigurationResult).value

    return AwaitableGetFleetAdvancedFeatureConfigurationResult(
        advanced_usage_trackings=pulumi.get(__ret__, 'advanced_usage_trackings'),
        analytic_bucket_name=pulumi.get(__ret__, 'analytic_bucket_name'),
        analytic_namespace=pulumi.get(__ret__, 'analytic_namespace'),
        crypto_event_analyses=pulumi.get(__ret__, 'crypto_event_analyses'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        java_migration_analyses=pulumi.get(__ret__, 'java_migration_analyses'),
        jfr_recordings=pulumi.get(__ret__, 'jfr_recordings'),
        lcms=pulumi.get(__ret__, 'lcms'),
        performance_tuning_analyses=pulumi.get(__ret__, 'performance_tuning_analyses'),
        time_last_modified=pulumi.get(__ret__, 'time_last_modified'))
def get_fleet_advanced_feature_configuration_output(fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetAdvancedFeatureConfigurationResult]:
    """
    This data source provides details about a specific Fleet Advanced Feature Configuration resource in Oracle Cloud Infrastructure Jms service.

    Returns Fleet level advanced feature configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_advanced_feature_configuration = oci.Jms.get_fleet_advanced_feature_configuration(fleet_id=test_fleet["id"])
    ```


    :param builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleetAdvancedFeatureConfiguration:getFleetAdvancedFeatureConfiguration', __args__, opts=opts, typ=GetFleetAdvancedFeatureConfigurationResult)
    return __ret__.apply(lambda __response__: GetFleetAdvancedFeatureConfigurationResult(
        advanced_usage_trackings=pulumi.get(__response__, 'advanced_usage_trackings'),
        analytic_bucket_name=pulumi.get(__response__, 'analytic_bucket_name'),
        analytic_namespace=pulumi.get(__response__, 'analytic_namespace'),
        crypto_event_analyses=pulumi.get(__response__, 'crypto_event_analyses'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        java_migration_analyses=pulumi.get(__response__, 'java_migration_analyses'),
        jfr_recordings=pulumi.get(__response__, 'jfr_recordings'),
        lcms=pulumi.get(__response__, 'lcms'),
        performance_tuning_analyses=pulumi.get(__response__, 'performance_tuning_analyses'),
        time_last_modified=pulumi.get(__response__, 'time_last_modified')))
