# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetJavaDownloadsJavaDownloadReportsResult',
    'AwaitableGetJavaDownloadsJavaDownloadReportsResult',
    'get_java_downloads_java_download_reports',
    'get_java_downloads_java_download_reports_output',
]

@pulumi.output_type
class GetJavaDownloadsJavaDownloadReportsResult:
    """
    A collection of values returned by getJavaDownloadsJavaDownloadReports.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, java_download_report_collections=None, java_download_report_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if java_download_report_collections and not isinstance(java_download_report_collections, list):
            raise TypeError("Expected argument 'java_download_report_collections' to be a list")
        pulumi.set(__self__, "java_download_report_collections", java_download_report_collections)
        if java_download_report_id and not isinstance(java_download_report_id, str):
            raise TypeError("Expected argument 'java_download_report_id' to be a str")
        pulumi.set(__self__, "java_download_report_id", java_download_report_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy scoped to the Java download report.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Display name for the Java download report.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetJavaDownloadsJavaDownloadReportsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="javaDownloadReportCollections")
    def java_download_report_collections(self) -> Sequence['outputs.GetJavaDownloadsJavaDownloadReportsJavaDownloadReportCollectionResult']:
        """
        The list of java_download_report_collection.
        """
        return pulumi.get(self, "java_download_report_collections")

    @property
    @pulumi.getter(name="javaDownloadReportId")
    def java_download_report_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "java_download_report_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Java download report.
        """
        return pulumi.get(self, "state")


class AwaitableGetJavaDownloadsJavaDownloadReportsResult(GetJavaDownloadsJavaDownloadReportsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJavaDownloadsJavaDownloadReportsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            java_download_report_collections=self.java_download_report_collections,
            java_download_report_id=self.java_download_report_id,
            state=self.state)


def get_java_downloads_java_download_reports(compartment_id: Optional[builtins.str] = None,
                                             display_name: Optional[builtins.str] = None,
                                             filters: Optional[Sequence[Union['GetJavaDownloadsJavaDownloadReportsFilterArgs', 'GetJavaDownloadsJavaDownloadReportsFilterArgsDict']]] = None,
                                             java_download_report_id: Optional[builtins.str] = None,
                                             state: Optional[builtins.str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJavaDownloadsJavaDownloadReportsResult:
    """
    This data source provides the list of Java Download Reports in Oracle Cloud Infrastructure Jms Java Downloads service.

    Returns a list of JavaDownloadReports.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_download_reports = oci.Jms.get_java_downloads_java_download_reports(compartment_id=tenancy_ocid,
        display_name=java_download_report_display_name,
        java_download_report_id=test_java_download_report["id"],
        state=java_download_report_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy.
    :param builtins.str display_name: A filter to return only resources that match the display name.
    :param builtins.str java_download_report_id: Unique Java download report identifier.
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['javaDownloadReportId'] = java_download_report_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getJavaDownloadsJavaDownloadReports:getJavaDownloadsJavaDownloadReports', __args__, opts=opts, typ=GetJavaDownloadsJavaDownloadReportsResult).value

    return AwaitableGetJavaDownloadsJavaDownloadReportsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        java_download_report_collections=pulumi.get(__ret__, 'java_download_report_collections'),
        java_download_report_id=pulumi.get(__ret__, 'java_download_report_id'),
        state=pulumi.get(__ret__, 'state'))
def get_java_downloads_java_download_reports_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                                    display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetJavaDownloadsJavaDownloadReportsFilterArgs', 'GetJavaDownloadsJavaDownloadReportsFilterArgsDict']]]]] = None,
                                                    java_download_report_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                    state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJavaDownloadsJavaDownloadReportsResult]:
    """
    This data source provides the list of Java Download Reports in Oracle Cloud Infrastructure Jms Java Downloads service.

    Returns a list of JavaDownloadReports.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_download_reports = oci.Jms.get_java_downloads_java_download_reports(compartment_id=tenancy_ocid,
        display_name=java_download_report_display_name,
        java_download_report_id=test_java_download_report["id"],
        state=java_download_report_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy.
    :param builtins.str display_name: A filter to return only resources that match the display name.
    :param builtins.str java_download_report_id: Unique Java download report identifier.
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['javaDownloadReportId'] = java_download_report_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getJavaDownloadsJavaDownloadReports:getJavaDownloadsJavaDownloadReports', __args__, opts=opts, typ=GetJavaDownloadsJavaDownloadReportsResult)
    return __ret__.apply(lambda __response__: GetJavaDownloadsJavaDownloadReportsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        java_download_report_collections=pulumi.get(__response__, 'java_download_report_collections'),
        java_download_report_id=pulumi.get(__response__, 'java_download_report_id'),
        state=pulumi.get(__response__, 'state')))
