# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLogAnalyticsUnprocessedDataBucketResult',
    'AwaitableGetLogAnalyticsUnprocessedDataBucketResult',
    'get_log_analytics_unprocessed_data_bucket',
    'get_log_analytics_unprocessed_data_bucket_output',
]

@pulumi.output_type
class GetLogAnalyticsUnprocessedDataBucketResult:
    """
    A collection of values returned by getLogAnalyticsUnprocessedDataBucket.
    """
    def __init__(__self__, bucket=None, id=None, is_enabled=None, namespace=None, time_created=None, time_updated=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Name of the Object Storage bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        """
        Flag that specifies if this configuration is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time when this record is created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The latest time when this record is updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetLogAnalyticsUnprocessedDataBucketResult(GetLogAnalyticsUnprocessedDataBucketResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsUnprocessedDataBucketResult(
            bucket=self.bucket,
            id=self.id,
            is_enabled=self.is_enabled,
            namespace=self.namespace,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_log_analytics_unprocessed_data_bucket(namespace: Optional[builtins.str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsUnprocessedDataBucketResult:
    """
    This data source provides details about a specific Log Analytics Unprocessed Data Bucket resource in Oracle Cloud Infrastructure Log Analytics service.

    This API retrieves details of the configured bucket that stores unprocessed payloads.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_unprocessed_data_bucket = oci.LogAnalytics.get_log_analytics_unprocessed_data_bucket(namespace=log_analytics_unprocessed_data_bucket_namespace)
    ```


    :param builtins.str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsUnprocessedDataBucket:getLogAnalyticsUnprocessedDataBucket', __args__, opts=opts, typ=GetLogAnalyticsUnprocessedDataBucketResult).value

    return AwaitableGetLogAnalyticsUnprocessedDataBucketResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        id=pulumi.get(__ret__, 'id'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        namespace=pulumi.get(__ret__, 'namespace'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_log_analytics_unprocessed_data_bucket_output(namespace: Optional[pulumi.Input[builtins.str]] = None,
                                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogAnalyticsUnprocessedDataBucketResult]:
    """
    This data source provides details about a specific Log Analytics Unprocessed Data Bucket resource in Oracle Cloud Infrastructure Log Analytics service.

    This API retrieves details of the configured bucket that stores unprocessed payloads.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_unprocessed_data_bucket = oci.LogAnalytics.get_log_analytics_unprocessed_data_bucket(namespace=log_analytics_unprocessed_data_bucket_namespace)
    ```


    :param builtins.str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LogAnalytics/getLogAnalyticsUnprocessedDataBucket:getLogAnalyticsUnprocessedDataBucket', __args__, opts=opts, typ=GetLogAnalyticsUnprocessedDataBucketResult)
    return __ret__.apply(lambda __response__: GetLogAnalyticsUnprocessedDataBucketResult(
        bucket=pulumi.get(__response__, 'bucket'),
        id=pulumi.get(__response__, 'id'),
        is_enabled=pulumi.get(__response__, 'is_enabled'),
        namespace=pulumi.get(__response__, 'namespace'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
