# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLogGroupsResult',
    'AwaitableGetLogGroupsResult',
    'get_log_groups',
    'get_log_groups_output',
]

@pulumi.output_type
class GetLogGroupsResult:
    """
    A collection of values returned by getLogGroups.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, is_compartment_id_in_subtree=None, log_groups=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_compartment_id_in_subtree and not isinstance(is_compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'is_compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "is_compartment_id_in_subtree", is_compartment_id_in_subtree)
        if log_groups and not isinstance(log_groups, list):
            raise TypeError("Expected argument 'log_groups' to be a list")
        pulumi.set(__self__, "log_groups", log_groups)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLogGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCompartmentIdInSubtree")
    def is_compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "is_compartment_id_in_subtree")

    @property
    @pulumi.getter(name="logGroups")
    def log_groups(self) -> Sequence['outputs.GetLogGroupsLogGroupResult']:
        """
        The list of log_groups.
        """
        return pulumi.get(self, "log_groups")


class AwaitableGetLogGroupsResult(GetLogGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogGroupsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            is_compartment_id_in_subtree=self.is_compartment_id_in_subtree,
            log_groups=self.log_groups)


def get_log_groups(compartment_id: Optional[builtins.str] = None,
                   display_name: Optional[builtins.str] = None,
                   filters: Optional[Sequence[Union['GetLogGroupsFilterArgs', 'GetLogGroupsFilterArgsDict']]] = None,
                   is_compartment_id_in_subtree: Optional[builtins.bool] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogGroupsResult:
    """
    This data source provides the list of Log Groups in Oracle Cloud Infrastructure Logging service.

    Lists all log groups for the specified compartment or tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_groups = oci.Logging.get_log_groups(compartment_id=compartment_id,
        display_name=log_group_display_name,
        is_compartment_id_in_subtree=log_group_is_compartment_id_in_subtree)
    ```


    :param builtins.str compartment_id: Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
    :param builtins.str display_name: Resource name.
    :param builtins.bool is_compartment_id_in_subtree: Specifies whether or not nested compartments should be traversed. Defaults to false.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Logging/getLogGroups:getLogGroups', __args__, opts=opts, typ=GetLogGroupsResult).value

    return AwaitableGetLogGroupsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__ret__, 'is_compartment_id_in_subtree'),
        log_groups=pulumi.get(__ret__, 'log_groups'))
def get_log_groups_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                          display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetLogGroupsFilterArgs', 'GetLogGroupsFilterArgsDict']]]]] = None,
                          is_compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogGroupsResult]:
    """
    This data source provides the list of Log Groups in Oracle Cloud Infrastructure Logging service.

    Lists all log groups for the specified compartment or tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_groups = oci.Logging.get_log_groups(compartment_id=compartment_id,
        display_name=log_group_display_name,
        is_compartment_id_in_subtree=log_group_is_compartment_id_in_subtree)
    ```


    :param builtins.str compartment_id: Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
    :param builtins.str display_name: Resource name.
    :param builtins.bool is_compartment_id_in_subtree: Specifies whether or not nested compartments should be traversed. Defaults to false.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Logging/getLogGroups:getLogGroups', __args__, opts=opts, typ=GetLogGroupsResult)
    return __ret__.apply(lambda __response__: GetLogGroupsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__response__, 'is_compartment_id_in_subtree'),
        log_groups=pulumi.get(__response__, 'log_groups')))
