# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFileStorageLustreFileSystemsResult',
    'AwaitableGetFileStorageLustreFileSystemsResult',
    'get_file_storage_lustre_file_systems',
    'get_file_storage_lustre_file_systems_output',
]

@pulumi.output_type
class GetFileStorageLustreFileSystemsResult:
    """
    A collection of values returned by getFileStorageLustreFileSystems.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, display_name=None, filters=None, id=None, lustre_file_system_collections=None, state=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lustre_file_system_collections and not isinstance(lustre_file_system_collections, list):
            raise TypeError("Expected argument 'lustre_file_system_collections' to be a list")
        pulumi.set(__self__, "lustre_file_system_collections", lustre_file_system_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[builtins.str]:
        """
        The availability domain the file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Lustre file system.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Lustre file system`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFileStorageLustreFileSystemsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Lustre file system.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lustreFileSystemCollections")
    def lustre_file_system_collections(self) -> Sequence['outputs.GetFileStorageLustreFileSystemsLustreFileSystemCollectionResult']:
        """
        The list of lustre_file_system_collection.
        """
        return pulumi.get(self, "lustre_file_system_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Lustre file system.
        """
        return pulumi.get(self, "state")


class AwaitableGetFileStorageLustreFileSystemsResult(GetFileStorageLustreFileSystemsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFileStorageLustreFileSystemsResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            lustre_file_system_collections=self.lustre_file_system_collections,
            state=self.state)


def get_file_storage_lustre_file_systems(availability_domain: Optional[builtins.str] = None,
                                         compartment_id: Optional[builtins.str] = None,
                                         display_name: Optional[builtins.str] = None,
                                         filters: Optional[Sequence[Union['GetFileStorageLustreFileSystemsFilterArgs', 'GetFileStorageLustreFileSystemsFilterArgsDict']]] = None,
                                         id: Optional[builtins.str] = None,
                                         state: Optional[builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFileStorageLustreFileSystemsResult:
    """
    This data source provides the list of Lustre File Systems in Oracle Cloud Infrastructure Lustre File Storage service.

    Gets a list of Lustre file systems.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_lustre_file_systems = oci.Lustre.get_file_storage_lustre_file_systems(availability_domain=lustre_file_system_availability_domain,
        compartment_id=compartment_id,
        display_name=lustre_file_system_display_name,
        id=lustre_file_system_id,
        state=lustre_file_system_state)
    ```


    :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Lustre file system.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Lustre/getFileStorageLustreFileSystems:getFileStorageLustreFileSystems', __args__, opts=opts, typ=GetFileStorageLustreFileSystemsResult).value

    return AwaitableGetFileStorageLustreFileSystemsResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        lustre_file_system_collections=pulumi.get(__ret__, 'lustre_file_system_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_file_storage_lustre_file_systems_output(availability_domain: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFileStorageLustreFileSystemsFilterArgs', 'GetFileStorageLustreFileSystemsFilterArgsDict']]]]] = None,
                                                id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFileStorageLustreFileSystemsResult]:
    """
    This data source provides the list of Lustre File Systems in Oracle Cloud Infrastructure Lustre File Storage service.

    Gets a list of Lustre file systems.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_lustre_file_systems = oci.Lustre.get_file_storage_lustre_file_systems(availability_domain=lustre_file_system_availability_domain,
        compartment_id=compartment_id,
        display_name=lustre_file_system_display_name,
        id=lustre_file_system_id,
        state=lustre_file_system_state)
    ```


    :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Lustre file system.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Lustre/getFileStorageLustreFileSystems:getFileStorageLustreFileSystems', __args__, opts=opts, typ=GetFileStorageLustreFileSystemsResult)
    return __ret__.apply(lambda __response__: GetFileStorageLustreFileSystemsResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        lustre_file_system_collections=pulumi.get(__response__, 'lustre_file_system_collections'),
        state=pulumi.get(__response__, 'state')))
