# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMediaWorkflowConfigurationResult',
    'AwaitableGetMediaWorkflowConfigurationResult',
    'get_media_workflow_configuration',
    'get_media_workflow_configuration_output',
]

@pulumi.output_type
class GetMediaWorkflowConfigurationResult:
    """
    A collection of values returned by getMediaWorkflowConfiguration.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, is_lock_override=None, lifecyle_details=None, locks=None, media_workflow_configuration_id=None, parameters=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_lock_override and not isinstance(is_lock_override, bool):
            raise TypeError("Expected argument 'is_lock_override' to be a bool")
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        if lifecyle_details and not isinstance(lifecyle_details, str):
            raise TypeError("Expected argument 'lifecyle_details' to be a str")
        pulumi.set(__self__, "lifecyle_details", lifecyle_details)
        if locks and not isinstance(locks, list):
            raise TypeError("Expected argument 'locks' to be a list")
        pulumi.set(__self__, "locks", locks)
        if media_workflow_configuration_id and not isinstance(media_workflow_configuration_id, str):
            raise TypeError("Expected argument 'media_workflow_configuration_id' to be a str")
        pulumi.set(__self__, "media_workflow_configuration_id", media_workflow_configuration_id)
        if parameters and not isinstance(parameters, str):
            raise TypeError("Expected argument 'parameters' to be a str")
        pulumi.set(__self__, "parameters", parameters)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Display name for the MediaWorkflowConfiguration. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> builtins.bool:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecyle_details")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetMediaWorkflowConfigurationLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="mediaWorkflowConfigurationId")
    def media_workflow_configuration_id(self) -> builtins.str:
        return pulumi.get(self, "media_workflow_configuration_id")

    @property
    @pulumi.getter
    def parameters(self) -> builtins.str:
        """
        Reuseable parameter values encoded as a JSON; the top and second level JSON elements are objects. Each key of the top level object refer to a task key that is unqiue to the workflow, each of the second level objects' keys refer to the name of a parameter that is unique to the task. taskKey > parameterName > parameterValue
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the MediaWorkflowConfiguration.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time when the the MediaWorkflowConfiguration was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time when the MediaWorkflowConfiguration was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMediaWorkflowConfigurationResult(GetMediaWorkflowConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMediaWorkflowConfigurationResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_lock_override=self.is_lock_override,
            lifecyle_details=self.lifecyle_details,
            locks=self.locks,
            media_workflow_configuration_id=self.media_workflow_configuration_id,
            parameters=self.parameters,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_media_workflow_configuration(media_workflow_configuration_id: Optional[builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMediaWorkflowConfigurationResult:
    """
    This data source provides details about a specific Media Workflow Configuration resource in Oracle Cloud Infrastructure Media Services service.

    Gets a MediaWorkflowConfiguration by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_media_workflow_configuration = oci.MediaServices.get_media_workflow_configuration(media_workflow_configuration_id=test_media_workflow_configuration_oci_media_services_media_workflow_configuration["id"])
    ```


    :param builtins.str media_workflow_configuration_id: Unique MediaWorkflowConfiguration identifier.
    """
    __args__ = dict()
    __args__['mediaWorkflowConfigurationId'] = media_workflow_configuration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MediaServices/getMediaWorkflowConfiguration:getMediaWorkflowConfiguration', __args__, opts=opts, typ=GetMediaWorkflowConfigurationResult).value

    return AwaitableGetMediaWorkflowConfigurationResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_lock_override=pulumi.get(__ret__, 'is_lock_override'),
        lifecyle_details=pulumi.get(__ret__, 'lifecyle_details'),
        locks=pulumi.get(__ret__, 'locks'),
        media_workflow_configuration_id=pulumi.get(__ret__, 'media_workflow_configuration_id'),
        parameters=pulumi.get(__ret__, 'parameters'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_media_workflow_configuration_output(media_workflow_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMediaWorkflowConfigurationResult]:
    """
    This data source provides details about a specific Media Workflow Configuration resource in Oracle Cloud Infrastructure Media Services service.

    Gets a MediaWorkflowConfiguration by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_media_workflow_configuration = oci.MediaServices.get_media_workflow_configuration(media_workflow_configuration_id=test_media_workflow_configuration_oci_media_services_media_workflow_configuration["id"])
    ```


    :param builtins.str media_workflow_configuration_id: Unique MediaWorkflowConfiguration identifier.
    """
    __args__ = dict()
    __args__['mediaWorkflowConfigurationId'] = media_workflow_configuration_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:MediaServices/getMediaWorkflowConfiguration:getMediaWorkflowConfiguration', __args__, opts=opts, typ=GetMediaWorkflowConfigurationResult)
    return __ret__.apply(lambda __response__: GetMediaWorkflowConfigurationResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_lock_override=pulumi.get(__response__, 'is_lock_override'),
        lifecyle_details=pulumi.get(__response__, 'lifecyle_details'),
        locks=pulumi.get(__response__, 'locks'),
        media_workflow_configuration_id=pulumi.get(__response__, 'media_workflow_configuration_id'),
        parameters=pulumi.get(__response__, 'parameters'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
