# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetListenersResult',
    'AwaitableGetListenersResult',
    'get_listeners',
    'get_listeners_output',
]

@pulumi.output_type
class GetListenersResult:
    """
    A collection of values returned by getListeners.
    """
    def __init__(__self__, filters=None, id=None, listener_collections=None, network_load_balancer_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if listener_collections and not isinstance(listener_collections, list):
            raise TypeError("Expected argument 'listener_collections' to be a list")
        pulumi.set(__self__, "listener_collections", listener_collections)
        if network_load_balancer_id and not isinstance(network_load_balancer_id, str):
            raise TypeError("Expected argument 'network_load_balancer_id' to be a str")
        pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetListenersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listenerCollections")
    def listener_collections(self) -> Sequence['outputs.GetListenersListenerCollectionResult']:
        """
        The list of listener_collection.
        """
        return pulumi.get(self, "listener_collections")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> builtins.str:
        return pulumi.get(self, "network_load_balancer_id")


class AwaitableGetListenersResult(GetListenersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListenersResult(
            filters=self.filters,
            id=self.id,
            listener_collections=self.listener_collections,
            network_load_balancer_id=self.network_load_balancer_id)


def get_listeners(filters: Optional[Sequence[Union['GetListenersFilterArgs', 'GetListenersFilterArgsDict']]] = None,
                  network_load_balancer_id: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListenersResult:
    """
    This data source provides the list of Listeners in Oracle Cloud Infrastructure Network Load Balancer service.

    Lists all listeners associated with a given network load balancer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_listeners = oci.NetworkLoadBalancer.get_listeners(network_load_balancer_id=test_network_load_balancer["id"])
    ```


    :param builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['networkLoadBalancerId'] = network_load_balancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:NetworkLoadBalancer/getListeners:getListeners', __args__, opts=opts, typ=GetListenersResult).value

    return AwaitableGetListenersResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        listener_collections=pulumi.get(__ret__, 'listener_collections'),
        network_load_balancer_id=pulumi.get(__ret__, 'network_load_balancer_id'))
def get_listeners_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetListenersFilterArgs', 'GetListenersFilterArgsDict']]]]] = None,
                         network_load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetListenersResult]:
    """
    This data source provides the list of Listeners in Oracle Cloud Infrastructure Network Load Balancer service.

    Lists all listeners associated with a given network load balancer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_listeners = oci.NetworkLoadBalancer.get_listeners(network_load_balancer_id=test_network_load_balancer["id"])
    ```


    :param builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['networkLoadBalancerId'] = network_load_balancer_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:NetworkLoadBalancer/getListeners:getListeners', __args__, opts=opts, typ=GetListenersResult)
    return __ret__.apply(lambda __response__: GetListenersResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        listener_collections=pulumi.get(__response__, 'listener_collections'),
        network_load_balancer_id=pulumi.get(__response__, 'network_load_balancer_id')))
