# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'OdaInstanceRestrictedOperation',
    'OdaPrivateEndpointScanProxyScanListenerInfo',
    'GetOdaInstanceRestrictedOperationResult',
    'GetOdaInstancesFilterResult',
    'GetOdaInstancesOdaInstanceResult',
    'GetOdaInstancesOdaInstanceRestrictedOperationResult',
    'GetOdaPrivateEndpointAttachmentsFilterResult',
    'GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionResult',
    'GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionItemResult',
    'GetOdaPrivateEndpointScanProxiesFilterResult',
    'GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionResult',
    'GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemResult',
    'GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoResult',
    'GetOdaPrivateEndpointScanProxyScanListenerInfoResult',
    'GetOdaPrivateEndpointsFilterResult',
    'GetOdaPrivateEndpointsOdaPrivateEndpointCollectionResult',
    'GetOdaPrivateEndpointsOdaPrivateEndpointCollectionItemResult',
]

@pulumi.output_type
class OdaInstanceRestrictedOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationName":
            suggest = "operation_name"
        elif key == "restrictingService":
            suggest = "restricting_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OdaInstanceRestrictedOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OdaInstanceRestrictedOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OdaInstanceRestrictedOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_name: Optional[builtins.str] = None,
                 restricting_service: Optional[builtins.str] = None):
        """
        :param builtins.str operation_name: Name of the restricted operation.
        :param builtins.str restricting_service: Name of the service restricting the operation.
        """
        if operation_name is not None:
            pulumi.set(__self__, "operation_name", operation_name)
        if restricting_service is not None:
            pulumi.set(__self__, "restricting_service", restricting_service)

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[builtins.str]:
        """
        Name of the restricted operation.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="restrictingService")
    def restricting_service(self) -> Optional[builtins.str]:
        """
        Name of the service restricting the operation.
        """
        return pulumi.get(self, "restricting_service")


@pulumi.output_type
class OdaPrivateEndpointScanProxyScanListenerInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scanListenerFqdn":
            suggest = "scan_listener_fqdn"
        elif key == "scanListenerIp":
            suggest = "scan_listener_ip"
        elif key == "scanListenerPort":
            suggest = "scan_listener_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OdaPrivateEndpointScanProxyScanListenerInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OdaPrivateEndpointScanProxyScanListenerInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OdaPrivateEndpointScanProxyScanListenerInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scan_listener_fqdn: Optional[builtins.str] = None,
                 scan_listener_ip: Optional[builtins.str] = None,
                 scan_listener_port: Optional[builtins.int] = None):
        """
        :param builtins.str scan_listener_fqdn: FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param builtins.str scan_listener_ip: A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        :param builtins.int scan_listener_port: The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        if scan_listener_fqdn is not None:
            pulumi.set(__self__, "scan_listener_fqdn", scan_listener_fqdn)
        if scan_listener_ip is not None:
            pulumi.set(__self__, "scan_listener_ip", scan_listener_ip)
        if scan_listener_port is not None:
            pulumi.set(__self__, "scan_listener_port", scan_listener_port)

    @property
    @pulumi.getter(name="scanListenerFqdn")
    def scan_listener_fqdn(self) -> Optional[builtins.str]:
        """
        FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_fqdn")

    @property
    @pulumi.getter(name="scanListenerIp")
    def scan_listener_ip(self) -> Optional[builtins.str]:
        """
        A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        """
        return pulumi.get(self, "scan_listener_ip")

    @property
    @pulumi.getter(name="scanListenerPort")
    def scan_listener_port(self) -> Optional[builtins.int]:
        """
        The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        return pulumi.get(self, "scan_listener_port")


@pulumi.output_type
class GetOdaInstanceRestrictedOperationResult(dict):
    def __init__(__self__, *,
                 operation_name: builtins.str,
                 restricting_service: builtins.str):
        """
        :param builtins.str operation_name: Name of the restricted operation.
        :param builtins.str restricting_service: Name of the service restricting the operation.
        """
        pulumi.set(__self__, "operation_name", operation_name)
        pulumi.set(__self__, "restricting_service", restricting_service)

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> builtins.str:
        """
        Name of the restricted operation.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="restrictingService")
    def restricting_service(self) -> builtins.str:
        """
        Name of the service restricting the operation.
        """
        return pulumi.get(self, "restricting_service")


@pulumi.output_type
class GetOdaInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOdaInstancesOdaInstanceResult(dict):
    def __init__(__self__, *,
                 attachment_ids: Sequence[builtins.str],
                 attachment_types: Sequence[builtins.str],
                 compartment_id: builtins.str,
                 connector_url: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 identity_app_console_url: builtins.str,
                 identity_app_guid: builtins.str,
                 identity_domain: builtins.str,
                 imported_package_ids: Sequence[builtins.str],
                 imported_package_names: Sequence[builtins.str],
                 is_role_based_access: builtins.bool,
                 lifecycle_sub_state: builtins.str,
                 restricted_operations: Sequence['outputs.GetOdaInstancesOdaInstanceRestrictedOperationResult'],
                 shape_name: builtins.str,
                 state: builtins.str,
                 state_message: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 web_app_url: builtins.str):
        """
        :param Sequence[builtins.str] attachment_ids: A list of attachment identifiers for this instance (if any). Use GetOdaInstanceAttachment to get the details of the attachments.
        :param Sequence[builtins.str] attachment_types: A list of attachment types for this instance (if any). Use attachmentIds to get the details of the attachments.
        :param builtins.str compartment_id: List the Digital Assistant instances that belong to this compartment.
        :param builtins.str connector_url: URL for the connector's endpoint.
        :param Mapping[str, builtins.str] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: Description of the Digital Assistant instance.
        :param builtins.str display_name: List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Example: `{"bar-key": "value"}`
        :param builtins.str id: Unique immutable identifier that was assigned when the instance was created.
        :param builtins.str identity_app_console_url: If isRoleBasedAccess is set to true, this property specifies the URL for the administration console used to manage the Identity Application instance Digital Assistant has created inside the user-specified identity domain.
        :param builtins.str identity_app_guid: If isRoleBasedAccess is set to true, this property specifies the GUID of the Identity Application instance Digital Assistant has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this Digital Assistant instance for users within the identity domain.
        :param builtins.str identity_domain: If isRoleBasedAccess is set to true, this property specifies the identity domain that is to be used to implement this type of authorzation. Digital Assistant will create an Identity Application instance and Application Roles within this identity domain. The caller may then perform and user roll mappings they like to grant access to users within the identity domain.
        :param Sequence[builtins.str] imported_package_ids: A list of package ids imported into this instance (if any). Use GetImportedPackage to get the details of the imported packages.
        :param Sequence[builtins.str] imported_package_names: A list of package names imported into this instance (if any). Use importedPackageIds field to get the details of the imported packages.
        :param builtins.bool is_role_based_access: Should this Digital Assistant instance use role-based authorization via an identity domain (true) or use the default policy-based authorization via IAM policies (false)
        :param builtins.str lifecycle_sub_state: The current sub-state of the Digital Assistant instance.
        :param Sequence['GetOdaInstancesOdaInstanceRestrictedOperationArgs'] restricted_operations: A list of restricted operations (across all attachments) for this instance (if any). Use GetOdaInstanceAttachment to get the details of the attachments.
        :param builtins.str shape_name: Shape or size of the instance.
        :param builtins.str state: List only the Digital Assistant instances that are in this lifecycle state.
        :param builtins.str state_message: A message that describes the current state in more detail. For example, actionable information about an instance that's in the `FAILED` state.
        :param builtins.str time_created: When the Digital Assistant instance was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str time_updated: When the Digital Assistance instance was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str web_app_url: URL for the Digital Assistant web application that's associated with the instance.
        """
        pulumi.set(__self__, "attachment_ids", attachment_ids)
        pulumi.set(__self__, "attachment_types", attachment_types)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "connector_url", connector_url)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "identity_app_console_url", identity_app_console_url)
        pulumi.set(__self__, "identity_app_guid", identity_app_guid)
        pulumi.set(__self__, "identity_domain", identity_domain)
        pulumi.set(__self__, "imported_package_ids", imported_package_ids)
        pulumi.set(__self__, "imported_package_names", imported_package_names)
        pulumi.set(__self__, "is_role_based_access", is_role_based_access)
        pulumi.set(__self__, "lifecycle_sub_state", lifecycle_sub_state)
        pulumi.set(__self__, "restricted_operations", restricted_operations)
        pulumi.set(__self__, "shape_name", shape_name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_message", state_message)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "web_app_url", web_app_url)

    @property
    @pulumi.getter(name="attachmentIds")
    def attachment_ids(self) -> Sequence[builtins.str]:
        """
        A list of attachment identifiers for this instance (if any). Use GetOdaInstanceAttachment to get the details of the attachments.
        """
        return pulumi.get(self, "attachment_ids")

    @property
    @pulumi.getter(name="attachmentTypes")
    def attachment_types(self) -> Sequence[builtins.str]:
        """
        A list of attachment types for this instance (if any). Use attachmentIds to get the details of the attachments.
        """
        return pulumi.get(self, "attachment_types")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        List the Digital Assistant instances that belong to this compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectorUrl")
    def connector_url(self) -> builtins.str:
        """
        URL for the connector's endpoint.
        """
        return pulumi.get(self, "connector_url")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the Digital Assistant instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique immutable identifier that was assigned when the instance was created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="identityAppConsoleUrl")
    def identity_app_console_url(self) -> builtins.str:
        """
        If isRoleBasedAccess is set to true, this property specifies the URL for the administration console used to manage the Identity Application instance Digital Assistant has created inside the user-specified identity domain.
        """
        return pulumi.get(self, "identity_app_console_url")

    @property
    @pulumi.getter(name="identityAppGuid")
    def identity_app_guid(self) -> builtins.str:
        """
        If isRoleBasedAccess is set to true, this property specifies the GUID of the Identity Application instance Digital Assistant has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this Digital Assistant instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_app_guid")

    @property
    @pulumi.getter(name="identityDomain")
    def identity_domain(self) -> builtins.str:
        """
        If isRoleBasedAccess is set to true, this property specifies the identity domain that is to be used to implement this type of authorzation. Digital Assistant will create an Identity Application instance and Application Roles within this identity domain. The caller may then perform and user roll mappings they like to grant access to users within the identity domain.
        """
        return pulumi.get(self, "identity_domain")

    @property
    @pulumi.getter(name="importedPackageIds")
    def imported_package_ids(self) -> Sequence[builtins.str]:
        """
        A list of package ids imported into this instance (if any). Use GetImportedPackage to get the details of the imported packages.
        """
        return pulumi.get(self, "imported_package_ids")

    @property
    @pulumi.getter(name="importedPackageNames")
    def imported_package_names(self) -> Sequence[builtins.str]:
        """
        A list of package names imported into this instance (if any). Use importedPackageIds field to get the details of the imported packages.
        """
        return pulumi.get(self, "imported_package_names")

    @property
    @pulumi.getter(name="isRoleBasedAccess")
    def is_role_based_access(self) -> builtins.bool:
        """
        Should this Digital Assistant instance use role-based authorization via an identity domain (true) or use the default policy-based authorization via IAM policies (false)
        """
        return pulumi.get(self, "is_role_based_access")

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> builtins.str:
        """
        The current sub-state of the Digital Assistant instance.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @property
    @pulumi.getter(name="restrictedOperations")
    def restricted_operations(self) -> Sequence['outputs.GetOdaInstancesOdaInstanceRestrictedOperationResult']:
        """
        A list of restricted operations (across all attachments) for this instance (if any). Use GetOdaInstanceAttachment to get the details of the attachments.
        """
        return pulumi.get(self, "restricted_operations")

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> builtins.str:
        """
        Shape or size of the instance.
        """
        return pulumi.get(self, "shape_name")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        List only the Digital Assistant instances that are in this lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> builtins.str:
        """
        A message that describes the current state in more detail. For example, actionable information about an instance that's in the `FAILED` state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        When the Digital Assistant instance was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        When the Digital Assistance instance was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="webAppUrl")
    def web_app_url(self) -> builtins.str:
        """
        URL for the Digital Assistant web application that's associated with the instance.
        """
        return pulumi.get(self, "web_app_url")


@pulumi.output_type
class GetOdaInstancesOdaInstanceRestrictedOperationResult(dict):
    def __init__(__self__, *,
                 operation_name: builtins.str,
                 restricting_service: builtins.str):
        """
        :param builtins.str operation_name: Name of the restricted operation.
        :param builtins.str restricting_service: Name of the service restricting the operation.
        """
        pulumi.set(__self__, "operation_name", operation_name)
        pulumi.set(__self__, "restricting_service", restricting_service)

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> builtins.str:
        """
        Name of the restricted operation.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="restrictingService")
    def restricting_service(self) -> builtins.str:
        """
        Name of the service restricting the operation.
        """
        return pulumi.get(self, "restricting_service")


@pulumi.output_type
class GetOdaPrivateEndpointAttachmentsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 id: builtins.str,
                 oda_instance_id: builtins.str,
                 oda_private_endpoint_id: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str compartment_id: List the ODA Private Endpoint Attachments that belong to this compartment.
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ODA Private Endpoint Attachment.
        :param builtins.str oda_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the attached ODA Instance.
        :param builtins.str oda_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of ODA Private Endpoint.
        :param builtins.str state: List only the ODA Private Endpoint Attachments that are in this lifecycle state.
        :param builtins.str time_created: When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str time_updated: When the resource was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "oda_instance_id", oda_instance_id)
        pulumi.set(__self__, "oda_private_endpoint_id", oda_private_endpoint_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        List the ODA Private Endpoint Attachments that belong to this compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ODA Private Endpoint Attachment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="odaInstanceId")
    def oda_instance_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the attached ODA Instance.
        """
        return pulumi.get(self, "oda_instance_id")

    @property
    @pulumi.getter(name="odaPrivateEndpointId")
    def oda_private_endpoint_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of ODA Private Endpoint.
        """
        return pulumi.get(self, "oda_private_endpoint_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        List only the ODA Private Endpoint Attachments that are in this lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        When the resource was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxiesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 oda_private_endpoint_id: builtins.str,
                 protocol: builtins.str,
                 scan_listener_infos: Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoResult'],
                 scan_listener_type: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str):
        """
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ODA Private Endpoint Scan Proxy.
        :param builtins.str oda_private_endpoint_id: Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param builtins.str protocol: The protocol used for communication between client, scanProxy and RAC's scan listeners
        :param Sequence['GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoArgs'] scan_listener_infos: The FQDN/IPs and port information of customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param builtins.str scan_listener_type: Type indicating whether Scan listener is specified by its FQDN or list of IPs
        :param builtins.str state: List only the ODA Private Endpoint Scan Proxies that are in this lifecycle state.
        :param builtins.str time_created: When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "oda_private_endpoint_id", oda_private_endpoint_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "scan_listener_infos", scan_listener_infos)
        pulumi.set(__self__, "scan_listener_type", scan_listener_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ODA Private Endpoint Scan Proxy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="odaPrivateEndpointId")
    def oda_private_endpoint_id(self) -> builtins.str:
        """
        Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "oda_private_endpoint_id")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        The protocol used for communication between client, scanProxy and RAC's scan listeners
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="scanListenerInfos")
    def scan_listener_infos(self) -> Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoResult']:
        """
        The FQDN/IPs and port information of customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_infos")

    @property
    @pulumi.getter(name="scanListenerType")
    def scan_listener_type(self) -> builtins.str:
        """
        Type indicating whether Scan listener is specified by its FQDN or list of IPs
        """
        return pulumi.get(self, "scan_listener_type")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        List only the ODA Private Endpoint Scan Proxies that are in this lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoResult(dict):
    def __init__(__self__, *,
                 scan_listener_fqdn: builtins.str,
                 scan_listener_ip: builtins.str,
                 scan_listener_port: builtins.int):
        """
        :param builtins.str scan_listener_fqdn: FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param builtins.str scan_listener_ip: A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        :param builtins.int scan_listener_port: The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        pulumi.set(__self__, "scan_listener_fqdn", scan_listener_fqdn)
        pulumi.set(__self__, "scan_listener_ip", scan_listener_ip)
        pulumi.set(__self__, "scan_listener_port", scan_listener_port)

    @property
    @pulumi.getter(name="scanListenerFqdn")
    def scan_listener_fqdn(self) -> builtins.str:
        """
        FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_fqdn")

    @property
    @pulumi.getter(name="scanListenerIp")
    def scan_listener_ip(self) -> builtins.str:
        """
        A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        """
        return pulumi.get(self, "scan_listener_ip")

    @property
    @pulumi.getter(name="scanListenerPort")
    def scan_listener_port(self) -> builtins.int:
        """
        The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        return pulumi.get(self, "scan_listener_port")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxyScanListenerInfoResult(dict):
    def __init__(__self__, *,
                 scan_listener_fqdn: builtins.str,
                 scan_listener_ip: builtins.str,
                 scan_listener_port: builtins.int):
        """
        :param builtins.str scan_listener_fqdn: FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param builtins.str scan_listener_ip: A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        :param builtins.int scan_listener_port: The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        pulumi.set(__self__, "scan_listener_fqdn", scan_listener_fqdn)
        pulumi.set(__self__, "scan_listener_ip", scan_listener_ip)
        pulumi.set(__self__, "scan_listener_port", scan_listener_port)

    @property
    @pulumi.getter(name="scanListenerFqdn")
    def scan_listener_fqdn(self) -> builtins.str:
        """
        FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_fqdn")

    @property
    @pulumi.getter(name="scanListenerIp")
    def scan_listener_ip(self) -> builtins.str:
        """
        A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        """
        return pulumi.get(self, "scan_listener_ip")

    @property
    @pulumi.getter(name="scanListenerPort")
    def scan_listener_port(self) -> builtins.int:
        """
        The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        return pulumi.get(self, "scan_listener_port")


@pulumi.output_type
class GetOdaPrivateEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOdaPrivateEndpointsOdaPrivateEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOdaPrivateEndpointsOdaPrivateEndpointCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOdaPrivateEndpointsOdaPrivateEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOdaPrivateEndpointsOdaPrivateEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 nsg_ids: Sequence[builtins.str],
                 state: builtins.str,
                 subnet_id: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str compartment_id: List the ODA Private Endpoints that belong to this compartment.
        :param Mapping[str, builtins.str] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: Description of the ODA private endpoint.
        :param builtins.str display_name: List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Example: `{"bar-key": "value"}`
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that was assigned when the ODA private endpoint was created.
        :param Sequence[builtins.str] nsg_ids: List of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of [network security groups](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/networksecuritygroups.htm)
        :param builtins.str state: List only the ODA Private Endpoints that are in this lifecycle state.
        :param builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that the private endpoint belongs to.
        :param builtins.str time_created: When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str time_updated: When the resource was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        List the ODA Private Endpoints that belong to this compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the ODA private endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that was assigned when the ODA private endpoint was created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        List of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of [network security groups](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/networksecuritygroups.htm)
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        List only the ODA Private Endpoints that are in this lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that the private endpoint belongs to.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        When the resource was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")


