# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceManagementArgs', 'ManagedInstanceManagement']

@pulumi.input_type
class ManagedInstanceManagementArgs:
    def __init__(__self__, *,
                 managed_instance_id: pulumi.Input[builtins.str],
                 child_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementChildSoftwareSourceArgs']]]] = None,
                 managed_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementManagedInstanceGroupArgs']]]] = None,
                 parent_software_source: Optional[pulumi.Input['ManagedInstanceManagementParentSoftwareSourceArgs']] = None):
        """
        The set of arguments for constructing a ManagedInstanceManagement resource.
        :param pulumi.Input[builtins.str] managed_instance_id: OCID for the managed instance
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementChildSoftwareSourceArgs']]] child_software_sources: (Updatable) list of child Software Sources attached to the Managed Instance
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementManagedInstanceGroupArgs']]] managed_instance_groups: (Updatable) The ids of the managed instance groups of which this instance is a member.
        :param pulumi.Input['ManagedInstanceManagementParentSoftwareSourceArgs'] parent_software_source: (Updatable) the parent (base) Software Source attached to the Managed Instance
        """
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if child_software_sources is not None:
            pulumi.set(__self__, "child_software_sources", child_software_sources)
        if managed_instance_groups is not None:
            pulumi.set(__self__, "managed_instance_groups", managed_instance_groups)
        if parent_software_source is not None:
            pulumi.set(__self__, "parent_software_source", parent_software_source)

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Input[builtins.str]:
        """
        OCID for the managed instance
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "managed_instance_id", value)

    @property
    @pulumi.getter(name="childSoftwareSources")
    def child_software_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementChildSoftwareSourceArgs']]]]:
        """
        (Updatable) list of child Software Sources attached to the Managed Instance
        """
        return pulumi.get(self, "child_software_sources")

    @child_software_sources.setter
    def child_software_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementChildSoftwareSourceArgs']]]]):
        pulumi.set(self, "child_software_sources", value)

    @property
    @pulumi.getter(name="managedInstanceGroups")
    def managed_instance_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementManagedInstanceGroupArgs']]]]:
        """
        (Updatable) The ids of the managed instance groups of which this instance is a member.
        """
        return pulumi.get(self, "managed_instance_groups")

    @managed_instance_groups.setter
    def managed_instance_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementManagedInstanceGroupArgs']]]]):
        pulumi.set(self, "managed_instance_groups", value)

    @property
    @pulumi.getter(name="parentSoftwareSource")
    def parent_software_source(self) -> Optional[pulumi.Input['ManagedInstanceManagementParentSoftwareSourceArgs']]:
        """
        (Updatable) the parent (base) Software Source attached to the Managed Instance
        """
        return pulumi.get(self, "parent_software_source")

    @parent_software_source.setter
    def parent_software_source(self, value: Optional[pulumi.Input['ManagedInstanceManagementParentSoftwareSourceArgs']]):
        pulumi.set(self, "parent_software_source", value)


@pulumi.input_type
class _ManagedInstanceManagementState:
    def __init__(__self__, *,
                 child_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementChildSoftwareSourceArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_boot: Optional[pulumi.Input[builtins.str]] = None,
                 last_checkin: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementManagedInstanceGroupArgs']]]] = None,
                 managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 os_kernel_version: Optional[pulumi.Input[builtins.str]] = None,
                 os_name: Optional[pulumi.Input[builtins.str]] = None,
                 os_version: Optional[pulumi.Input[builtins.str]] = None,
                 parent_software_source: Optional[pulumi.Input['ManagedInstanceManagementParentSoftwareSourceArgs']] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 updates_available: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceManagement resources.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementChildSoftwareSourceArgs']]] child_software_sources: (Updatable) list of child Software Sources attached to the Managed Instance
        :param pulumi.Input[builtins.str] compartment_id: OCID for the Compartment
        :param pulumi.Input[builtins.str] description: Information specified by the user about the managed instance
        :param pulumi.Input[builtins.str] display_name: User friendly name
        :param pulumi.Input[builtins.str] last_boot: Time at which the instance last booted
        :param pulumi.Input[builtins.str] last_checkin: Time at which the instance last checked in
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementManagedInstanceGroupArgs']]] managed_instance_groups: (Updatable) The ids of the managed instance groups of which this instance is a member.
        :param pulumi.Input[builtins.str] managed_instance_id: OCID for the managed instance
        :param pulumi.Input[builtins.str] os_kernel_version: Operating System Kernel Version
        :param pulumi.Input[builtins.str] os_name: Operating System Name
        :param pulumi.Input[builtins.str] os_version: Operating System Version
        :param pulumi.Input['ManagedInstanceManagementParentSoftwareSourceArgs'] parent_software_source: (Updatable) the parent (base) Software Source attached to the Managed Instance
        :param pulumi.Input[builtins.str] status: status of the managed instance.
        :param pulumi.Input[builtins.int] updates_available: Number of updates available to be installed
        """
        if child_software_sources is not None:
            pulumi.set(__self__, "child_software_sources", child_software_sources)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if last_boot is not None:
            pulumi.set(__self__, "last_boot", last_boot)
        if last_checkin is not None:
            pulumi.set(__self__, "last_checkin", last_checkin)
        if managed_instance_groups is not None:
            pulumi.set(__self__, "managed_instance_groups", managed_instance_groups)
        if managed_instance_id is not None:
            pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if os_kernel_version is not None:
            pulumi.set(__self__, "os_kernel_version", os_kernel_version)
        if os_name is not None:
            pulumi.set(__self__, "os_name", os_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if parent_software_source is not None:
            pulumi.set(__self__, "parent_software_source", parent_software_source)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updates_available is not None:
            pulumi.set(__self__, "updates_available", updates_available)

    @property
    @pulumi.getter(name="childSoftwareSources")
    def child_software_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementChildSoftwareSourceArgs']]]]:
        """
        (Updatable) list of child Software Sources attached to the Managed Instance
        """
        return pulumi.get(self, "child_software_sources")

    @child_software_sources.setter
    def child_software_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementChildSoftwareSourceArgs']]]]):
        pulumi.set(self, "child_software_sources", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID for the Compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Information specified by the user about the managed instance
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User friendly name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="lastBoot")
    def last_boot(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time at which the instance last booted
        """
        return pulumi.get(self, "last_boot")

    @last_boot.setter
    def last_boot(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_boot", value)

    @property
    @pulumi.getter(name="lastCheckin")
    def last_checkin(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time at which the instance last checked in
        """
        return pulumi.get(self, "last_checkin")

    @last_checkin.setter
    def last_checkin(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_checkin", value)

    @property
    @pulumi.getter(name="managedInstanceGroups")
    def managed_instance_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementManagedInstanceGroupArgs']]]]:
        """
        (Updatable) The ids of the managed instance groups of which this instance is a member.
        """
        return pulumi.get(self, "managed_instance_groups")

    @managed_instance_groups.setter
    def managed_instance_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagementManagedInstanceGroupArgs']]]]):
        pulumi.set(self, "managed_instance_groups", value)

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID for the managed instance
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_instance_id", value)

    @property
    @pulumi.getter(name="osKernelVersion")
    def os_kernel_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Operating System Kernel Version
        """
        return pulumi.get(self, "os_kernel_version")

    @os_kernel_version.setter
    def os_kernel_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_kernel_version", value)

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Operating System Name
        """
        return pulumi.get(self, "os_name")

    @os_name.setter
    def os_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_name", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Operating System Version
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_version", value)

    @property
    @pulumi.getter(name="parentSoftwareSource")
    def parent_software_source(self) -> Optional[pulumi.Input['ManagedInstanceManagementParentSoftwareSourceArgs']]:
        """
        (Updatable) the parent (base) Software Source attached to the Managed Instance
        """
        return pulumi.get(self, "parent_software_source")

    @parent_software_source.setter
    def parent_software_source(self, value: Optional[pulumi.Input['ManagedInstanceManagementParentSoftwareSourceArgs']]):
        pulumi.set(self, "parent_software_source", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        status of the managed instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updatesAvailable")
    def updates_available(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of updates available to be installed
        """
        return pulumi.get(self, "updates_available")

    @updates_available.setter
    def updates_available(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "updates_available", value)


class ManagedInstanceManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 child_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceManagementChildSoftwareSourceArgs', 'ManagedInstanceManagementChildSoftwareSourceArgsDict']]]]] = None,
                 managed_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceManagementManagedInstanceGroupArgs', 'ManagedInstanceManagementManagedInstanceGroupArgsDict']]]]] = None,
                 managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 parent_software_source: Optional[pulumi.Input[Union['ManagedInstanceManagementParentSoftwareSourceArgs', 'ManagedInstanceManagementParentSoftwareSourceArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Managed Instance Management in Oracle Cloud Infrastructure OS Management service.
        The resource can be used to attach/detach parent software source, child software sources and managed instance groups from managed instances.

        Adds a parent software source to a managed instance. After the software source has been added, then packages from that software source can be installed on the managed instance. Software sources that have this software source as a parent will be able to be added to this managed instance.
        Removes a software source from a managed instance. All child software sources will also be removed from the managed instance. Packages will no longer be able to be installed from these software sources.

        Adds a child software source to a managed instance. After the software source has been added, then packages from that software source can be installed on the managed instance.\\
        Removes a child software source from a managed instance. Packages will no longer be able to be installed from these software sources.

        Adds a Managed Instance to a Managed Instance Group. After the Managed Instance has been added, then operations can be performed on the Managed Instance Group which will then apply to all Managed Instances in the group.
        Removes a Managed Instance from a Managed Instance Group.

        **NOTE** The resource on CREATE will detach any already attached parent software source, child software sources, managed instance groups to the managed instance.
        Destroying this resource will not delete any associations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_management = oci.os_management.ManagedInstanceManagement("test_managed_instance_management",
            managed_instance_id=test_managed_instance["id"],
            parent_software_source={
                "id": test_parent_software_source["id"],
                "name": test_parent_software_source["displayName"],
            },
            managed_instance_groups=[{
                "id": test_managed_instance_group["id"],
                "display_name": managed_instance_group_display_name,
            }],
            child_software_sources=[{
                "id": test_software_source_child["id"],
                "name": test_software_source_child["displayName"],
            }])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceManagementChildSoftwareSourceArgs', 'ManagedInstanceManagementChildSoftwareSourceArgsDict']]]] child_software_sources: (Updatable) list of child Software Sources attached to the Managed Instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceManagementManagedInstanceGroupArgs', 'ManagedInstanceManagementManagedInstanceGroupArgsDict']]]] managed_instance_groups: (Updatable) The ids of the managed instance groups of which this instance is a member.
        :param pulumi.Input[builtins.str] managed_instance_id: OCID for the managed instance
        :param pulumi.Input[Union['ManagedInstanceManagementParentSoftwareSourceArgs', 'ManagedInstanceManagementParentSoftwareSourceArgsDict']] parent_software_source: (Updatable) the parent (base) Software Source attached to the Managed Instance
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Instance Management in Oracle Cloud Infrastructure OS Management service.
        The resource can be used to attach/detach parent software source, child software sources and managed instance groups from managed instances.

        Adds a parent software source to a managed instance. After the software source has been added, then packages from that software source can be installed on the managed instance. Software sources that have this software source as a parent will be able to be added to this managed instance.
        Removes a software source from a managed instance. All child software sources will also be removed from the managed instance. Packages will no longer be able to be installed from these software sources.

        Adds a child software source to a managed instance. After the software source has been added, then packages from that software source can be installed on the managed instance.\\
        Removes a child software source from a managed instance. Packages will no longer be able to be installed from these software sources.

        Adds a Managed Instance to a Managed Instance Group. After the Managed Instance has been added, then operations can be performed on the Managed Instance Group which will then apply to all Managed Instances in the group.
        Removes a Managed Instance from a Managed Instance Group.

        **NOTE** The resource on CREATE will detach any already attached parent software source, child software sources, managed instance groups to the managed instance.
        Destroying this resource will not delete any associations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_management = oci.os_management.ManagedInstanceManagement("test_managed_instance_management",
            managed_instance_id=test_managed_instance["id"],
            parent_software_source={
                "id": test_parent_software_source["id"],
                "name": test_parent_software_source["displayName"],
            },
            managed_instance_groups=[{
                "id": test_managed_instance_group["id"],
                "display_name": managed_instance_group_display_name,
            }],
            child_software_sources=[{
                "id": test_software_source_child["id"],
                "name": test_software_source_child["displayName"],
            }])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ManagedInstanceManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 child_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceManagementChildSoftwareSourceArgs', 'ManagedInstanceManagementChildSoftwareSourceArgsDict']]]]] = None,
                 managed_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceManagementManagedInstanceGroupArgs', 'ManagedInstanceManagementManagedInstanceGroupArgsDict']]]]] = None,
                 managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 parent_software_source: Optional[pulumi.Input[Union['ManagedInstanceManagementParentSoftwareSourceArgs', 'ManagedInstanceManagementParentSoftwareSourceArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceManagementArgs.__new__(ManagedInstanceManagementArgs)

            __props__.__dict__["child_software_sources"] = child_software_sources
            __props__.__dict__["managed_instance_groups"] = managed_instance_groups
            if managed_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_id'")
            __props__.__dict__["managed_instance_id"] = managed_instance_id
            __props__.__dict__["parent_software_source"] = parent_software_source
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["last_boot"] = None
            __props__.__dict__["last_checkin"] = None
            __props__.__dict__["os_kernel_version"] = None
            __props__.__dict__["os_name"] = None
            __props__.__dict__["os_version"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updates_available"] = None
        super(ManagedInstanceManagement, __self__).__init__(
            'oci:OsManagement/managedInstanceManagement:ManagedInstanceManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            child_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceManagementChildSoftwareSourceArgs', 'ManagedInstanceManagementChildSoftwareSourceArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            last_boot: Optional[pulumi.Input[builtins.str]] = None,
            last_checkin: Optional[pulumi.Input[builtins.str]] = None,
            managed_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceManagementManagedInstanceGroupArgs', 'ManagedInstanceManagementManagedInstanceGroupArgsDict']]]]] = None,
            managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
            os_kernel_version: Optional[pulumi.Input[builtins.str]] = None,
            os_name: Optional[pulumi.Input[builtins.str]] = None,
            os_version: Optional[pulumi.Input[builtins.str]] = None,
            parent_software_source: Optional[pulumi.Input[Union['ManagedInstanceManagementParentSoftwareSourceArgs', 'ManagedInstanceManagementParentSoftwareSourceArgsDict']]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            updates_available: Optional[pulumi.Input[builtins.int]] = None) -> 'ManagedInstanceManagement':
        """
        Get an existing ManagedInstanceManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceManagementChildSoftwareSourceArgs', 'ManagedInstanceManagementChildSoftwareSourceArgsDict']]]] child_software_sources: (Updatable) list of child Software Sources attached to the Managed Instance
        :param pulumi.Input[builtins.str] compartment_id: OCID for the Compartment
        :param pulumi.Input[builtins.str] description: Information specified by the user about the managed instance
        :param pulumi.Input[builtins.str] display_name: User friendly name
        :param pulumi.Input[builtins.str] last_boot: Time at which the instance last booted
        :param pulumi.Input[builtins.str] last_checkin: Time at which the instance last checked in
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceManagementManagedInstanceGroupArgs', 'ManagedInstanceManagementManagedInstanceGroupArgsDict']]]] managed_instance_groups: (Updatable) The ids of the managed instance groups of which this instance is a member.
        :param pulumi.Input[builtins.str] managed_instance_id: OCID for the managed instance
        :param pulumi.Input[builtins.str] os_kernel_version: Operating System Kernel Version
        :param pulumi.Input[builtins.str] os_name: Operating System Name
        :param pulumi.Input[builtins.str] os_version: Operating System Version
        :param pulumi.Input[Union['ManagedInstanceManagementParentSoftwareSourceArgs', 'ManagedInstanceManagementParentSoftwareSourceArgsDict']] parent_software_source: (Updatable) the parent (base) Software Source attached to the Managed Instance
        :param pulumi.Input[builtins.str] status: status of the managed instance.
        :param pulumi.Input[builtins.int] updates_available: Number of updates available to be installed
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceManagementState.__new__(_ManagedInstanceManagementState)

        __props__.__dict__["child_software_sources"] = child_software_sources
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["last_boot"] = last_boot
        __props__.__dict__["last_checkin"] = last_checkin
        __props__.__dict__["managed_instance_groups"] = managed_instance_groups
        __props__.__dict__["managed_instance_id"] = managed_instance_id
        __props__.__dict__["os_kernel_version"] = os_kernel_version
        __props__.__dict__["os_name"] = os_name
        __props__.__dict__["os_version"] = os_version
        __props__.__dict__["parent_software_source"] = parent_software_source
        __props__.__dict__["status"] = status
        __props__.__dict__["updates_available"] = updates_available
        return ManagedInstanceManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="childSoftwareSources")
    def child_software_sources(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceManagementChildSoftwareSource']]:
        """
        (Updatable) list of child Software Sources attached to the Managed Instance
        """
        return pulumi.get(self, "child_software_sources")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        OCID for the Compartment
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Information specified by the user about the managed instance
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        User friendly name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="lastBoot")
    def last_boot(self) -> pulumi.Output[builtins.str]:
        """
        Time at which the instance last booted
        """
        return pulumi.get(self, "last_boot")

    @property
    @pulumi.getter(name="lastCheckin")
    def last_checkin(self) -> pulumi.Output[builtins.str]:
        """
        Time at which the instance last checked in
        """
        return pulumi.get(self, "last_checkin")

    @property
    @pulumi.getter(name="managedInstanceGroups")
    def managed_instance_groups(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceManagementManagedInstanceGroup']]:
        """
        (Updatable) The ids of the managed instance groups of which this instance is a member.
        """
        return pulumi.get(self, "managed_instance_groups")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Output[builtins.str]:
        """
        OCID for the managed instance
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="osKernelVersion")
    def os_kernel_version(self) -> pulumi.Output[builtins.str]:
        """
        Operating System Kernel Version
        """
        return pulumi.get(self, "os_kernel_version")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> pulumi.Output[builtins.str]:
        """
        Operating System Name
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> pulumi.Output[builtins.str]:
        """
        Operating System Version
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="parentSoftwareSource")
    def parent_software_source(self) -> pulumi.Output['outputs.ManagedInstanceManagementParentSoftwareSource']:
        """
        (Updatable) the parent (base) Software Source attached to the Managed Instance
        """
        return pulumi.get(self, "parent_software_source")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        status of the managed instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatesAvailable")
    def updates_available(self) -> pulumi.Output[builtins.int]:
        """
        Number of updates available to be installed
        """
        return pulumi.get(self, "updates_available")

