# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedInstanceResult',
    'AwaitableGetManagedInstanceResult',
    'get_managed_instance',
    'get_managed_instance_output',
]

@pulumi.output_type
class GetManagedInstanceResult:
    """
    A collection of values returned by getManagedInstance.
    """
    def __init__(__self__, agent_version=None, architecture=None, autonomous_settings=None, bug_updates_available=None, compartment_id=None, description=None, display_name=None, enhancement_updates_available=None, id=None, installed_packages=None, installed_windows_updates=None, is_managed_by_autonomous_linux=None, is_management_station=None, is_reboot_required=None, ksplice_effective_kernel_version=None, lifecycle_environments=None, lifecycle_stages=None, location=None, managed_instance_groups=None, managed_instance_id=None, notification_topic_id=None, os_family=None, os_kernel_version=None, os_name=None, os_version=None, other_updates_available=None, primary_management_station_id=None, profile=None, profile_version=None, scheduled_job_count=None, secondary_management_station_id=None, security_updates_available=None, software_sources=None, status=None, tenancy_id=None, time_created=None, time_last_boot=None, time_last_checkin=None, time_updated=None, updates_available=None, work_request_count=None):
        if agent_version and not isinstance(agent_version, str):
            raise TypeError("Expected argument 'agent_version' to be a str")
        pulumi.set(__self__, "agent_version", agent_version)
        if architecture and not isinstance(architecture, str):
            raise TypeError("Expected argument 'architecture' to be a str")
        pulumi.set(__self__, "architecture", architecture)
        if autonomous_settings and not isinstance(autonomous_settings, list):
            raise TypeError("Expected argument 'autonomous_settings' to be a list")
        pulumi.set(__self__, "autonomous_settings", autonomous_settings)
        if bug_updates_available and not isinstance(bug_updates_available, int):
            raise TypeError("Expected argument 'bug_updates_available' to be a int")
        pulumi.set(__self__, "bug_updates_available", bug_updates_available)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if enhancement_updates_available and not isinstance(enhancement_updates_available, int):
            raise TypeError("Expected argument 'enhancement_updates_available' to be a int")
        pulumi.set(__self__, "enhancement_updates_available", enhancement_updates_available)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if installed_packages and not isinstance(installed_packages, int):
            raise TypeError("Expected argument 'installed_packages' to be a int")
        pulumi.set(__self__, "installed_packages", installed_packages)
        if installed_windows_updates and not isinstance(installed_windows_updates, int):
            raise TypeError("Expected argument 'installed_windows_updates' to be a int")
        pulumi.set(__self__, "installed_windows_updates", installed_windows_updates)
        if is_managed_by_autonomous_linux and not isinstance(is_managed_by_autonomous_linux, bool):
            raise TypeError("Expected argument 'is_managed_by_autonomous_linux' to be a bool")
        pulumi.set(__self__, "is_managed_by_autonomous_linux", is_managed_by_autonomous_linux)
        if is_management_station and not isinstance(is_management_station, bool):
            raise TypeError("Expected argument 'is_management_station' to be a bool")
        pulumi.set(__self__, "is_management_station", is_management_station)
        if is_reboot_required and not isinstance(is_reboot_required, bool):
            raise TypeError("Expected argument 'is_reboot_required' to be a bool")
        pulumi.set(__self__, "is_reboot_required", is_reboot_required)
        if ksplice_effective_kernel_version and not isinstance(ksplice_effective_kernel_version, str):
            raise TypeError("Expected argument 'ksplice_effective_kernel_version' to be a str")
        pulumi.set(__self__, "ksplice_effective_kernel_version", ksplice_effective_kernel_version)
        if lifecycle_environments and not isinstance(lifecycle_environments, list):
            raise TypeError("Expected argument 'lifecycle_environments' to be a list")
        pulumi.set(__self__, "lifecycle_environments", lifecycle_environments)
        if lifecycle_stages and not isinstance(lifecycle_stages, list):
            raise TypeError("Expected argument 'lifecycle_stages' to be a list")
        pulumi.set(__self__, "lifecycle_stages", lifecycle_stages)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if managed_instance_groups and not isinstance(managed_instance_groups, list):
            raise TypeError("Expected argument 'managed_instance_groups' to be a list")
        pulumi.set(__self__, "managed_instance_groups", managed_instance_groups)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if notification_topic_id and not isinstance(notification_topic_id, str):
            raise TypeError("Expected argument 'notification_topic_id' to be a str")
        pulumi.set(__self__, "notification_topic_id", notification_topic_id)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if os_kernel_version and not isinstance(os_kernel_version, str):
            raise TypeError("Expected argument 'os_kernel_version' to be a str")
        pulumi.set(__self__, "os_kernel_version", os_kernel_version)
        if os_name and not isinstance(os_name, str):
            raise TypeError("Expected argument 'os_name' to be a str")
        pulumi.set(__self__, "os_name", os_name)
        if os_version and not isinstance(os_version, str):
            raise TypeError("Expected argument 'os_version' to be a str")
        pulumi.set(__self__, "os_version", os_version)
        if other_updates_available and not isinstance(other_updates_available, int):
            raise TypeError("Expected argument 'other_updates_available' to be a int")
        pulumi.set(__self__, "other_updates_available", other_updates_available)
        if primary_management_station_id and not isinstance(primary_management_station_id, str):
            raise TypeError("Expected argument 'primary_management_station_id' to be a str")
        pulumi.set(__self__, "primary_management_station_id", primary_management_station_id)
        if profile and not isinstance(profile, str):
            raise TypeError("Expected argument 'profile' to be a str")
        pulumi.set(__self__, "profile", profile)
        if profile_version and not isinstance(profile_version, str):
            raise TypeError("Expected argument 'profile_version' to be a str")
        pulumi.set(__self__, "profile_version", profile_version)
        if scheduled_job_count and not isinstance(scheduled_job_count, int):
            raise TypeError("Expected argument 'scheduled_job_count' to be a int")
        pulumi.set(__self__, "scheduled_job_count", scheduled_job_count)
        if secondary_management_station_id and not isinstance(secondary_management_station_id, str):
            raise TypeError("Expected argument 'secondary_management_station_id' to be a str")
        pulumi.set(__self__, "secondary_management_station_id", secondary_management_station_id)
        if security_updates_available and not isinstance(security_updates_available, int):
            raise TypeError("Expected argument 'security_updates_available' to be a int")
        pulumi.set(__self__, "security_updates_available", security_updates_available)
        if software_sources and not isinstance(software_sources, list):
            raise TypeError("Expected argument 'software_sources' to be a list")
        pulumi.set(__self__, "software_sources", software_sources)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tenancy_id and not isinstance(tenancy_id, str):
            raise TypeError("Expected argument 'tenancy_id' to be a str")
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_boot and not isinstance(time_last_boot, str):
            raise TypeError("Expected argument 'time_last_boot' to be a str")
        pulumi.set(__self__, "time_last_boot", time_last_boot)
        if time_last_checkin and not isinstance(time_last_checkin, str):
            raise TypeError("Expected argument 'time_last_checkin' to be a str")
        pulumi.set(__self__, "time_last_checkin", time_last_checkin)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if updates_available and not isinstance(updates_available, int):
            raise TypeError("Expected argument 'updates_available' to be a int")
        pulumi.set(__self__, "updates_available", updates_available)
        if work_request_count and not isinstance(work_request_count, int):
            raise TypeError("Expected argument 'work_request_count' to be a int")
        pulumi.set(__self__, "work_request_count", work_request_count)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> builtins.str:
        """
        The version of osmh-agent running on the managed instance
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter
    def architecture(self) -> builtins.str:
        """
        The CPU architecture type of the managed instance.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="autonomousSettings")
    def autonomous_settings(self) -> Sequence['outputs.GetManagedInstanceAutonomousSettingResult']:
        """
        Settings for the Autonomous Linux service.
        """
        return pulumi.get(self, "autonomous_settings")

    @property
    @pulumi.getter(name="bugUpdatesAvailable")
    def bug_updates_available(self) -> builtins.int:
        """
        Number of bug fix type updates available for installation.
        """
        return pulumi.get(self, "bug_updates_available")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the managed instance.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Software source description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Software source name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enhancementUpdatesAvailable")
    def enhancement_updates_available(self) -> builtins.int:
        """
        Number of enhancement type updates available for installation.
        """
        return pulumi.get(self, "enhancement_updates_available")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="installedPackages")
    def installed_packages(self) -> builtins.int:
        """
        Number of packages installed on the instance.
        """
        return pulumi.get(self, "installed_packages")

    @property
    @pulumi.getter(name="installedWindowsUpdates")
    def installed_windows_updates(self) -> builtins.int:
        """
        Number of Windows updates installed on the instance.
        """
        return pulumi.get(self, "installed_windows_updates")

    @property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> builtins.bool:
        """
        Indicates whether the Autonomous Linux service manages the instance.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @property
    @pulumi.getter(name="isManagementStation")
    def is_management_station(self) -> builtins.bool:
        """
        Indicates whether this managed instance is acting as an on-premises management station.
        """
        return pulumi.get(self, "is_management_station")

    @property
    @pulumi.getter(name="isRebootRequired")
    def is_reboot_required(self) -> builtins.bool:
        """
        Indicates whether a reboot is required to complete installation of updates.
        """
        return pulumi.get(self, "is_reboot_required")

    @property
    @pulumi.getter(name="kspliceEffectiveKernelVersion")
    def ksplice_effective_kernel_version(self) -> builtins.str:
        """
        The ksplice effective kernel version.
        """
        return pulumi.get(self, "ksplice_effective_kernel_version")

    @property
    @pulumi.getter(name="lifecycleEnvironments")
    def lifecycle_environments(self) -> Sequence['outputs.GetManagedInstanceLifecycleEnvironmentResult']:
        """
        Id and name of a resource to simplify the display for the user.
        """
        return pulumi.get(self, "lifecycle_environments")

    @property
    @pulumi.getter(name="lifecycleStages")
    def lifecycle_stages(self) -> Sequence['outputs.GetManagedInstanceLifecycleStageResult']:
        """
        Id and name of a resource to simplify the display for the user.
        """
        return pulumi.get(self, "lifecycle_stages")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location of the managed instance.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="managedInstanceGroups")
    def managed_instance_groups(self) -> Sequence['outputs.GetManagedInstanceManagedInstanceGroupResult']:
        """
        Id and name of a resource to simplify the display for the user.
        """
        return pulumi.get(self, "managed_instance_groups")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> builtins.str:
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        """
        return pulumi.get(self, "notification_topic_id")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> builtins.str:
        """
        The operating system type of the managed instance.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="osKernelVersion")
    def os_kernel_version(self) -> builtins.str:
        """
        Operating system kernel version.
        """
        return pulumi.get(self, "os_kernel_version")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> builtins.str:
        """
        Operating system name.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> builtins.str:
        """
        Operating system version.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="otherUpdatesAvailable")
    def other_updates_available(self) -> builtins.int:
        """
        Number of non-classified (other) updates available for installation.
        """
        return pulumi.get(self, "other_updates_available")

    @property
    @pulumi.getter(name="primaryManagementStationId")
    def primary_management_station_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as primary management station.
        """
        return pulumi.get(self, "primary_management_station_id")

    @property
    @pulumi.getter
    def profile(self) -> builtins.str:
        """
        The profile that was used to register this instance with the service.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="profileVersion")
    def profile_version(self) -> builtins.str:
        """
        The version of the profile that was used to register this instance with the service.
        """
        return pulumi.get(self, "profile_version")

    @property
    @pulumi.getter(name="scheduledJobCount")
    def scheduled_job_count(self) -> builtins.int:
        """
        Number of scheduled jobs associated with this instance.
        """
        return pulumi.get(self, "scheduled_job_count")

    @property
    @pulumi.getter(name="secondaryManagementStationId")
    def secondary_management_station_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station for the instance to use as secondary management station.
        """
        return pulumi.get(self, "secondary_management_station_id")

    @property
    @pulumi.getter(name="securityUpdatesAvailable")
    def security_updates_available(self) -> builtins.int:
        """
        Number of security type updates available for installation.
        """
        return pulumi.get(self, "security_updates_available")

    @property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> Sequence['outputs.GetManagedInstanceSoftwareSourceResult']:
        """
        The list of software sources currently attached to the managed instance.
        """
        return pulumi.get(self, "software_sources")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Current status of the managed instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy that the managed instance resides in.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the instance was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastBoot")
    def time_last_boot(self) -> builtins.str:
        """
        Time that the instance last booted (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_last_boot")

    @property
    @pulumi.getter(name="timeLastCheckin")
    def time_last_checkin(self) -> builtins.str:
        """
        Time that the instance last checked in with the service (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_last_checkin")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the instance was last updated (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="updatesAvailable")
    def updates_available(self) -> builtins.int:
        """
        Number of updates available for installation.
        """
        return pulumi.get(self, "updates_available")

    @property
    @pulumi.getter(name="workRequestCount")
    def work_request_count(self) -> builtins.int:
        """
        Number of work requests associated with this instance.
        """
        return pulumi.get(self, "work_request_count")


class AwaitableGetManagedInstanceResult(GetManagedInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedInstanceResult(
            agent_version=self.agent_version,
            architecture=self.architecture,
            autonomous_settings=self.autonomous_settings,
            bug_updates_available=self.bug_updates_available,
            compartment_id=self.compartment_id,
            description=self.description,
            display_name=self.display_name,
            enhancement_updates_available=self.enhancement_updates_available,
            id=self.id,
            installed_packages=self.installed_packages,
            installed_windows_updates=self.installed_windows_updates,
            is_managed_by_autonomous_linux=self.is_managed_by_autonomous_linux,
            is_management_station=self.is_management_station,
            is_reboot_required=self.is_reboot_required,
            ksplice_effective_kernel_version=self.ksplice_effective_kernel_version,
            lifecycle_environments=self.lifecycle_environments,
            lifecycle_stages=self.lifecycle_stages,
            location=self.location,
            managed_instance_groups=self.managed_instance_groups,
            managed_instance_id=self.managed_instance_id,
            notification_topic_id=self.notification_topic_id,
            os_family=self.os_family,
            os_kernel_version=self.os_kernel_version,
            os_name=self.os_name,
            os_version=self.os_version,
            other_updates_available=self.other_updates_available,
            primary_management_station_id=self.primary_management_station_id,
            profile=self.profile,
            profile_version=self.profile_version,
            scheduled_job_count=self.scheduled_job_count,
            secondary_management_station_id=self.secondary_management_station_id,
            security_updates_available=self.security_updates_available,
            software_sources=self.software_sources,
            status=self.status,
            tenancy_id=self.tenancy_id,
            time_created=self.time_created,
            time_last_boot=self.time_last_boot,
            time_last_checkin=self.time_last_checkin,
            time_updated=self.time_updated,
            updates_available=self.updates_available,
            work_request_count=self.work_request_count)


def get_managed_instance(managed_instance_id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedInstanceResult:
    """
    This data source provides details about a specific Managed Instance resource in Oracle Cloud Infrastructure Os Management Hub service.

    Gets information about the specified managed instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance = oci.OsManagementHub.get_managed_instance(managed_instance_id=test_managed_instance_oci_os_management_hub_managed_instance["id"])
    ```


    :param builtins.str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
    """
    __args__ = dict()
    __args__['managedInstanceId'] = managed_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getManagedInstance:getManagedInstance', __args__, opts=opts, typ=GetManagedInstanceResult).value

    return AwaitableGetManagedInstanceResult(
        agent_version=pulumi.get(__ret__, 'agent_version'),
        architecture=pulumi.get(__ret__, 'architecture'),
        autonomous_settings=pulumi.get(__ret__, 'autonomous_settings'),
        bug_updates_available=pulumi.get(__ret__, 'bug_updates_available'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        enhancement_updates_available=pulumi.get(__ret__, 'enhancement_updates_available'),
        id=pulumi.get(__ret__, 'id'),
        installed_packages=pulumi.get(__ret__, 'installed_packages'),
        installed_windows_updates=pulumi.get(__ret__, 'installed_windows_updates'),
        is_managed_by_autonomous_linux=pulumi.get(__ret__, 'is_managed_by_autonomous_linux'),
        is_management_station=pulumi.get(__ret__, 'is_management_station'),
        is_reboot_required=pulumi.get(__ret__, 'is_reboot_required'),
        ksplice_effective_kernel_version=pulumi.get(__ret__, 'ksplice_effective_kernel_version'),
        lifecycle_environments=pulumi.get(__ret__, 'lifecycle_environments'),
        lifecycle_stages=pulumi.get(__ret__, 'lifecycle_stages'),
        location=pulumi.get(__ret__, 'location'),
        managed_instance_groups=pulumi.get(__ret__, 'managed_instance_groups'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        notification_topic_id=pulumi.get(__ret__, 'notification_topic_id'),
        os_family=pulumi.get(__ret__, 'os_family'),
        os_kernel_version=pulumi.get(__ret__, 'os_kernel_version'),
        os_name=pulumi.get(__ret__, 'os_name'),
        os_version=pulumi.get(__ret__, 'os_version'),
        other_updates_available=pulumi.get(__ret__, 'other_updates_available'),
        primary_management_station_id=pulumi.get(__ret__, 'primary_management_station_id'),
        profile=pulumi.get(__ret__, 'profile'),
        profile_version=pulumi.get(__ret__, 'profile_version'),
        scheduled_job_count=pulumi.get(__ret__, 'scheduled_job_count'),
        secondary_management_station_id=pulumi.get(__ret__, 'secondary_management_station_id'),
        security_updates_available=pulumi.get(__ret__, 'security_updates_available'),
        software_sources=pulumi.get(__ret__, 'software_sources'),
        status=pulumi.get(__ret__, 'status'),
        tenancy_id=pulumi.get(__ret__, 'tenancy_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_boot=pulumi.get(__ret__, 'time_last_boot'),
        time_last_checkin=pulumi.get(__ret__, 'time_last_checkin'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        updates_available=pulumi.get(__ret__, 'updates_available'),
        work_request_count=pulumi.get(__ret__, 'work_request_count'))
def get_managed_instance_output(managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedInstanceResult]:
    """
    This data source provides details about a specific Managed Instance resource in Oracle Cloud Infrastructure Os Management Hub service.

    Gets information about the specified managed instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance = oci.OsManagementHub.get_managed_instance(managed_instance_id=test_managed_instance_oci_os_management_hub_managed_instance["id"])
    ```


    :param builtins.str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
    """
    __args__ = dict()
    __args__['managedInstanceId'] = managed_instance_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getManagedInstance:getManagedInstance', __args__, opts=opts, typ=GetManagedInstanceResult)
    return __ret__.apply(lambda __response__: GetManagedInstanceResult(
        agent_version=pulumi.get(__response__, 'agent_version'),
        architecture=pulumi.get(__response__, 'architecture'),
        autonomous_settings=pulumi.get(__response__, 'autonomous_settings'),
        bug_updates_available=pulumi.get(__response__, 'bug_updates_available'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        enhancement_updates_available=pulumi.get(__response__, 'enhancement_updates_available'),
        id=pulumi.get(__response__, 'id'),
        installed_packages=pulumi.get(__response__, 'installed_packages'),
        installed_windows_updates=pulumi.get(__response__, 'installed_windows_updates'),
        is_managed_by_autonomous_linux=pulumi.get(__response__, 'is_managed_by_autonomous_linux'),
        is_management_station=pulumi.get(__response__, 'is_management_station'),
        is_reboot_required=pulumi.get(__response__, 'is_reboot_required'),
        ksplice_effective_kernel_version=pulumi.get(__response__, 'ksplice_effective_kernel_version'),
        lifecycle_environments=pulumi.get(__response__, 'lifecycle_environments'),
        lifecycle_stages=pulumi.get(__response__, 'lifecycle_stages'),
        location=pulumi.get(__response__, 'location'),
        managed_instance_groups=pulumi.get(__response__, 'managed_instance_groups'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        notification_topic_id=pulumi.get(__response__, 'notification_topic_id'),
        os_family=pulumi.get(__response__, 'os_family'),
        os_kernel_version=pulumi.get(__response__, 'os_kernel_version'),
        os_name=pulumi.get(__response__, 'os_name'),
        os_version=pulumi.get(__response__, 'os_version'),
        other_updates_available=pulumi.get(__response__, 'other_updates_available'),
        primary_management_station_id=pulumi.get(__response__, 'primary_management_station_id'),
        profile=pulumi.get(__response__, 'profile'),
        profile_version=pulumi.get(__response__, 'profile_version'),
        scheduled_job_count=pulumi.get(__response__, 'scheduled_job_count'),
        secondary_management_station_id=pulumi.get(__response__, 'secondary_management_station_id'),
        security_updates_available=pulumi.get(__response__, 'security_updates_available'),
        software_sources=pulumi.get(__response__, 'software_sources'),
        status=pulumi.get(__response__, 'status'),
        tenancy_id=pulumi.get(__response__, 'tenancy_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_last_boot=pulumi.get(__response__, 'time_last_boot'),
        time_last_checkin=pulumi.get(__response__, 'time_last_checkin'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        updates_available=pulumi.get(__response__, 'updates_available'),
        work_request_count=pulumi.get(__response__, 'work_request_count')))
