# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCommitmentResult',
    'AwaitableGetCommitmentResult',
    'get_commitment',
    'get_commitment_output',
]

@pulumi.output_type
class GetCommitmentResult:
    """
    A collection of values returned by getCommitment.
    """
    def __init__(__self__, available_amount=None, commitment_id=None, funded_allocation_value=None, id=None, quantity=None, time_end=None, time_start=None, used_amount=None, x_one_gateway_subscription_id=None, x_one_origin_region=None):
        if available_amount and not isinstance(available_amount, str):
            raise TypeError("Expected argument 'available_amount' to be a str")
        pulumi.set(__self__, "available_amount", available_amount)
        if commitment_id and not isinstance(commitment_id, str):
            raise TypeError("Expected argument 'commitment_id' to be a str")
        pulumi.set(__self__, "commitment_id", commitment_id)
        if funded_allocation_value and not isinstance(funded_allocation_value, str):
            raise TypeError("Expected argument 'funded_allocation_value' to be a str")
        pulumi.set(__self__, "funded_allocation_value", funded_allocation_value)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if quantity and not isinstance(quantity, str):
            raise TypeError("Expected argument 'quantity' to be a str")
        pulumi.set(__self__, "quantity", quantity)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)
        if used_amount and not isinstance(used_amount, str):
            raise TypeError("Expected argument 'used_amount' to be a str")
        pulumi.set(__self__, "used_amount", used_amount)
        if x_one_gateway_subscription_id and not isinstance(x_one_gateway_subscription_id, str):
            raise TypeError("Expected argument 'x_one_gateway_subscription_id' to be a str")
        pulumi.set(__self__, "x_one_gateway_subscription_id", x_one_gateway_subscription_id)
        if x_one_origin_region and not isinstance(x_one_origin_region, str):
            raise TypeError("Expected argument 'x_one_origin_region' to be a str")
        pulumi.set(__self__, "x_one_origin_region", x_one_origin_region)

    @property
    @pulumi.getter(name="availableAmount")
    def available_amount(self) -> builtins.str:
        """
        Commitment available amount
        """
        return pulumi.get(self, "available_amount")

    @property
    @pulumi.getter(name="commitmentId")
    def commitment_id(self) -> builtins.str:
        return pulumi.get(self, "commitment_id")

    @property
    @pulumi.getter(name="fundedAllocationValue")
    def funded_allocation_value(self) -> builtins.str:
        """
        Funded Allocation line value example: 12000.00
        """
        return pulumi.get(self, "funded_allocation_value")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def quantity(self) -> builtins.str:
        """
        Commitment quantity
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> builtins.str:
        """
        Commitment end date
        """
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> builtins.str:
        """
        Commitment start date
        """
        return pulumi.get(self, "time_start")

    @property
    @pulumi.getter(name="usedAmount")
    def used_amount(self) -> builtins.str:
        """
        Commitment used amount
        """
        return pulumi.get(self, "used_amount")

    @property
    @pulumi.getter(name="xOneGatewaySubscriptionId")
    def x_one_gateway_subscription_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "x_one_gateway_subscription_id")

    @property
    @pulumi.getter(name="xOneOriginRegion")
    def x_one_origin_region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "x_one_origin_region")


class AwaitableGetCommitmentResult(GetCommitmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCommitmentResult(
            available_amount=self.available_amount,
            commitment_id=self.commitment_id,
            funded_allocation_value=self.funded_allocation_value,
            id=self.id,
            quantity=self.quantity,
            time_end=self.time_end,
            time_start=self.time_start,
            used_amount=self.used_amount,
            x_one_gateway_subscription_id=self.x_one_gateway_subscription_id,
            x_one_origin_region=self.x_one_origin_region)


def get_commitment(commitment_id: Optional[builtins.str] = None,
                   x_one_gateway_subscription_id: Optional[builtins.str] = None,
                   x_one_origin_region: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCommitmentResult:
    """
    This data source provides details about a specific Commitment resource in Oracle Cloud Infrastructure Osub Subscription service.

    This API returns the commitment details corresponding to the id provided

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_commitment = oci.OsubSubscription.get_commitment(commitment_id=test_commitment_oci_osub_subscription_commitment["id"],
        x_one_gateway_subscription_id=commitment_x_one_gateway_subscription_id,
        x_one_origin_region=commitment_x_one_origin_region)
    ```


    :param builtins.str commitment_id: The Commitment Id
    :param builtins.str x_one_gateway_subscription_id: This header is meant to be used only for internal purposes and will be ignored on any public request. The purpose of this header is  to help on Gateway to API calls identification.
    :param builtins.str x_one_origin_region: The Oracle Cloud Infrastructure home region name in case home region is not us-ashburn-1 (IAD), e.g. ap-mumbai-1, us-phoenix-1 etc.
    """
    __args__ = dict()
    __args__['commitmentId'] = commitment_id
    __args__['xOneGatewaySubscriptionId'] = x_one_gateway_subscription_id
    __args__['xOneOriginRegion'] = x_one_origin_region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsubSubscription/getCommitment:getCommitment', __args__, opts=opts, typ=GetCommitmentResult).value

    return AwaitableGetCommitmentResult(
        available_amount=pulumi.get(__ret__, 'available_amount'),
        commitment_id=pulumi.get(__ret__, 'commitment_id'),
        funded_allocation_value=pulumi.get(__ret__, 'funded_allocation_value'),
        id=pulumi.get(__ret__, 'id'),
        quantity=pulumi.get(__ret__, 'quantity'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'),
        used_amount=pulumi.get(__ret__, 'used_amount'),
        x_one_gateway_subscription_id=pulumi.get(__ret__, 'x_one_gateway_subscription_id'),
        x_one_origin_region=pulumi.get(__ret__, 'x_one_origin_region'))
def get_commitment_output(commitment_id: Optional[pulumi.Input[builtins.str]] = None,
                          x_one_gateway_subscription_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          x_one_origin_region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCommitmentResult]:
    """
    This data source provides details about a specific Commitment resource in Oracle Cloud Infrastructure Osub Subscription service.

    This API returns the commitment details corresponding to the id provided

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_commitment = oci.OsubSubscription.get_commitment(commitment_id=test_commitment_oci_osub_subscription_commitment["id"],
        x_one_gateway_subscription_id=commitment_x_one_gateway_subscription_id,
        x_one_origin_region=commitment_x_one_origin_region)
    ```


    :param builtins.str commitment_id: The Commitment Id
    :param builtins.str x_one_gateway_subscription_id: This header is meant to be used only for internal purposes and will be ignored on any public request. The purpose of this header is  to help on Gateway to API calls identification.
    :param builtins.str x_one_origin_region: The Oracle Cloud Infrastructure home region name in case home region is not us-ashburn-1 (IAD), e.g. ap-mumbai-1, us-phoenix-1 etc.
    """
    __args__ = dict()
    __args__['commitmentId'] = commitment_id
    __args__['xOneGatewaySubscriptionId'] = x_one_gateway_subscription_id
    __args__['xOneOriginRegion'] = x_one_origin_region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsubSubscription/getCommitment:getCommitment', __args__, opts=opts, typ=GetCommitmentResult)
    return __ret__.apply(lambda __response__: GetCommitmentResult(
        available_amount=pulumi.get(__response__, 'available_amount'),
        commitment_id=pulumi.get(__response__, 'commitment_id'),
        funded_allocation_value=pulumi.get(__response__, 'funded_allocation_value'),
        id=pulumi.get(__response__, 'id'),
        quantity=pulumi.get(__response__, 'quantity'),
        time_end=pulumi.get(__response__, 'time_end'),
        time_start=pulumi.get(__response__, 'time_start'),
        used_amount=pulumi.get(__response__, 'used_amount'),
        x_one_gateway_subscription_id=pulumi.get(__response__, 'x_one_gateway_subscription_id'),
        x_one_origin_region=pulumi.get(__response__, 'x_one_origin_region')))
