# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'RedisClusterNodeCollection',
    'RedisClusterNodeCollectionItem',
    'GetRedisClusterNodeCollectionResult',
    'GetRedisClusterNodeCollectionItemResult',
    'GetRedisClusterNodesFilterResult',
    'GetRedisClusterNodesRedisNodeCollectionResult',
    'GetRedisClusterNodesRedisNodeCollectionItemResult',
    'GetRedisClustersFilterResult',
    'GetRedisClustersRedisClusterCollectionResult',
    'GetRedisClustersRedisClusterCollectionItemResult',
    'GetRedisClustersRedisClusterCollectionItemNodeCollectionResult',
    'GetRedisClustersRedisClusterCollectionItemNodeCollectionItemResult',
]

@pulumi.output_type
class RedisClusterNodeCollection(dict):
    def __init__(__self__, *,
                 items: Optional[Sequence['outputs.RedisClusterNodeCollectionItem']] = None):
        """
        :param Sequence['RedisClusterNodeCollectionItemArgs'] items: Collection of node objects.
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.RedisClusterNodeCollectionItem']]:
        """
        Collection of node objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class RedisClusterNodeCollectionItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "privateEndpointFqdn":
            suggest = "private_endpoint_fqdn"
        elif key == "privateEndpointIpAddress":
            suggest = "private_endpoint_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RedisClusterNodeCollectionItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RedisClusterNodeCollectionItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RedisClusterNodeCollectionItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[builtins.str] = None,
                 private_endpoint_fqdn: Optional[builtins.str] = None,
                 private_endpoint_ip_address: Optional[builtins.str] = None):
        """
        :param builtins.str display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param builtins.str private_endpoint_fqdn: The fully qualified domain name (FQDN) of the API endpoint to access a specific node.
        :param builtins.str private_endpoint_ip_address: The private IP address of the API endpoint to access a specific node.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if private_endpoint_fqdn is not None:
            pulumi.set(__self__, "private_endpoint_fqdn", private_endpoint_fqdn)
        if private_endpoint_ip_address is not None:
            pulumi.set(__self__, "private_endpoint_ip_address", private_endpoint_ip_address)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="privateEndpointFqdn")
    def private_endpoint_fqdn(self) -> Optional[builtins.str]:
        """
        The fully qualified domain name (FQDN) of the API endpoint to access a specific node.
        """
        return pulumi.get(self, "private_endpoint_fqdn")

    @property
    @pulumi.getter(name="privateEndpointIpAddress")
    def private_endpoint_ip_address(self) -> Optional[builtins.str]:
        """
        The private IP address of the API endpoint to access a specific node.
        """
        return pulumi.get(self, "private_endpoint_ip_address")


@pulumi.output_type
class GetRedisClusterNodeCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRedisClusterNodeCollectionItemResult']):
        """
        :param Sequence['GetRedisClusterNodeCollectionItemArgs'] items: Collection of node objects.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRedisClusterNodeCollectionItemResult']:
        """
        Collection of node objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRedisClusterNodeCollectionItemResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 private_endpoint_fqdn: builtins.str,
                 private_endpoint_ip_address: builtins.str):
        """
        :param builtins.str display_name: A user-friendly name of a cluster node.
        :param builtins.str private_endpoint_fqdn: The fully qualified domain name (FQDN) of the API endpoint to access a specific node.
        :param builtins.str private_endpoint_ip_address: The private IP address of the API endpoint to access a specific node.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "private_endpoint_fqdn", private_endpoint_fqdn)
        pulumi.set(__self__, "private_endpoint_ip_address", private_endpoint_ip_address)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name of a cluster node.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="privateEndpointFqdn")
    def private_endpoint_fqdn(self) -> builtins.str:
        """
        The fully qualified domain name (FQDN) of the API endpoint to access a specific node.
        """
        return pulumi.get(self, "private_endpoint_fqdn")

    @property
    @pulumi.getter(name="privateEndpointIpAddress")
    def private_endpoint_ip_address(self) -> builtins.str:
        """
        The private IP address of the API endpoint to access a specific node.
        """
        return pulumi.get(self, "private_endpoint_ip_address")


@pulumi.output_type
class GetRedisClusterNodesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRedisClusterNodesRedisNodeCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRedisClusterNodesRedisNodeCollectionItemResult']):
        """
        :param Sequence['GetRedisClusterNodesRedisNodeCollectionItemArgs'] items: The list of nodes in a cluster.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRedisClusterNodesRedisNodeCollectionItemResult']:
        """
        The list of nodes in a cluster.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRedisClusterNodesRedisNodeCollectionItemResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 private_endpoint_fqdn: builtins.str,
                 private_endpoint_ip_address: builtins.str,
                 redis_cluster_id: builtins.str,
                 shard_number: builtins.int):
        """
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param builtins.str private_endpoint_fqdn: The fully qualified domain name (FQDN) of the API endpoint to access a specific node.
        :param builtins.str private_endpoint_ip_address: The private IP address of the API endpoint to access a specific node.
        :param builtins.str redis_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
        :param builtins.int shard_number: The shard number to which the node belongs to.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "private_endpoint_fqdn", private_endpoint_fqdn)
        pulumi.set(__self__, "private_endpoint_ip_address", private_endpoint_ip_address)
        pulumi.set(__self__, "redis_cluster_id", redis_cluster_id)
        pulumi.set(__self__, "shard_number", shard_number)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="privateEndpointFqdn")
    def private_endpoint_fqdn(self) -> builtins.str:
        """
        The fully qualified domain name (FQDN) of the API endpoint to access a specific node.
        """
        return pulumi.get(self, "private_endpoint_fqdn")

    @property
    @pulumi.getter(name="privateEndpointIpAddress")
    def private_endpoint_ip_address(self) -> builtins.str:
        """
        The private IP address of the API endpoint to access a specific node.
        """
        return pulumi.get(self, "private_endpoint_ip_address")

    @property
    @pulumi.getter(name="redisClusterId")
    def redis_cluster_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
        """
        return pulumi.get(self, "redis_cluster_id")

    @property
    @pulumi.getter(name="shardNumber")
    def shard_number(self) -> builtins.int:
        """
        The shard number to which the node belongs to.
        """
        return pulumi.get(self, "shard_number")


@pulumi.output_type
class GetRedisClustersFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRedisClustersRedisClusterCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRedisClustersRedisClusterCollectionItemResult']):
        """
        :param Sequence['GetRedisClustersRedisClusterCollectionItemArgs'] items: Collection of node objects.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRedisClustersRedisClusterCollectionItemResult']:
        """
        Collection of node objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRedisClustersRedisClusterCollectionItemResult(dict):
    def __init__(__self__, *,
                 cluster_mode: builtins.str,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 lifecycle_details: builtins.str,
                 node_collections: Sequence['outputs.GetRedisClustersRedisClusterCollectionItemNodeCollectionResult'],
                 node_count: builtins.int,
                 node_memory_in_gbs: builtins.float,
                 nsg_ids: Sequence[builtins.str],
                 primary_endpoint_ip_address: builtins.str,
                 primary_fqdn: builtins.str,
                 replicas_endpoint_ip_address: builtins.str,
                 replicas_fqdn: builtins.str,
                 shard_count: builtins.int,
                 software_version: builtins.str,
                 state: builtins.str,
                 subnet_id: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str cluster_mode: Specifies whether the cluster is sharded or non-sharded.
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, the message might provide actionable information for a resource in `FAILED` state.
        :param Sequence['GetRedisClustersRedisClusterCollectionItemNodeCollectionArgs'] node_collections: The collection of  cluster nodes.
        :param builtins.int node_count: The number of nodes per shard in the cluster when clusterMode is SHARDED. This is the total number of nodes when clusterMode is NONSHARDED.
        :param builtins.float node_memory_in_gbs: The amount of memory allocated to the cluster's nodes, in gigabytes.
        :param Sequence[builtins.str] nsg_ids: A list of Network Security Group (NSG) [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this cluster. For more information, see [Using an NSG for Clusters](https://docs.cloud.oracle.com/iaas/Content/ocicache/connecttocluster.htm#connecttocluster__networksecuritygroup).
        :param builtins.str primary_endpoint_ip_address: The private IP address of the API endpoint for the cluster's primary node.
        :param builtins.str primary_fqdn: The fully qualified domain name (FQDN) of the API endpoint for the cluster's primary node.
        :param builtins.str replicas_endpoint_ip_address: The private IP address of the API endpoint for the cluster's replica nodes.
        :param builtins.str replicas_fqdn: The fully qualified domain name (FQDN) of the API endpoint for the cluster's replica nodes.
        :param builtins.int shard_count: The number of shards in a sharded cluster. Only applicable when clusterMode is SHARDED.
        :param builtins.str software_version: The Oracle Cloud Infrastructure Cache engine version that the cluster is running.
        :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster's subnet.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The date and time the cluster was created. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        :param builtins.str time_updated: The date and time the cluster was updated. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        pulumi.set(__self__, "cluster_mode", cluster_mode)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "node_collections", node_collections)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_memory_in_gbs", node_memory_in_gbs)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "primary_endpoint_ip_address", primary_endpoint_ip_address)
        pulumi.set(__self__, "primary_fqdn", primary_fqdn)
        pulumi.set(__self__, "replicas_endpoint_ip_address", replicas_endpoint_ip_address)
        pulumi.set(__self__, "replicas_fqdn", replicas_fqdn)
        pulumi.set(__self__, "shard_count", shard_count)
        pulumi.set(__self__, "software_version", software_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="clusterMode")
    def cluster_mode(self) -> builtins.str:
        """
        Specifies whether the cluster is sharded or non-sharded.
        """
        return pulumi.get(self, "cluster_mode")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, the message might provide actionable information for a resource in `FAILED` state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nodeCollections")
    def node_collections(self) -> Sequence['outputs.GetRedisClustersRedisClusterCollectionItemNodeCollectionResult']:
        """
        The collection of  cluster nodes.
        """
        return pulumi.get(self, "node_collections")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> builtins.int:
        """
        The number of nodes per shard in the cluster when clusterMode is SHARDED. This is the total number of nodes when clusterMode is NONSHARDED.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeMemoryInGbs")
    def node_memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory allocated to the cluster's nodes, in gigabytes.
        """
        return pulumi.get(self, "node_memory_in_gbs")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        A list of Network Security Group (NSG) [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this cluster. For more information, see [Using an NSG for Clusters](https://docs.cloud.oracle.com/iaas/Content/ocicache/connecttocluster.htm#connecttocluster__networksecuritygroup).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="primaryEndpointIpAddress")
    def primary_endpoint_ip_address(self) -> builtins.str:
        """
        The private IP address of the API endpoint for the cluster's primary node.
        """
        return pulumi.get(self, "primary_endpoint_ip_address")

    @property
    @pulumi.getter(name="primaryFqdn")
    def primary_fqdn(self) -> builtins.str:
        """
        The fully qualified domain name (FQDN) of the API endpoint for the cluster's primary node.
        """
        return pulumi.get(self, "primary_fqdn")

    @property
    @pulumi.getter(name="replicasEndpointIpAddress")
    def replicas_endpoint_ip_address(self) -> builtins.str:
        """
        The private IP address of the API endpoint for the cluster's replica nodes.
        """
        return pulumi.get(self, "replicas_endpoint_ip_address")

    @property
    @pulumi.getter(name="replicasFqdn")
    def replicas_fqdn(self) -> builtins.str:
        """
        The fully qualified domain name (FQDN) of the API endpoint for the cluster's replica nodes.
        """
        return pulumi.get(self, "replicas_fqdn")

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> builtins.int:
        """
        The number of shards in a sharded cluster. Only applicable when clusterMode is SHARDED.
        """
        return pulumi.get(self, "shard_count")

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> builtins.str:
        """
        The Oracle Cloud Infrastructure Cache engine version that the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the cluster was created. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the cluster was updated. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetRedisClustersRedisClusterCollectionItemNodeCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRedisClustersRedisClusterCollectionItemNodeCollectionItemResult']):
        """
        :param Sequence['GetRedisClustersRedisClusterCollectionItemNodeCollectionItemArgs'] items: Collection of node objects.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRedisClustersRedisClusterCollectionItemNodeCollectionItemResult']:
        """
        Collection of node objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRedisClustersRedisClusterCollectionItemNodeCollectionItemResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 private_endpoint_fqdn: builtins.str,
                 private_endpoint_ip_address: builtins.str):
        """
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param builtins.str private_endpoint_fqdn: The fully qualified domain name (FQDN) of the API endpoint to access a specific node.
        :param builtins.str private_endpoint_ip_address: The private IP address of the API endpoint to access a specific node.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "private_endpoint_fqdn", private_endpoint_fqdn)
        pulumi.set(__self__, "private_endpoint_ip_address", private_endpoint_ip_address)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="privateEndpointFqdn")
    def private_endpoint_fqdn(self) -> builtins.str:
        """
        The fully qualified domain name (FQDN) of the API endpoint to access a specific node.
        """
        return pulumi.get(self, "private_endpoint_fqdn")

    @property
    @pulumi.getter(name="privateEndpointIpAddress")
    def private_endpoint_ip_address(self) -> builtins.str:
        """
        The private IP address of the API endpoint to access a specific node.
        """
        return pulumi.get(self, "private_endpoint_ip_address")


