# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetStreamsResult',
    'AwaitableGetStreamsResult',
    'get_streams',
    'get_streams_output',
]

@pulumi.output_type
class GetStreamsResult:
    """
    A collection of values returned by getStreams.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, state=None, stream_pool_id=None, streams=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stream_pool_id and not isinstance(stream_pool_id, str):
            raise TypeError("Expected argument 'stream_pool_id' to be a str")
        pulumi.set(__self__, "stream_pool_id", stream_pool_id)
        if streams and not isinstance(streams, list):
            raise TypeError("Expected argument 'streams' to be a list")
        pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The OCID of the compartment that contains the stream.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetStreamsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The OCID of the stream.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the stream. Avoid entering confidential information.  Example: `TelemetryEvents`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the stream.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamPoolId")
    def stream_pool_id(self) -> Optional[builtins.str]:
        """
        The OCID of the stream pool that contains the stream.
        """
        return pulumi.get(self, "stream_pool_id")

    @property
    @pulumi.getter
    def streams(self) -> Sequence['outputs.GetStreamsStreamResult']:
        """
        The list of streams.
        """
        return pulumi.get(self, "streams")


class AwaitableGetStreamsResult(GetStreamsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state,
            stream_pool_id=self.stream_pool_id,
            streams=self.streams)


def get_streams(compartment_id: Optional[builtins.str] = None,
                filters: Optional[Sequence[Union['GetStreamsFilterArgs', 'GetStreamsFilterArgsDict']]] = None,
                id: Optional[builtins.str] = None,
                name: Optional[builtins.str] = None,
                state: Optional[builtins.str] = None,
                stream_pool_id: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamsResult:
    """
    This data source provides the list of Streams in Oracle Cloud Infrastructure Streaming service.

    Lists the streams in the given compartment id.
    If the compartment id is specified, it will list streams in the compartment, regardless of their stream pool.
    If the stream pool id is specified, the action will be scoped to that stream pool.
    The compartment id and stream pool id cannot be specified at the same time.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_streams = oci.Streaming.get_streams(compartment_id=compartment_id,
        id=stream_id,
        name=stream_name,
        state=stream_state,
        stream_pool_id=test_stream_pool["id"])
    ```


    :param builtins.str compartment_id: The OCID of the compartment. Is exclusive with the `streamPoolId` parameter. One of them is required.
    :param builtins.str id: A filter to return only resources that match the given ID exactly.
    :param builtins.str name: A filter to return only resources that match the given name exactly.
    :param builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    :param builtins.str stream_pool_id: The OCID of the stream pool. Is exclusive with the `compartmentId` parameter. One of them is required.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    __args__['streamPoolId'] = stream_pool_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Streaming/getStreams:getStreams', __args__, opts=opts, typ=GetStreamsResult).value

    return AwaitableGetStreamsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        stream_pool_id=pulumi.get(__ret__, 'stream_pool_id'),
        streams=pulumi.get(__ret__, 'streams'))
def get_streams_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetStreamsFilterArgs', 'GetStreamsFilterArgsDict']]]]] = None,
                       id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       stream_pool_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamsResult]:
    """
    This data source provides the list of Streams in Oracle Cloud Infrastructure Streaming service.

    Lists the streams in the given compartment id.
    If the compartment id is specified, it will list streams in the compartment, regardless of their stream pool.
    If the stream pool id is specified, the action will be scoped to that stream pool.
    The compartment id and stream pool id cannot be specified at the same time.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_streams = oci.Streaming.get_streams(compartment_id=compartment_id,
        id=stream_id,
        name=stream_name,
        state=stream_state,
        stream_pool_id=test_stream_pool["id"])
    ```


    :param builtins.str compartment_id: The OCID of the compartment. Is exclusive with the `streamPoolId` parameter. One of them is required.
    :param builtins.str id: A filter to return only resources that match the given ID exactly.
    :param builtins.str name: A filter to return only resources that match the given name exactly.
    :param builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    :param builtins.str stream_pool_id: The OCID of the stream pool. Is exclusive with the `compartmentId` parameter. One of them is required.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    __args__['streamPoolId'] = stream_pool_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Streaming/getStreams:getStreams', __args__, opts=opts, typ=GetStreamsResult)
    return __ret__.apply(lambda __response__: GetStreamsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state'),
        stream_pool_id=pulumi.get(__response__, 'stream_pool_id'),
        streams=pulumi.get(__response__, 'streams')))
