# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRecipientInvitationsResult',
    'AwaitableGetRecipientInvitationsResult',
    'get_recipient_invitations',
    'get_recipient_invitations_output',
]

@pulumi.output_type
class GetRecipientInvitationsResult:
    """
    A collection of values returned by getRecipientInvitations.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, recipient_invitation_collections=None, sender_tenancy_id=None, state=None, status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if recipient_invitation_collections and not isinstance(recipient_invitation_collections, list):
            raise TypeError("Expected argument 'recipient_invitation_collections' to be a list")
        pulumi.set(__self__, "recipient_invitation_collections", recipient_invitation_collections)
        if sender_tenancy_id and not isinstance(sender_tenancy_id, str):
            raise TypeError("Expected argument 'sender_tenancy_id' to be a str")
        pulumi.set(__self__, "sender_tenancy_id", sender_tenancy_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        OCID of the recipient tenancy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRecipientInvitationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="recipientInvitationCollections")
    def recipient_invitation_collections(self) -> Sequence['outputs.GetRecipientInvitationsRecipientInvitationCollectionResult']:
        """
        The list of recipient_invitation_collection.
        """
        return pulumi.get(self, "recipient_invitation_collections")

    @property
    @pulumi.getter(name="senderTenancyId")
    def sender_tenancy_id(self) -> Optional[builtins.str]:
        """
        OCID of the sender tenancy.
        """
        return pulumi.get(self, "sender_tenancy_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Lifecycle state of the recipient invitation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Status of the recipient invitation.
        """
        return pulumi.get(self, "status")


class AwaitableGetRecipientInvitationsResult(GetRecipientInvitationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRecipientInvitationsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            recipient_invitation_collections=self.recipient_invitation_collections,
            sender_tenancy_id=self.sender_tenancy_id,
            state=self.state,
            status=self.status)


def get_recipient_invitations(compartment_id: Optional[builtins.str] = None,
                              filters: Optional[Sequence[Union['GetRecipientInvitationsFilterArgs', 'GetRecipientInvitationsFilterArgsDict']]] = None,
                              sender_tenancy_id: Optional[builtins.str] = None,
                              state: Optional[builtins.str] = None,
                              status: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRecipientInvitationsResult:
    """
    This data source provides the list of Recipient Invitations in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Return a (paginated) list of recipient invitations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_recipient_invitations = oci.Tenantmanagercontrolplane.get_recipient_invitations(compartment_id=compartment_id,
        sender_tenancy_id=test_tenancy["id"],
        state=recipient_invitation_state,
        status=recipient_invitation_status)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str sender_tenancy_id: The tenancy that sent the invitation.
    :param builtins.str state: The lifecycle state of the resource.
    :param builtins.str status: The status of the recipient invitation.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['senderTenancyId'] = sender_tenancy_id
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Tenantmanagercontrolplane/getRecipientInvitations:getRecipientInvitations', __args__, opts=opts, typ=GetRecipientInvitationsResult).value

    return AwaitableGetRecipientInvitationsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        recipient_invitation_collections=pulumi.get(__ret__, 'recipient_invitation_collections'),
        sender_tenancy_id=pulumi.get(__ret__, 'sender_tenancy_id'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'))
def get_recipient_invitations_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRecipientInvitationsFilterArgs', 'GetRecipientInvitationsFilterArgsDict']]]]] = None,
                                     sender_tenancy_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRecipientInvitationsResult]:
    """
    This data source provides the list of Recipient Invitations in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Return a (paginated) list of recipient invitations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_recipient_invitations = oci.Tenantmanagercontrolplane.get_recipient_invitations(compartment_id=compartment_id,
        sender_tenancy_id=test_tenancy["id"],
        state=recipient_invitation_state,
        status=recipient_invitation_status)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str sender_tenancy_id: The tenancy that sent the invitation.
    :param builtins.str state: The lifecycle state of the resource.
    :param builtins.str status: The status of the recipient invitation.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['senderTenancyId'] = sender_tenancy_id
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Tenantmanagercontrolplane/getRecipientInvitations:getRecipientInvitations', __args__, opts=opts, typ=GetRecipientInvitationsResult)
    return __ret__.apply(lambda __response__: GetRecipientInvitationsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        recipient_invitation_collections=pulumi.get(__response__, 'recipient_invitation_collections'),
        sender_tenancy_id=pulumi.get(__response__, 'sender_tenancy_id'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status')))
