"""
    SatNOGS DB

    SatNOGS DB is a crowdsourced database of details about orbital                     satellites and data collected from them.  # noqa: E501

    The version of the OpenAPI document: 1.1
    Contact: dev@satnogs.org
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from satnogsdbapiclient.api_client import ApiClient, Endpoint as _Endpoint
from satnogsdbapiclient.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from satnogsdbapiclient.model.transmitter import Transmitter


class TransmittersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __transmitters_list(
            self,
            **kwargs
        ):
            """transmitters_list  # noqa: E501

            Read-only view into the Transmitter entities in the SatNOGS DB database. Transmitters are inclusive of Transceivers and Transponders  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transmitters_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                alive (bool): Alive. [optional]
                format (str): [optional]
                mode (int, none_type): Modulation mode for the downlink. [optional]
                satellite__norad_cat_id (str): NORAD ID of a satellite to filter telemetry data for. [optional]
                service (str): Filter by transmitter service: Aeronautical Amateur Broadcasting Earth Exploration Fixed Inter-satellite Maritime Meteorological Mobile Radiolocation Radionavigational Space Operation Space Research Standard Frequency and Time Signal Unknown. [optional]
                status (str): Filter by transmitter status: active inactive invalid. [optional]
                type (str): Filter by transmitter type: Transmitter Transceiver Transponder. [optional]
                uplink_mode (int, none_type): Modulation mode for the uplink. [optional]
                uuid (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [Transmitter]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.transmitters_list = _Endpoint(
            settings={
                'response_type': ([Transmitter],),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/transmitters/',
                'operation_id': 'transmitters_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'alive',
                    'format',
                    'mode',
                    'satellite__norad_cat_id',
                    'service',
                    'status',
                    'type',
                    'uplink_mode',
                    'uuid',
                ],
                'required': [],
                'nullable': [
                    'mode',
                    'uplink_mode',
                ],
                'enum': [
                    'format',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('format',): {

                        "BROWSE-JSON-LD": "browse-json-ld",
                        "JSON": "json",
                        "JSON-LD": "json-ld"
                    },
                },
                'openapi_types': {
                    'alive':
                        (bool,),
                    'format':
                        (str,),
                    'mode':
                        (int, none_type,),
                    'satellite__norad_cat_id':
                        (str,),
                    'service':
                        (str,),
                    'status':
                        (str,),
                    'type':
                        (str,),
                    'uplink_mode':
                        (int, none_type,),
                    'uuid':
                        (str,),
                },
                'attribute_map': {
                    'alive': 'alive',
                    'format': 'format',
                    'mode': 'mode',
                    'satellite__norad_cat_id': 'satellite__norad_cat_id',
                    'service': 'service',
                    'status': 'status',
                    'type': 'type',
                    'uplink_mode': 'uplink_mode',
                    'uuid': 'uuid',
                },
                'location_map': {
                    'alive': 'query',
                    'format': 'query',
                    'mode': 'query',
                    'satellite__norad_cat_id': 'query',
                    'service': 'query',
                    'status': 'query',
                    'type': 'query',
                    'uplink_mode': 'query',
                    'uuid': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json',
                    'text/html'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__transmitters_list
        )

        def __transmitters_retrieve(
            self,
            uuid,
            **kwargs
        ):
            """transmitters_retrieve  # noqa: E501

            Read-only view into the Transmitter entities in the SatNOGS DB database. Transmitters are inclusive of Transceivers and Transponders  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transmitters_retrieve(uuid, async_req=True)
            >>> result = thread.get()

            Args:
                uuid (str):

            Keyword Args:
                format (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Transmitter
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['uuid'] = \
                uuid
            return self.call_with_http_info(**kwargs)

        self.transmitters_retrieve = _Endpoint(
            settings={
                'response_type': (Transmitter,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/transmitters/{uuid}/',
                'operation_id': 'transmitters_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'uuid',
                    'format',
                ],
                'required': [
                    'uuid',
                ],
                'nullable': [
                ],
                'enum': [
                    'format',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('format',): {

                        "BROWSE-JSON-LD": "browse-json-ld",
                        "JSON": "json",
                        "JSON-LD": "json-ld"
                    },
                },
                'openapi_types': {
                    'uuid':
                        (str,),
                    'format':
                        (str,),
                },
                'attribute_map': {
                    'uuid': 'uuid',
                    'format': 'format',
                },
                'location_map': {
                    'uuid': 'path',
                    'format': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json',
                    'text/html'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__transmitters_retrieve
        )
