/*
 * Decompiled with CFR 0.152.
 */
package org.codegen.generators;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.codegen.generators.AbstractCodeGenerator;
import org.codegen.generators.AllGeneratorsEnum;
import org.codegen.generators.KtDataclassGenerator;
import org.codegen.schema.Entity;
import org.codegen.schema.Field;
import org.codegen.utils.EnvironmentUtils;
import org.codegen.utils.StringKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0014J\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0016H\u0016J)\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u001b\"\u00020\bH\u0014\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/codegen/generators/KtDataclassSerializableGenerator;", "Lorg/codegen/generators/KtDataclassGenerator;", "proxy", "Lorg/codegen/generators/AbstractCodeGenerator;", "<init>", "(Lorg/codegen/generators/AbstractCodeGenerator;)V", "builtinSerializableTypes", "", "", "useJackson", "", "useKotlinX", "getSerialName", "field", "Lorg/codegen/schema/Field;", "buildFieldDefinition", "buildEnumItem", "key", "buildEntity", "entity", "Lorg/codegen/schema/Entity;", "annotations", "", "addCodePart", "", "body", "names", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "ez-codegen"})
public final class KtDataclassSerializableGenerator
extends KtDataclassGenerator {
    @NotNull
    private final List<String> builtinSerializableTypes;
    private final boolean useJackson;
    private final boolean useKotlinX;

    public KtDataclassSerializableGenerator(@Nullable AbstractCodeGenerator proxy) {
        super(AllGeneratorsEnum.KT_SERIALIZABLE_DATACLASS, proxy);
        Object[] objectArray = new String[]{"String", "Int", "Float", "Double", "Boolean"};
        this.builtinSerializableTypes = CollectionsKt.listOf((Object[])objectArray);
        this.useJackson = EnvironmentUtils.Companion.getEnvFlag("USE_JACKSON");
        this.useKotlinX = true;
    }

    public /* synthetic */ KtDataclassSerializableGenerator(AbstractCodeGenerator abstractCodeGenerator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            abstractCodeGenerator = null;
        }
        this(abstractCodeGenerator);
    }

    private final String getSerialName(Field field) {
        String string = field.getSerializedName();
        if (string == null) {
            string = StringKt.snakeCase(field.getName());
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildFieldDefinition(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Object definition = super.buildFieldDefinition(field);
        String serialName = this.getSerialName(field);
        if (!Intrinsics.areEqual((Object)serialName, (Object)StringKt.lowercaseFirst(StringKt.camelCase(field.getName())))) {
            if (this.useKotlinX) {
                this.getHeaders().add("import kotlinx.serialization.SerialName");
                definition = "@SerialName(\"" + serialName + "\")\n" + (String)definition;
            }
            if (this.useJackson) {
                this.getHeaders().add("import com.fasterxml.jackson.annotation.JsonProperty");
                definition = "@JsonProperty(\"" + serialName + "\")\n" + (String)definition;
            }
        }
        if (this.useKotlinX && !this.builtinSerializableTypes.contains(this.getDtype(field.getDtype()).getDefinition())) {
            this.getHeaders().add("import kotlinx.serialization.Contextual");
            definition = field.getMany() ? StringsKt.replace$default((String)definition, (String)"List<", (String)"List<@Contextual ", (boolean)false, (int)4, null) : "@Contextual\n" + (String)definition;
        }
        return definition;
    }

    @Override
    @NotNull
    protected String buildEnumItem(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String it = super.buildEnumItem(key);
        boolean bl = false;
        if (Intrinsics.areEqual((Object)this.buildEnumLiteral(key), (Object)key)) {
            string = it;
        } else {
            Object annotated = it;
            if (this.useKotlinX) {
                this.getHeaders().add("import kotlinx.serialization.SerialName");
                annotated = "@SerialName(\"" + key + "\")\n" + it;
            }
            string = annotated;
        }
        return string;
    }

    @Override
    @NotNull
    public String buildEntity(@NotNull Entity entity, @NotNull Set<String> annotations) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Set updatedAnnotations = CollectionsKt.toMutableSet((Iterable)annotations);
        if (this.useKotlinX) {
            this.getHeaders().add("import kotlinx.serialization.Serializable");
            updatedAnnotations.add("@Serializable");
        }
        return super.buildEntity(entity, updatedAnnotations);
    }

    @Override
    protected void addCodePart(@NotNull String body, String ... names) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        if (StringsKt.contains$default((CharSequence)body, (CharSequence)"enum class", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)body, (CharSequence)"@SerialName", (boolean)false, (int)2, null) && this.useKotlinX && !StringsKt.contains$default((CharSequence)body, (CharSequence)"@Serializable", (boolean)false, (int)2, null)) {
            this.getHeaders().add("import kotlinx.serialization.Serializable");
            super.addCodePart("@Serializable\n" + body, Arrays.copyOf(names, names.length));
        } else {
            super.addCodePart(body, Arrays.copyOf(names, names.length));
        }
    }

    public KtDataclassSerializableGenerator() {
        this(null, 1, null);
    }
}

