/*
 * Decompiled with CFR 0.152.
 */
package org.codegen.parser;

import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import org.codegen.parser.AbstractParser;
import org.codegen.parser.OpenApiJsonParser;
import org.codegen.parser.OpenApiYamlParser;
import org.codegen.parser.SchemaJsonParser;
import org.codegen.schema.Document;
import org.codegen.utils.Reader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/codegen/parser/ParserRegistry;", "", "<init>", "()V", "parsers", "", "Lorg/codegen/parser/AbstractParser;", "parseFileOrResourceOrUrl", "Lorg/codegen/schema/Document;", "pathOrUrl", "", "parseContent", "content", "ez-codegen"})
@SourceDebugExtension(value={"SMAP\nParserRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParserRegistry.kt\norg/codegen/parser/ParserRegistry\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,43:1\n216#2,2:44\n*S KotlinDebug\n*F\n+ 1 ParserRegistry.kt\norg/codegen/parser/ParserRegistry\n*L\n39#1:44,2\n*E\n"})
public final class ParserRegistry {
    @NotNull
    public static final ParserRegistry INSTANCE = new ParserRegistry();
    @NotNull
    private static final List<AbstractParser> parsers;

    private ParserRegistry() {
    }

    @NotNull
    public final Document parseFileOrResourceOrUrl(@NotNull String pathOrUrl) {
        Intrinsics.checkNotNullParameter((Object)pathOrUrl, (String)"pathOrUrl");
        try {
            return this.parseContent(Reader.readFileOrResourceOrUrl$default(Reader.INSTANCE, pathOrUrl, null, 2, null));
        }
        catch (ParseException e) {
            throw new ParseException("Failed to parse '" + pathOrUrl + "'.\n" + e.getMessage(), e.getErrorOffset());
        }
    }

    private final Document parseContent(String content) {
        Map exceptions = new LinkedHashMap();
        for (AbstractParser parser : parsers) {
            try {
                return parser.parse(content);
            }
            catch (SerializationException e) {
                exceptions.put(parser.getClass().getName(), e);
            }
        }
        String parserNames = CollectionsKt.joinToString$default((Iterable)exceptions.keySet(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        StringJoiner errorText = new StringJoiner("\n");
        errorText.add("Parsers tried: " + parserNames + ". Corresponding exceptions below:");
        Map $this$forEach$iv = exceptions;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            Exception exception = (Exception)entry.getValue();
            errorText.add(name + ": " + exception);
        }
        throw new ParseException(errorText.toString(), 0);
    }

    static {
        Object[] objectArray = new AbstractParser[]{new SchemaJsonParser(), new OpenApiJsonParser(), new OpenApiYamlParser()};
        parsers = CollectionsKt.listOf((Object[])objectArray);
    }
}

