# Generated by Django 2.0.4 on 2018-04-26 23:54

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('calaccess_processed_filings', '0006_auto_20180426_1733'),
    ]

    operations = [
        migrations.CreateModel(
            name='Form461Filing',
            fields=[
                ('date_filed', models.DateField(db_index=True, help_text='Date this report was filed, according to the filer (from CVR_CAMPAIGN_DISCLOSURE.RPT_DATE)', verbose_name='date filed')),
                ('filer_id', models.IntegerField(db_index=True, help_text='Numeric filer identification number (from FILER_XREF.FILER_ID)', verbose_name='filer id')),
                ('filer_lastname', models.CharField(help_text='Last name of filer (from CVR_CAMPAIGN_DISCLOSURE.FILER_NAML)', max_length=200, verbose_name='filer last name')),
                ('filer_firstname', models.CharField(blank=True, help_text='First name of the filer (from CVR_CAMPAIGN_DISCLOSURE.FILER_NAMF)', max_length=45, verbose_name='filer first name')),
                ('election_date', models.DateField(db_index=True, help_text='Date of the election in which the filer is participating (from CVR_CAMPAIGN_DISCLOSURE.ELECT_DATE)', null=True, verbose_name='election date')),
                ('filing_id', models.IntegerField(help_text='Unique identification number for the Form 461 filing (from CVR_CAMPAIGN_DISCLOSURE_CD.FILING_ID)', primary_key=True, serialize=False, verbose_name='filing id')),
                ('amendment_count', models.IntegerField(db_index=True, help_text='Number of amendments to the Form 461 filing (from maximum value of CVR_CAMPAIGN_DISCLOSURE_CD.AMEND_ID)', verbose_name='Count amendments')),
            ],
            options={
                'verbose_name': 'Form 461 (Campaign Disclosure) filing',
            },
        ),
        migrations.CreateModel(
            name='Form461FilingVersion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_filed', models.DateField(db_index=True, help_text='Date this report was filed, according to the filer (from CVR_CAMPAIGN_DISCLOSURE.RPT_DATE)', verbose_name='date filed')),
                ('filer_id', models.IntegerField(db_index=True, help_text='Numeric filer identification number (from FILER_XREF.FILER_ID)', verbose_name='filer id')),
                ('filer_lastname', models.CharField(help_text='Last name of filer (from CVR_CAMPAIGN_DISCLOSURE.FILER_NAML)', max_length=200, verbose_name='filer last name')),
                ('filer_firstname', models.CharField(blank=True, help_text='First name of the filer (from CVR_CAMPAIGN_DISCLOSURE.FILER_NAMF)', max_length=45, verbose_name='filer first name')),
                ('election_date', models.DateField(db_index=True, help_text='Date of the election in which the filer is participating (from CVR_CAMPAIGN_DISCLOSURE.ELECT_DATE)', null=True, verbose_name='election date')),
                ('statement_type', models.CharField(help_text='Type of statement, e.g., "Quarterly", "Semi-Annual", Pre-Election (from CVR_CAMPAIGN_DISCLOSURE.STMT_TYPE)', max_length=50, verbose_name='statement type')),
                ('from_date', models.DateField(db_index=True, help_text='The first date of the filing period covered by the statement (from CVR_CAMPAIGN_DISCLOSURE.FROM_DATE)', verbose_name='from date')),
                ('thru_date', models.DateField(db_index=True, help_text='The last date of the filing period covered by the statement (from CVR_CAMPAIGN_DISCLOSURE.THRU_DATE)', verbose_name='thru date')),
                ('amend_id', models.IntegerField(help_text='Identifies the version of the Form 461 filing, with 0 representing the initial filing (from CVR_CAMPAIGN_DISCLOSURE_CD.AMEND_ID)', verbose_name='amendment id')),
                ('filing', models.ForeignKey(db_constraint=False, help_text='Unique identification number for the Form 461 filing (from CVR_CAMPAIGN_DISCLOSURE_CD.FILING_ID)', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='versions', to='calaccess_processed_filings.Form461Filing')),
            ],
            options={
                'verbose_name': 'Form 461 (Campaign Disclosure) filing version',
            },
        ),
        migrations.AlterField(
            model_name='form460filingversion',
            name='amend_id',
            field=models.IntegerField(help_text='Identifies the version of the Form 460 filing, with 0 representing the initial filing (from CVR_CAMPAIGN_DISCLOSURE_CD.AMEND_ID)', verbose_name='amendment id'),
        ),
        migrations.AlterIndexTogether(
            name='form461filing',
            index_together={('filing_id', 'amendment_count')},
        ),
        migrations.AlterUniqueTogether(
            name='form461filingversion',
            unique_together={('filing', 'amend_id')},
        ),
        migrations.AlterIndexTogether(
            name='form461filingversion',
            index_together={('filing', 'amend_id')},
        ),
    ]
