# coding: utf-8

"""
    perceptic-core-server API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.0.1-SNAPSHOT
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from perceptic_core_client.models.image_detection_box_api_dto import ImageDetectionBoxApiDto
from typing import Optional, Set
from typing_extensions import Self

class BiotechAnalysisApiDto(BaseModel):
    """
    BiotechAnalysisApiDto
    """ # noqa: E501
    raw_analysis: Optional[StrictStr] = Field(default=None, alias="rawAnalysis")
    compound_data_present: Optional[StrictBool] = Field(default=None, alias="compoundDataPresent")
    compounds: Optional[List[StrictStr]] = None
    development_stage: Optional[StrictStr] = Field(default=None, alias="developmentStage")
    therapeutic_area: Optional[StrictStr] = Field(default=None, alias="therapeuticArea")
    key_findings: Optional[List[StrictStr]] = Field(default=None, alias="keyFindings")
    risks: Optional[List[StrictStr]] = None
    market_potential: Optional[StrictStr] = Field(default=None, alias="marketPotential")
    confidence: Optional[Union[StrictFloat, StrictInt]] = None
    reasoning: Optional[StrictStr] = None
    bounding_boxes: Optional[List[ImageDetectionBoxApiDto]] = Field(default=None, alias="boundingBoxes")
    page_index: Optional[StrictInt] = Field(default=None, alias="pageIndex")
    character_count: Optional[StrictInt] = Field(default=None, alias="characterCount")
    __properties: ClassVar[List[str]] = ["rawAnalysis", "compoundDataPresent", "compounds", "developmentStage", "therapeuticArea", "keyFindings", "risks", "marketPotential", "confidence", "reasoning", "boundingBoxes", "pageIndex", "characterCount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BiotechAnalysisApiDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in bounding_boxes (list)
        _items = []
        if self.bounding_boxes:
            for _item_bounding_boxes in self.bounding_boxes:
                if _item_bounding_boxes:
                    _items.append(_item_bounding_boxes.to_dict())
            _dict['boundingBoxes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BiotechAnalysisApiDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "rawAnalysis": obj.get("rawAnalysis"),
            "compoundDataPresent": obj.get("compoundDataPresent"),
            "compounds": obj.get("compounds"),
            "developmentStage": obj.get("developmentStage"),
            "therapeuticArea": obj.get("therapeuticArea"),
            "keyFindings": obj.get("keyFindings"),
            "risks": obj.get("risks"),
            "marketPotential": obj.get("marketPotential"),
            "confidence": obj.get("confidence"),
            "reasoning": obj.get("reasoning"),
            "boundingBoxes": [ImageDetectionBoxApiDto.from_dict(_item) for _item in obj["boundingBoxes"]] if obj.get("boundingBoxes") is not None else None,
            "pageIndex": obj.get("pageIndex"),
            "characterCount": obj.get("characterCount")
        })
        return _obj


