# Breaking Changes: node 10.0 → 11.0
> Generated on: 2025-04-09T01:08:56.498406
> Stack: node
> Current Version: 10.0
> Upgrade Version: 11.0

# Node.js Upgrade Guide: From v10.0 to v11.0

This document provides a comprehensive overview of all breaking changes, deprecations, and API modifications introduced when upgrading from Node.js v10.0 to v11.0. It is structured to help developers understand the changes, their impact, and how to migrate their code.

---

## 1. Summary of Major Changes

Node.js v11.0 introduced several breaking changes, focusing on improving performance, modernizing APIs, and removing deprecated features. Key updates include:
- Changes to the default behavior of certain APIs (e.g., `child_process` and `http` modules).
- Deprecation and removal of legacy APIs.
- Updates to dependencies like V8 and libuv.
- Introduction of stricter validation for URLs and other inputs.

---

## 2. Breaking Changes by Version

### **Node.js v11.0.0**
Below are the breaking changes introduced in Node.js v11.0.0:

#### **2.1. `child_process` Module**
- **Change**: The default value of the `windowsHide` option in `child_process.spawn()` and related methods was changed to `true`[5].
- **Reason**: This change improves security by hiding the console window when spawning child processes on Windows.
- **Migration**:
  - If your application relies on the console window being visible, explicitly set `windowsHide: false`.
  - **Before**:
    ```javascript
    const { spawn } = require('child_process');
    spawn('cmd.exe', ['/c', 'echo', 'Hello']);
    ```
  - **After**:
    ```javascript
    const { spawn } = require('child_process');
    spawn('cmd.exe', ['/c', 'echo', 'Hello'], { windowsHide: false });
    ```

#### **2.2. `http`, `https`, and `tls` Modules**
- **Change**: These modules now use the WHATWG URL parser by default instead of the legacy `url.parse()` API[5].
- **Reason**: The WHATWG URL parser is more standards-compliant and consistent.
- **Migration**:
  - Update code to use the WHATWG URL parser if relying on the legacy behavior.
  - **Before**:
    ```javascript
    const http = require('http');
    const options = url.parse('http://example.com');
    http.get(options, (res) => console.log(res.statusCode));
    ```
  - **After**:
    ```javascript
    const http = require('http');
    const options = new URL('http://example.com');
    http.get(options, (res) => console.log(res.statusCode));
    ```

#### **2.3. `process.binding()`**
- **Change**: Use of `process.binding()` is deprecated[5].
- **Reason**: This is an internal API not intended for public use.
- **Migration**:
  - Replace `process.binding()` calls with supported public APIs. If no alternative exists, consider opening an issue in the Node.js GitHub repository.

#### **2.4. FreeBSD 10 Support**
- **Change**: FreeBSD 10 is no longer supported[5].
- **Reason**: FreeBSD 10 reached its end-of-life.
- **Migration**:
  - Upgrade to a supported version of FreeBSD if running Node.js on this platform.

#### **2.5. V8 JavaScript Engine Update**
- **Change**: Node.js v11.0 includes V8 7.0[5].
- **Reason**: This update brings performance improvements and new JavaScript features.
- **Migration**:
  - Test your application for compatibility with the new V8 version, especially if using native addons or relying on specific JavaScript engine behavior.

---

## 3. Deprecations and Removed Features

### **3.1. Deprecated APIs**
- **`process.binding()`**: Deprecated as it is an internal API[5].
- **Legacy URL Parsing**: The legacy `url.parse()` API is deprecated in favor of the WHATWG URL parser[5].

### **3.2. Removed Features**
- **`Domain.dispose()`**: Removed in favor of explicit error handling via event listeners[3].
- **`GLOBAL` and `root` Aliases**: Removed; use `global` instead[3].
- **`Intl.v8BreakIterator`**: Removed as it was a non-standard extension[3].
- **Windows Performance Counter Support**: Removed due to lack of usage[3].

---

## 4. Migration Guide

### **General Recommendations**
1. **Test Thoroughly**: Run your application and its dependencies in a staging environment with Node.js v11.0 to identify issues.
2. **Update Dependencies**: Ensure all third-party modules are compatible with Node.js v11.0.
3. **Use Linting Tools**: Tools like `eslint` can help identify deprecated or removed APIs in your codebase.

### **Code Examples**

#### **Updating `url.parse()` to WHATWG URL**
- **Before**:
  ```javascript
  const url = require('url');
  const parsed = url.parse('http://example.com');
  console.log(parsed.hostname);
  ```
- **After**:
  ```javascript
  const { URL } = require('url');
  const parsed = new URL('http://example.com');
  console.log(parsed.hostname);
  ```

#### **Replacing `Domain.dispose()`**
- **Before**:
  ```javascript
  const domain = require('domain');
  const d = domain.create();
  d.dispose();
  ```
- **After**:
  ```javascript
  const domain = require('domain');
  const d = domain.create();
  d.on('error', (err) => console.error(err));
  ```

---

This guide covers all known breaking changes and deprecations from Node.js v10.0 to v11.0. For further details, refer to the official Node.js changelogs and documentation.