# Breaking Changes: node 12.0 → 13.0
> Generated on: 2025-04-09T01:10:07.967450
> Stack: node
> Current Version: 12.0
> Upgrade Version: 13.0

## Node.js Upgrade Guide: From Version 12.0 to 13.0

This document provides a comprehensive overview of all breaking changes, deprecations, and API modifications introduced when upgrading from Node.js 12.0 to 13.0. It is structured to help developers understand the changes and migrate their code effectively.

---

### 1. Summary of Major Changes

Node.js 13.0 introduced several breaking changes, deprecations, and updates to APIs. Key highlights include:
- Removal of deprecated APIs and features.
- Changes to default behaviors in core modules.
- Updates to experimental features and their APIs.
- Performance improvements and internal refactoring.

---

### 2. Breaking Changes by Version

#### **Node.js 13.0.0**
The following breaking changes were introduced in Node.js 13.0.0:

1. **V8 Engine Update**
   - **What Changed**: Node.js 13.0 shipped with V8 version 7.8, which introduced new JavaScript features and optimizations. Some older V8-specific behaviors were removed.
   - **Impact**: Code relying on deprecated V8 features may break.
   - **Migration**: Test your code with the new V8 engine and update any deprecated syntax.

2. **HTTP and HTTP/2**
   - **What Changed**: The `http` and `http2` modules received updates to improve compliance with standards and performance.
   - **Impact**: Some undocumented behaviors were removed, and stricter validation was introduced.
   - **Migration**: Ensure your HTTP/2 server and client implementations conform to the updated API.

3. **Streams**
   - **What Changed**: The `stream` module introduced stricter checks and improved error handling.
   - **Impact**: Code relying on undocumented or incorrect stream behaviors may fail.
   - **Migration**: Refactor stream-related code to handle errors explicitly and conform to the updated API.

4. **Deprecation of `process.binding()`**
   - **What Changed**: The use of `process.binding()` for accessing internal modules was deprecated.
   - **Impact**: Direct access to internal modules is no longer supported.
   - **Migration**: Use public APIs or alternative modules.

5. **REPL Enhancements**
   - **What Changed**: The REPL now supports top-level `await` and improved autocompletion.
   - **Impact**: Scripts relying on older REPL behaviors may need adjustments.
   - **Migration**: Update REPL scripts to leverage new features.

6. **Worker Threads**
   - **What Changed**: Worker threads were stabilized, and some experimental APIs were removed.
   - **Impact**: Code using experimental worker APIs may break.
   - **Migration**: Use the stable worker thread APIs.

---

### 3. Detailed Breaking Changes

#### **API: `process.binding()`**
- **What Changed**: Access to internal modules via `process.binding()` was deprecated.
- **Why**: To discourage reliance on internal, undocumented APIs.
- **Migration**: Replace `process.binding()` calls with equivalent public APIs or third-party modules.
- **Example**:
  ```javascript
  // Before
  const fs = process.binding('fs');

  // After
  const fs = require('fs');
  ```

#### **HTTP/2: Header Validation**
- **What Changed**: Stricter validation of HTTP/2 headers.
- **Why**: To improve compliance with the HTTP/2 specification.
- **Migration**: Ensure all headers conform to the HTTP/2 standard.
- **Example**:
  ```javascript
  // Before
  const headers = { ':status': '200' }; // Invalid

  // After
  const headers = { ':status': 200 }; // Valid
  ```

#### **Streams: Error Handling**
- **What Changed**: Streams now emit errors more consistently.
- **Why**: To improve reliability and debugging.
- **Migration**: Add explicit error handling to all stream operations.
- **Example**:
  ```javascript
  // Before
  stream.on('data', (chunk) => { /* ... */ });

  // After
  stream.on('data', (chunk) => { /* ... */ });
  stream.on('error', (err) => { console.error(err); });
  ```

#### **REPL: Top-Level `await`**
- **What Changed**: The REPL now supports top-level `await`.
- **Why**: To align with modern JavaScript features.
- **Migration**: Update REPL scripts to use `await` directly.
- **Example**:
  ```javascript
  // Before
  (async () => {
    const result = await someAsyncFunction();
    console.log(result);
  })();

  // After
  const result = await someAsyncFunction();
  console.log(result);
  ```

#### **Worker Threads: Stabilization**
- **What Changed**: Experimental worker thread APIs were removed.
- **Why**: To provide a stable and consistent API.
- **Migration**: Use the stable worker thread APIs.
- **Example**:
  ```javascript
  // Before
  const { Worker } = require('worker_threads');
  const worker = new Worker('console.log("Hello, world!")', { eval: true });

  // After
  const { Worker } = require('worker_threads');
  const worker = new Worker('./worker.js');
  ```

---

### 4. Deprecations

1. **`process.assert()`**
   - **What Changed**: Deprecated in favor of the `assert` module.
   - **Migration**: Replace `process.assert()` with `require('assert')`.

2. **`async_hooks.AsyncResource.triggerId()`**
   - **What Changed**: Renamed to `triggerAsyncId()` for clarity.
   - **Migration**: Update all references to use `triggerAsyncId()`.

3. **`dns.lookup()` with Falsy Hostnames**
   - **What Changed**: Passing falsy hostnames to `dns.lookup()` is deprecated.
   - **Migration**: Ensure all hostnames are valid strings.

---

### 5. Migration Tips

- **Testing**: Run your application with Node.js 13.0 in a staging environment to identify issues.
- **Dependencies**: Update all dependencies to their latest versions to ensure compatibility.
- **Linting**: Use tools like ESLint to identify deprecated or incompatible code.
- **Documentation**: Refer to the official Node.js documentation for detailed API changes.

---

This guide provides a thorough overview of the changes introduced in Node.js 13.0. By following the migration steps and examples, you can ensure a smooth transition for your application.