# Breaking Changes: node 14.0 → 15.0
> Generated on: 2025-04-09T01:10:53.891697
> Stack: node
> Current Version: 14.0
> Upgrade Version: 15.0

## Node.js 14 to Node.js 15 Upgrade: Breaking Changes, Deprecations, and API Modifications

### 1. Summary of Major Changes
Node.js 15 introduced several breaking changes, deprecations, and new features. Key highlights include:
- **Unhandled Promise Rejections**: Default behavior changed from `warn` to `throw`.
- **npm 7**: Introduced with breaking changes like peer dependencies installation by default.
- **V8 Engine Update**: Upgraded to V8 8.6, adding new JavaScript features.
- **Removal of Deprecated APIs**: Certain legacy APIs were removed.
- **Experimental Features**: Added support for QUIC protocol and diagnostics_channel module.

### 2. Breaking Changes by Version

#### **Node.js 15.0.0**
1. **Unhandled Promise Rejections**
   - **What Changed**: The default mode for `unhandledRejection` changed from `warn` to `throw`. Unhandled rejections now terminate the application unless explicitly handled.
   - **Why**: To encourage better error handling practices and avoid unpredictable application states.
   - **Migration**:
     - Add a global handler for unhandled rejections:
       ```javascript
       process.on('unhandledRejection', (reason, promise) => {
         console.error('Unhandled Rejection:', reason);
       });
       ```
     - Alternatively, use the `--unhandled-rejections=warn` flag to retain the old behavior.

2. **npm 7**
   - **What Changed**:
     - Peer dependencies are now installed by default.
     - `npx` behavior changed; it now prompts interactively for missing packages.
     - Internal npm modules can no longer be imported.
     - `npm audit` output format updated.
   - **Why**: To align with modern package management practices and improve developer experience.
   - **Migration**:
     - Review peer dependencies in your `package.json`.
     - Update scripts relying on `npx` to handle interactive prompts or use `npm exec`.

3. **V8 Engine Update**
   - **What Changed**: Upgraded from V8 8.4 to 8.6, introducing:
     - `Promise.any()`
     - `AggregateError`
     - `String.prototype.replaceAll()`
     - Logical assignment operators (`&&=`, `||=`, `??=`).
   - **Why**: To support new JavaScript language features.
   - **Migration**: Update your code to leverage these features if needed.

4. **Removed `node debug` Command**
   - **What Changed**: The legacy `node debug` command was removed. Use `node inspect` instead.
   - **Why**: To standardize debugging with the inspector protocol.
   - **Migration**:
     - Replace `node debug` with `node inspect` in your workflows.

5. **Stream Module Changes**
   - **What Changed**: Internal changes to `Readable.wrap` and `stream.construct` may affect custom stream implementations.
   - **Why**: To improve performance and maintainability.
   - **Migration**: Test custom streams thoroughly and update implementations if necessary.

6. **Diagnostics Channel (Experimental)**
   - **What Changed**: Introduced the `diagnostics_channel` module for publish-subscribe patterns.
   - **Why**: To provide a generic mechanism for diagnostics data sharing.
   - **Migration**: Use the module as needed:
     ```javascript
     const diagnostics_channel = require('diagnostics_channel');
     const channel = diagnostics_channel.channel('example');
     channel.subscribe((message) => console.log(message));
     channel.publish('Hello, world!');
     ```

#### **Node.js 15.x Minor Releases**
1. **QUIC Protocol (Experimental)**
   - **What Changed**: Added experimental support for the QUIC protocol.
   - **Why**: To enable faster and more reliable HTTP/3 connections.
   - **Migration**: Use the `quic` module for experimentation:
     ```javascript
     const { createQuicSocket } = require('net');
     ```

2. **N-API Version 8**
   - **What Changed**: Introduced a new version of the Node.js Native API (N-API).
   - **Why**: To enhance native module development.
   - **Migration**: Update native modules to support N-API version 8.

3. **AbortSignal Support in `net` and `tls`**
   - **What Changed**: Added support for `AbortSignal` in `net.connect` and `tls.connect`.
   - **Why**: To improve request cancellation handling.
   - **Migration**:
     ```javascript
     const controller = new AbortController();
     const signal = controller.signal;
     const socket = net.connect({ port: 80, signal });
     controller.abort();
     ```

### 3. Comprehensive List of Breaking Changes

| **Feature/API**               | **Change**                                                                 | **Reason**                                   | **Migration**                                                                                     |
|--------------------------------|-----------------------------------------------------------------------------|---------------------------------------------|---------------------------------------------------------------------------------------------------|
| Unhandled Promise Rejections   | Default mode changed to `throw`.                                           | Encourage better error handling.            | Add a global handler or use `--unhandled-rejections=warn`.                                        |
| npm 7                          | Peer dependencies installed by default; `npx` changes.                     | Align with modern practices.                | Review dependencies and update scripts.                                                          |
| V8 Engine                      | Upgraded to 8.6; new JavaScript features.                                  | Support new language features.              | Update code to use new features like `Promise.any()`.                                            |
| `node debug`                   | Removed in favor of `node inspect`.                                        | Standardize debugging.                      | Replace `node debug` with `node inspect`.                                                        |
| Stream Module                  | Internal changes to `Readable.wrap` and `stream.construct`.                | Improve performance.                        | Test and update custom streams.                                                                  |
| Diagnostics Channel            | New experimental module for diagnostics.                                   | Enable publish-subscribe patterns.          | Use `diagnostics_channel` for diagnostics data sharing.                                          |
| QUIC Protocol                  | Experimental support added.                                                | Prepare for HTTP/3.                         | Use the `quic` module for experimentation.                                                       |
| N-API                          | Version 8 introduced.                                                      | Enhance native module development.          | Update native modules to support N-API version 8.                                                |
| AbortSignal in `net`/`tls`     | Added support for request cancellation.                                    | Improve cancellation handling.              | Use `AbortController` with `net.connect` or `tls.connect`.                                       |

### 4. Code Examples

#### Unhandled Promise Rejections
**Before:**
```javascript
Promise.reject(new Error('Unhandled!'));
```

**After:**
```javascript
process.on('unhandledRejection', (reason) => {
  console.error('Unhandled Rejection:', reason);
});
Promise.reject(new Error('Handled!'));
```

#### npm 7 Peer Dependencies
**Before:**
```json
{
  "peerDependencies": {
    "react": "^17.0.0"
  }
}
```

**After**: Peer dependencies are installed automatically. Ensure compatibility.

#### Diagnostics Channel
**Example:**
```javascript
const diagnostics_channel = require('diagnostics_channel');
const channel = diagnostics_channel.channel('example');
channel.subscribe((message) => console.log(message));
channel.publish('Hello, diagnostics!');
```

This document provides a detailed overview of all breaking changes, deprecations, and API modifications when upgrading from Node.js 14 to Node.js 15. Ensure thorough testing and code updates to maintain compatibility.