# Breaking Changes: node 17.0 → 18.0
> Generated on: 2025-04-09T01:12:14.769645
> Stack: node
> Current Version: 17.0
> Upgrade Version: 18.0

# Node.js 17 to 18 Upgrade Guide: Breaking Changes, Deprecations, and API Modifications

This document provides a comprehensive overview of all breaking changes, deprecations, and API modifications introduced when upgrading from Node.js 17 to Node.js 18. It is structured to help developers understand the changes, their impact, and how to migrate their code.

---

## 1. Summary of Major Changes

Node.js 18 introduces several significant updates:
- **Global Fetch API**: Experimental fetch API is now globally available.
- **V8 Engine Upgrade**: Updated to version 10.1, bringing new JavaScript features and performance improvements.
- **Core Test Runner Module**: A built-in test runner is now available.
- **HTTP Timeout Changes**: Default timeouts for HTTP headers and requests have been updated.
- **Toolchain Updates**: Minimum supported versions for Linux, macOS, and AIX have changed.
- **Deprecations**: Several APIs have been deprecated or removed.

---

## 2. Breaking Changes by Version

### **Node.js 18.0.0**
#### **Global Fetch API**
- **Affected**: `fetch`, `FormData`, `Headers`, `Request`, `Response`.
- **Change**: The Fetch API is now globally available but remains experimental.
- **Migration**: No changes required for usage. To disable, use the `--no-experimental-fetch` flag.
- **Example**:
  ```javascript
  // Before (Node.js 17)
  const fetch = require('node-fetch');
  const response = await fetch('https://example.com');

  // After (Node.js 18)
  const response = await fetch('https://example.com');
  ```

#### **V8 Engine Upgrade**
- **Affected**: JavaScript runtime.
- **Change**: Upgraded to V8 10.1, introducing:
  - `Array.prototype.findLast()` and `findLastIndex()`.
  - `Intl.supportedValuesOf()` and improvements to `Intl.Locale`.
  - Faster initialization of class fields and private methods.
- **Migration**: No action required unless using new features.

#### **HTTP Timeout Changes**
- **Affected**: `http` module.
- **Change**:
  - `headerTimeout` default increased to 60 seconds (from 40 seconds).
  - `requestTimeout` default increased to 5 minutes (from no timeout).
- **Migration**: Adjust custom timeout settings if necessary.

#### **Toolchain Updates**
- **Affected**: Prebuilt binaries.
- **Change**:
  - Linux: Requires Glibc 2.28+ (e.g., Debian 10, RHEL 8).
  - macOS: Requires macOS 10.15+.
  - AIX: Minimum architecture raised to Power 8.
- **Migration**: Update your environment to meet the new requirements.

---

### **Node.js 18.14.0**
#### **npm Update**
- **Affected**: `npm`.
- **Change**: Updated to npm 9.3.1, introducing stricter behavior for tarball packing and configuration options.
- **Migration**: Review npm configuration and tarball packing rules.

---

### **Node.js 18.17.0**
#### **URL Parser Update**
- **Affected**: `url` module.
- **Change**: Integrated Ada 2.0 for URL parsing, improving performance and removing ICU dependency for hostname parsing.
- **Migration**: No action required unless relying on ICU-specific behavior.

#### **WASI**
- **Affected**: WebAssembly System Interface (WASI).
- **Change**: No longer requires a flag to enable.
- **Migration**: Remove the `--experimental-wasi` flag if used.

---

## 3. Deprecations

### **Deprecated APIs**
- **`OutgoingMessage.prototype.flush()`**: Use `OutgoingMessage.prototype.flushHeaders()` instead.
- **`Intl.v8BreakIterator`**: Deprecated and will be removed in a future release.
- **Unhandled Promise Rejections**: Will terminate the process with a non-zero exit code in future versions.
- **`require('.')` Resolving Outside Directory**: Deprecated behavior; ensure `require('.')` resolves within the package directory.

### **Removed APIs**
- **`_linklist` Module**: Fully removed. Use userland alternatives.
- **`fs.SyncWriteStream`**: Deprecated; no direct replacement available.

---

## 4. Migration Guide

### **General Recommendations**
1. **Test Your Application**: Use the built-in test runner or third-party tools to identify compatibility issues.
2. **Update Dependencies**: Ensure all dependencies are compatible with Node.js 18.
3. **Environment Updates**: Upgrade your operating system or toolchain to meet the new requirements.

### **Code Examples**

#### **Unhandled Promise Rejections**
- **Before**:
  ```javascript
  Promise.reject(new Error('Unhandled'));
  ```
- **After**:
  ```javascript
  process.on('unhandledRejection', (reason) => {
    console.error('Unhandled Rejection:', reason);
  });
  ```

#### **HTTP Timeout Configuration**
- **Before**:
  ```javascript
  const server = http.createServer();
  server.timeout = 0; // No timeout
  ```
- **After**:
  ```javascript
  const server = http.createServer();
  server.requestTimeout = 300000; // 5 minutes
  ```

---

This guide ensures a smooth transition from Node.js 17 to 18 by addressing all breaking changes, deprecations, and API modifications.