# Breaking Changes: node 18.0 → 19.0
> Generated on: 2025-04-09T01:12:39.306742
> Stack: node
> Current Version: 18.0
> Upgrade Version: 19.0

## Node.js 18 to Node.js 19 Upgrade: Breaking Changes, Deprecations, and API Modifications

This document provides a comprehensive overview of all breaking changes, deprecations, and API modifications introduced when upgrading from Node.js 18 to Node.js 19. It is structured to assist developers in understanding the changes and migrating their code effectively.

---

## 1. Summary of Major Changes

- **HTTP(S)/1.1 Keep-Alive Enabled by Default**: Improves throughput by reusing connections.
- **Removal of DTrace/SystemTap/ETW Support**: These debugging tools are no longer supported.
- **Custom ESM Resolution Adjustments**: The `--experimental-specifier-resolution` flag was removed; custom loaders are now required.
- **V8 Engine Upgrade**: Updated to version 10.7, introducing new JavaScript features like `Intl.NumberFormat` v3.
- **Stable WebCrypto API**: The WebCrypto API is now stable, except for certain algorithms.
- **Experimental `node --watch` Mode**: Automatically restarts the process when files change.
- **Dependency Updates**: Includes updates to `llhttp` and other core libraries.

---

## 2. Breaking Changes by Version

### **Node.js 19.0.0**

#### **1. HTTP(S)/1.1 Keep-Alive Enabled by Default**
- **Affected API**: HTTP and HTTPS modules.
- **Change**: The `keepAlive` option is now enabled by default for outgoing HTTP(S) connections, with a default duration of 5 seconds.
- **Reason**: Improves network throughput by reusing connections.
- **Migration**:
  - If your application relies on connections closing after each request, explicitly set `keepAlive: false` in the HTTP/HTTPS agent configuration.
- **Example**:
  ```javascript
  // Before (Node.js 18)
  const agent = new http.Agent({ keepAlive: false });

  // After (Node.js 19)
  const agent = new http.Agent({ keepAlive: false }); // Explicitly disable keep-alive
  ```

#### **2. Removal of DTrace/SystemTap/ETW Support**
- **Affected Feature**: DTrace, SystemTap, and ETW debugging tools.
- **Change**: These tools are no longer supported.
- **Reason**: High maintenance complexity and lack of a clear support plan.
- **Migration**: No direct replacement. Consider alternative observability tools like OpenTelemetry.

#### **3. Custom ESM Resolution Adjustments**
- **Affected Feature**: `--experimental-specifier-resolution` flag.
- **Change**: The flag was removed; custom loaders must now handle specifier resolution.
- **Reason**: Simplifies the ESM implementation.
- **Migration**:
  - Use custom loaders to achieve the same functionality.
  - Example:
    ```javascript
    // Custom loader example
    export function resolve(specifier, context, defaultResolve) {
      // Custom resolution logic
      return defaultResolve(specifier, context);
    }
    ```

#### **4. Stable WebCrypto API**
- **Affected API**: `globalThis.crypto` and `require('node:crypto').webcrypto`.
- **Change**: The WebCrypto API is now stable, except for algorithms like Ed25519, Ed448, X25519, and X448.
- **Reason**: Maturity of the API.
- **Migration**: No changes required unless using unsupported algorithms.

#### **5. V8 Engine Upgrade to 10.7**
- **Affected Feature**: JavaScript runtime.
- **Change**: Introduced new features like `Intl.NumberFormat` v3.
- **Reason**: Aligns with Chromium 107.
- **Migration**: No changes required unless leveraging new features.

#### **6. Experimental `node --watch` Mode**
- **Affected Feature**: Process restart on file changes.
- **Change**: Introduced `node --watch` mode.
- **Reason**: Improves developer experience.
- **Migration**: Use the `--watch` flag to enable this feature.
- **Example**:
  ```bash
  node --watch index.js
  ```

---

## 3. Migration Guide

### **General Recommendations**
1. **Test Thoroughly**: Run your application in a staging environment with Node.js 19 to identify potential issues.
2. **Update Dependencies**: Ensure all third-party libraries are compatible with Node.js 19.
3. **Review Custom Loaders**: If using ESM with custom resolution logic, update your loaders to handle the removal of `--experimental-specifier-resolution`.

### **Code Examples**

#### **HTTP Keep-Alive**
```javascript
// Before (Node.js 18)
const http = require('http');
const agent = new http.Agent({ keepAlive: false });

// After (Node.js 19)
const agent = new http.Agent({ keepAlive: false }); // Explicitly disable keep-alive
```

#### **Custom ESM Loader**
```javascript
// Custom loader for resolving specifiers
export function resolve(specifier, context, defaultResolve) {
  if (specifier.startsWith('custom:')) {
    return {
      url: specifier.replace('custom:', 'file://'),
    };
  }
  return defaultResolve(specifier, context);
}
```

---

This document provides a detailed overview of the changes introduced in Node.js 19. Developers are encouraged to review their applications and dependencies to ensure compatibility.