# Breaking Changes: node 19.0 → 20.0
> Generated on: 2025-04-09T01:13:02.131892
> Stack: node
> Current Version: 19.0
> Upgrade Version: 20.0

# Node.js 19 to Node.js 20 Upgrade: Breaking Changes, Deprecations, and API Modifications

This document provides a comprehensive overview of all breaking changes, deprecations, and API modifications introduced when upgrading from Node.js 19 to Node.js 20. It is structured to assist developers in understanding the changes and adapting their codebases accordingly.

---

## 1. Summary of Major Changes

Node.js 20 introduces several significant updates, including:
- **Permission Model**: A new experimental feature to restrict access to system resources.
- **V8 Engine Upgrade**: Updated to V8 11.3, bringing performance improvements and new JavaScript features.
- **Deprecation of `url.parse()` with invalid ports**: Runtime warnings for invalid ports in URLs.
- **Single Executable Applications (SEA)**: Enhanced experimental support for bundling applications into a single binary.
- **Web Crypto API Enhancements**: Improved argument validation for better interoperability.
- **WASI Updates**: Mandatory version specification for WebAssembly System Interface (WASI) instances.
- **Performance Improvements**: Faster initialization of `EventTarget` and optimizations in `URL` and `fetch()` APIs.

---

## 2. Breaking Changes by Version

### **Node.js 20.0.0**
#### **1. Permission Model**
- **Affected Feature**: System resource access.
- **Change**: Introduced an experimental `--experimental-permission` flag to restrict access to file system, environment variables, and child processes.
- **Reason**: Enhance security by preventing unauthorized access.
- **Migration**: Enable the flag and explicitly grant permissions as needed.
  ```bash
  node --experimental-permission=fs,env script.js
  ```

#### **2. Deprecation of `url.parse()` with Invalid Ports**
- **Affected API**: `url.parse()`.
- **Change**: URLs with non-numeric ports now emit runtime warnings.
- **Reason**: Align with the WHATWG URL API and prevent potential hostname spoofing.
- **Migration**: Use the WHATWG `URL` API instead.
  ```javascript
  // Before
  const url = require('url');
  const parsed = url.parse('http://example.com:abc');

  // After
  const parsed = new URL('http://example.com:abc'); // Throws an error
  ```

#### **3. Single Executable Applications (SEA)**
- **Affected Feature**: Application bundling.
- **Change**: SEA now requires a JSON configuration file to prepare a blob for injection.
- **Reason**: Enable embedding multiple resources and improve flexibility.
- **Migration**:
  ```json
  // sea-config.json
  {
    "main": "app.js",
    "output": "sea-prep.blob"
  }
  ```
  ```bash
  node --experimental-sea-config sea-config.json
  ```

#### **4. WASI Updates**
- **Affected API**: `WASI` constructor.
- **Change**: Specifying a version is now mandatory.
- **Reason**: Improve compatibility with future WASI versions.
- **Migration**:
  ```javascript
  const { WASI } = require('wasi');
  const wasi = new WASI({ version: 'preview2' });
  ```

#### **5. Web Crypto API Enhancements**
- **Affected API**: Web Crypto functions.
- **Change**: Arguments are now coerced and validated according to WebIDL definitions.
- **Reason**: Improve compatibility with other JavaScript environments.
- **Migration**: Ensure arguments conform to WebIDL specifications.

---

## 3. Performance and Behavioral Changes

### **V8 Engine Upgrade**
- **Affected Feature**: JavaScript runtime.
- **Change**: Upgraded to V8 11.3, introducing new JavaScript features and performance improvements.
- **Impact**: Faster garbage collection and optimizations in APIs like `URL.canParse()` and timers.
- **Migration**: No action required unless relying on deprecated V8 features.

### **EventTarget Initialization**
- **Affected API**: `EventTarget`.
- **Change**: Initialization cost reduced by 50%.
- **Impact**: Faster access to subsystems using `EventTarget`.
- **Migration**: No action required.

---

## 4. Deprecations

### **1. `url.parse()`**
- **Details**: Deprecated for URLs with invalid ports. Use the WHATWG `URL` API instead.

### **2. `--experimental-require-module` Flag**
- **Details**: The `require(esm)` feature is now enabled by default, and the flag is no longer needed.

---

## 5. Migration Examples

### **Using the Permission Model**
```javascript
// Before: No restrictions
const fs = require('fs');
fs.readFileSync('/etc/passwd');

// After: Explicitly grant permissions
// Run with: node --experimental-permission=fs script.js
const fs = require('fs');
fs.readFileSync('/etc/passwd');
```

### **Replacing `url.parse()`**
```javascript
// Before
const url = require('url');
const parsed = url.parse('http://example.com:abc');

// After
const parsed = new URL('http://example.com:abc'); // Throws an error
```

### **Updating WASI Code**
```javascript
// Before
const { WASI } = require('wasi');
const wasi = new WASI();

// After
const wasi = new WASI({ version: 'preview2' });
```

---

This document covers all known breaking changes, deprecations, and API modifications introduced in Node.js 20. Developers are encouraged to test their applications thoroughly and consult the official Node.js documentation for additional details.