# Breaking Changes: node 20.0 → 21.0
> Generated on: 2025-04-09T01:13:31.273640
> Stack: node
> Current Version: 20.0
> Upgrade Version: 21.0

# Node.js 20 to Node.js 21 Upgrade Guide

This document provides a comprehensive overview of all breaking changes, deprecations, and API modifications introduced when upgrading from Node.js 20 to Node.js 21. It is structured to help developers understand the changes, their impact, and how to migrate their code.

---

## 1. Summary of Major Changes

Node.js 21 introduces several significant updates, including:
- **Stable Fetch API**: The Fetch API is now fully stable and production-ready.
- **Web Streams API Stabilization**: The Web Streams API is no longer experimental.
- **Built-in WebSocket Client**: Experimental support for a WebSocket client is added.
- **ES Module Enhancements**: A new flag (`--experimental-default-type`) allows `.js` files to default to ES modules.
- **llhttp Strict Mode**: Strict HTTP parsing is now enforced by default.
- **V8 Engine Upgrade**: Upgraded to V8 version 11.8, bringing new JavaScript features and performance improvements.
- **Test Runner Enhancements**: Improved test runner with glob support and parallelism control.
- **Performance Optimizations**: Streams API and response handling have been optimized for better performance.

---

## 2. Breaking Changes by Version

### **Node.js 21.0.0**

#### **1. Fetch API Stabilization**
- **Affected API**: `fetch`, `Headers`, `Request`, `Response`
- **What Changed**: The Fetch API is now stable and no longer marked as experimental.
- **Migration**: No changes are required for existing code using the Fetch API. Developers can now confidently use it in production.
- **Example**:
  ```javascript
  // Before (Node.js 20 - experimental)
  const res = await fetch('https://api.example.com/data');
  
  // After (Node.js 21 - stable)
  const res = await fetch('https://api.example.com/data');
  ```

#### **2. Web Streams API Stabilization**
- **Affected API**: Web Streams API
- **What Changed**: The API is now stable and production-ready.
- **Migration**: No changes are needed for existing implementations.

#### **3. llhttp Strict Mode**
- **Affected Feature**: HTTP parsing
- **What Changed**: Strict mode is now enabled by default, requiring `\r\n` after headers and chunks. Data transmission after a `Connection: close` header is disallowed.
- **Migration**: Use the `--insecure-http-parser` flag to disable strict mode if needed.
- **Example**:
  ```bash
  # Disable strict mode
  node --insecure-http-parser app.js
  ```

#### **4. ES Module Enhancements**
- **Affected Feature**: Module resolution
- **What Changed**: The `--experimental-default-type` flag allows `.js` files to default to ES modules.
- **Migration**: Add the flag to your Node.js startup command if you want `.js` files to default to ES modules.
- **Example**:
  ```bash
  node --experimental-default-type=module app.js
  ```

#### **5. Removal of `globalPreload` Hook**
- **Affected Feature**: Module customization
- **What Changed**: The `globalPreload` hook has been removed in favor of a new `register` API.
- **Migration**: Update code to use the `register` API for module customization.

#### **6. V8 Engine Upgrade**
- **Affected Feature**: JavaScript runtime
- **What Changed**: Upgraded to V8 11.8, introducing new features like `Object.groupBy`, `Map.groupBy`, and `ArrayBuffer.prototype.transfer`.
- **Migration**: Ensure compatibility with new JavaScript features and recompile native modules.

#### **7. Test Runner Enhancements**
- **Affected Feature**: Native test runner
- **What Changed**: Added support for glob patterns and a `--parallelism` flag.
- **Migration**: Update test scripts to leverage new features.
- **Example**:
  ```bash
  # Run tests with glob patterns
  node --test **/*.test.js
  
  # Control parallelism
  node --test --parallelism=4
  ```

#### **8. Streams API Performance Improvements**
- **Affected API**: Streams
- **What Changed**: Optimizations include a 10% speedup by removing redundant checks and improving callback scheduling.
- **Migration**: No changes required unless relying on specific internal behaviors.

#### **9. Built-in WebSocket Client**
- **Affected API**: WebSocket
- **What Changed**: Experimental support for a WebSocket client is introduced.
- **Migration**: Use the experimental flag to enable the WebSocket client.
- **Example**:
  ```javascript
  const ws = new WebSocket('ws://example.com');
  ws.on('message', (data) => console.log(data));
  ```

---

## 3. Migration Guide

### **General Steps**
1. **Update Node.js Version**: Update your environment to Node.js 21.0.0.
2. **Update Dependencies**: Ensure all dependencies are compatible with Node.js 21.
3. **Test Your Application**: Run your test suite to identify any issues caused by breaking changes.
4. **Use Feature Flags**: Enable experimental features like the WebSocket client if needed.

### **Code Examples**

#### **Before and After: Fetch API**
```javascript
// Before (Node.js 20 - experimental)
const res = await fetch('https://api.example.com/data');

// After (Node.js 21 - stable)
const res = await fetch('https://api.example.com/data');
```

#### **Before and After: ES Module Default**
```javascript
// Before (Node.js 20)
node app.js

// After (Node.js 21)
node --experimental-default-type=module app.js
```

#### **Before and After: llhttp Strict Mode**
```bash
# Before (Node.js 20)
node app.js

# After (Node.js 21 - strict mode enabled)
node --insecure-http-parser app.js
```

---

This guide ensures a smooth transition from Node.js 20 to Node.js 21 by addressing all breaking changes and providing actionable migration steps.