# Breaking Changes: node 21.0 → 22.0
> Generated on: 2025-04-09T01:14:01.290594
> Stack: node
> Current Version: 21.0
> Upgrade Version: 22.0

# Node.js 21 to Node.js 22 Upgrade Guide

This document provides a comprehensive overview of all breaking changes, deprecations, and API modifications when upgrading from Node.js 21 to Node.js 22. It includes a summary of major changes, detailed breaking changes, and migration guidance.

---

## 1. Summary of Major Changes

Node.js 22 introduces several new features, performance improvements, and breaking changes. Key highlights include:

- **Enhanced ECMAScript Module (ESM) support**: `require()` can now import ESM modules under the `--experimental-require-module` flag.
- **Native WebSocket client**: A built-in WebSocket client is now enabled by default.
- **V8 Engine Upgrade**: Updated to V8 v12.4, introducing features like `Array.fromAsync`, `Set` methods, and WebAssembly Garbage Collection.
- **Stream Performance Enhancements**: The default `highWaterMark` for streams increased from 16KiB to 64KiB.
- **Stable Watch Mode**: The `--watch` flag is now stable, allowing automatic process restarts on file changes.
- **New CLI Features**: Experimental `--run` flag for executing `package.json` scripts directly.

---

## 2. Breaking Changes by Version

### **Node.js 22 Breaking Changes**

#### **1. Stream High Water Mark Adjustment**
- **Affected API**: Streams
- **Change**: The default `highWaterMark` for streams has been increased from 16KiB to 64KiB.
- **Reason**: To improve performance for streaming operations.
- **Migration**: Applications sensitive to memory usage should explicitly set the `highWaterMark` to a lower value.
- **Code Example**:
  ```javascript
  // Before (Node.js 21 default)
  const stream = new Readable({ highWaterMark: 16 * 1024 });

  // After (Node.js 22 default)
  const stream = new Readable({ highWaterMark: 64 * 1024 });
  ```

#### **2. WebSocket Global Enabled by Default**
- **Affected API**: WebSocket
- **Change**: The `WebSocket` global is now enabled by default, removing the need for the `--experimental-websocket` flag.
- **Reason**: To simplify real-time application development.
- **Migration**: Remove the `--experimental-websocket` flag from your startup scripts.
- **Code Example**:
  ```javascript
  // Before
  node --experimental-websocket app.js

  // After
  node app.js
  ```

#### **3. Enhanced ESM Support**
- **Affected API**: Module system
- **Change**: The `require()` function can now import ESM modules under the `--experimental-require-module` flag.
- **Reason**: To bridge the gap between CommonJS and ESM.
- **Migration**: Use the `--experimental-require-module` flag when importing ESM modules in CommonJS.
- **Code Example**:
  ```javascript
  // Before
  import esmModule from './module.mjs';

  // After
  require('./module.mjs'); // Requires --experimental-require-module flag
  ```

#### **4. CLI `--run` Flag**
- **Affected API**: CLI
- **Change**: Introduced the `--run` flag for executing `package.json` scripts directly.
- **Reason**: To improve script execution performance.
- **Migration**: Use `node --run <script>` instead of `npm run <script>`.
- **Code Example**:
  ```bash
  # Before
  npm run test

  # After
  node --run test
  ```

#### **5. V8 Engine Upgrade**
- **Affected API**: JavaScript runtime
- **Change**: Upgraded to V8 v12.4, introducing new JavaScript features.
- **Reason**: To align with the latest ECMAScript standards.
- **Migration**: Update code to leverage new features like `Array.fromAsync` and `Set` methods.
- **Code Example**:
  ```javascript
  // New in Node.js 22
  const asyncArray = await Array.fromAsync(async function* () {
    yield 1;
    yield 2;
    yield 3;
  }());
  ```

---

### **Node.js 21 Breaking Changes**

#### **1. Stabilized Fetch API**
- **Affected API**: Fetch
- **Change**: The Fetch API is now stable and replaces older HTTP request methods.
- **Reason**: To modernize HTTP request handling.
- **Migration**: Replace `http` or `https` modules with `fetch`.
- **Code Example**:
  ```javascript
  // Before
  const http = require('http');
  http.get('http://example.com', (res) => { /* ... */ });

  // After
  const response = await fetch('http://example.com');
  ```

#### **2. llhttp Strict Mode**
- **Affected API**: HTTP parser
- **Change**: llhttp strict mode is now enforced, requiring `\r\n` after headers and chunks.
- **Reason**: To improve protocol adherence.
- **Migration**: Ensure all headers and chunks include `\r\n`.
- **Code Example**:
  ```javascript
  // Before
  socket.write('Header: value\n');

  // After
  socket.write('Header: value\r\n');
  ```

#### **3. Navigator Object**
- **Affected API**: Global object
- **Change**: Added `navigator.hardwareConcurrency` for hardware concurrency information.
- **Reason**: To improve web interoperability.
- **Migration**: Update code to use `navigator.hardwareConcurrency` where applicable.
- **Code Example**:
  ```javascript
  console.log(navigator.hardwareConcurrency); // Outputs number of CPU cores
  ```

---

## 3. Migration Checklist

1. **Update Dependencies**: Ensure all dependencies are compatible with Node.js 22.
2. **Test Applications**: Run comprehensive tests to identify any issues caused by breaking changes.
3. **Adjust Stream Settings**: Explicitly set `highWaterMark` for memory-sensitive applications.
4. **Remove Deprecated Flags**: Remove `--experimental-websocket` and other deprecated flags.
5. **Leverage New Features**: Update code to use new JavaScript features and APIs.

---

This guide ensures a smooth transition from Node.js 21 to Node.js 22 by addressing all breaking changes and providing actionable migration steps.