# Breaking Changes: node 9.0 → 10.0
> Generated on: 2025-04-09T01:08:30.986206
> Stack: node
> Current Version: 9.0
> Upgrade Version: 10.0

# Node.js Upgrade Guide: From v9.0.0 to v10.0.0

This document provides a comprehensive overview of all breaking changes, deprecations, and API modifications introduced when upgrading from Node.js v9.0.0 to v10.0.0. It is structured to help developers understand the changes and migrate their code effectively.

---

## 1. Summary of Major Changes

Node.js v10.0.0 introduced several significant updates:
- **N-API** graduated from experimental status, ensuring ABI stability for native addons.
- **New features in `fs`**: Promisified versions of filesystem methods were added under `fs/promises`.
- **Deprecations and stricter validations**: Deprecated APIs were removed, and stricter argument validations were introduced in several modules.
- **Performance improvements**: Enhancements in streams, timers, and HTTP processing.
- **Dependency updates**: Upgraded V8 to version 6.6, OpenSSL to 1.1.0h, and other core libraries.

---

## 2. Breaking Changes by Version

### **Node.js v10.0.0**

#### **Assert Module**
- **Affected APIs**:
  - `assert.fail()`
  - `assert.ifError()`
- **Changes**:
  - `assert.fail()` with more than one argument is deprecated.
  - `assert.ifError()` now throws for any argument that is not `undefined` or `null` (previously, it threw for truthy values).
- **Migration**:
  - Update calls to `assert.fail()` to use a single argument.
  - Ensure `assert.ifError()` is only called with `undefined` or `null`.
- **Example**:
  ```javascript
  // Before
  assert.fail('Error', 'Message');

  // After
  assert.fail('Error');
  ```

#### **File System (fs) Module**
- **Affected APIs**:
  - `fs/promises`
  - `fs.readFile()`
- **Changes**:
  - Introduced `fs/promises` for promisified filesystem methods.
  - Invalid path errors in `fs.readFile()` are now thrown synchronously.
- **Migration**:
  - Use `fs.promises` for asynchronous operations.
  - Handle synchronous errors when working with `fs.readFile()`.
- **Example**:
  ```javascript
  // Before
  fs.readFile('invalid/path', (err, data) => {
    if (err) console.error(err);
  });

  // After
  try {
    const data = await fs.promises.readFile('invalid/path');
  } catch (err) {
    console.error(err);
  }
  ```

#### **HTTP Module**
- **Affected Features**:
  - HTTP status codes and URL path handling.
- **Changes**:
  - Multi-byte characters in URL paths are now forbidden.
  - Improved processing of HTTP status codes `100` and `102-199`.
- **Migration**:
  - Ensure URL paths do not contain multi-byte characters.
  - Update any custom handling of HTTP status codes.

#### **Streams**
- **Affected Features**:
  - `'readable'` event
  - New `pipeline()` method
- **Changes**:
  - The `'readable'` event is now always deferred with `process.nextTick`.
  - Introduced `stream.pipeline()` for building end-to-end stream pipelines.
- **Migration**:
  - Adjust code relying on the timing of `'readable'` events.
  - Use `pipeline()` for better stream handling.
- **Example**:
  ```javascript
  const { pipeline } = require('stream');

  // Before
  readableStream.pipe(writableStream);

  // After
  pipeline(readableStream, writableStream, (err) => {
    if (err) console.error('Pipeline failed', err);
  });
  ```

#### **Timers**
- **Affected APIs**:
  - `timers.enroll()`
  - `timers.unenroll()`
- **Changes**:
  - `enroll()` and `unenroll()` methods are deprecated.
- **Migration**:
  - Replace usage of these methods with alternative timer handling.

#### **TLS Module**
- **Changes**:
  - Default minimum DH parameter size is now 2048 bits.
- **Migration**:
  - Update configurations to ensure compatibility with the new minimum size.

#### **Deprecations**
- **Removed APIs**:
  - `Buffer()` constructor outside `node_modules` now emits a deprecation warning.
  - `fs.read()` and `fs.readSync()` legacy string interfaces are deprecated.
  - `GLOBAL` and `root` aliases for `global` are removed.
- **Migration**:
  - Use `Buffer.from()` or `Buffer.alloc()` instead of `Buffer()`.
  - Replace legacy string interfaces with `Buffer` APIs.
  - Replace `GLOBAL` and `root` with `global`.

---

## 3. Migration Guide with Examples

### **General Migration Steps**
1. **Audit Dependencies**:
   - Ensure all third-party modules are compatible with Node.js v10.0.0.
2. **Update Deprecated APIs**:
   - Replace deprecated methods with their recommended alternatives.
3. **Test Thoroughly**:
   - Run your test suite to identify any issues caused by stricter validations or API changes.

### **Code Examples**

#### **Buffer Constructor**
```javascript
// Before
const buf = new Buffer(10);

// After
const buf = Buffer.alloc(10);
```

#### **fs.read() Legacy Interface**
```javascript
// Before
fs.read(fd, 'utf8', (err, data) => {
  if (err) throw err;
});

// After
const buffer = Buffer.alloc(1024);
fs.read(fd, buffer, 0, buffer.length, null, (err, bytesRead, buffer) => {
  if (err) throw err;
});
```

#### **GLOBAL Alias**
```javascript
// Before
console.log(GLOBAL);

// After
console.log(global);
```

---

## 4. Conclusion

Upgrading from Node.js v9.0.0 to v10.0.0 introduces several breaking changes, deprecations, and new features. By following this guide and updating your code accordingly, you can ensure a smooth transition to Node.js v10.0.0.