/*
 * Decompiled with CFR 0.152.
 */
package io.atoti;

import com.activeviam.fwk.ActiveViamRuntimeException;
import com.activeviam.lic.impl.Licensing;
import com.qfs.websocket.security.impl.IdentityWebSocketHandlerFactory;
import com.qfs.websocket.server.impl.AtotiHandshakeHandlerFactory;
import io.atoti.Session;
import io.atoti.SessionImpl;
import io.atoti.patachou.cfg.AnonymousSecurityFacade;
import io.atoti.util.Utils;
import io.atoti.util.impl.ServerUtils;
import java.util.Arrays;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApplicationStarter {
    private static final String ENABLE_AUTH_OPTION = "--enable-auth";

    public static void main(String[] args) throws Exception {
        ApplicationStarter.fullInit();
        boolean enableAuth = Arrays.asList(args).contains("--enable-auth");
        ServerUtils.startPy4JServer((Session)new SessionImpl(), (boolean)enableAuth);
    }

    public static void fullInit() {
        ApplicationStarter.checkLicense();
        ServerUtils.globalSetup();
        Utils.initializationUtil().initializeRegistry(new Class[]{AnonymousSecurityFacade.class, AtotiHandshakeHandlerFactory.class, IdentityWebSocketHandlerFactory.class});
    }

    private static void checkLicense() {
        String atotiLicense = System.getenv("ATOTI_LICENSE");
        if (StringUtils.hasText((String)atotiLicense)) {
            System.setProperty("activepivot.license", atotiLicense);
        }
        if (!Licensing.checkLicense()) {
            String message = Licensing.getLicense().getClientName().equals("atoti community") ? "The license has expired, update to atoti's latest version or upgrade to Atoti+." : "Cannot start application with invalid license.";
            throw new ActiveViamRuntimeException(message);
        }
    }

    public static void useDefaultPy4jPort() {
        if (System.getProperty("py4j.port") == null) {
            System.setProperty("py4j.port", String.valueOf(25333));
        }
    }
}

