# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetPolicyPackResult',
    'AwaitableGetPolicyPackResult',
    'get_policy_pack',
    'get_policy_pack_output',
]

@pulumi.output_type
class GetPolicyPackResult:
    def __init__(__self__, config=None, display_name=None, name=None, policies=None, version=None, version_tag=None):
        if config and not isinstance(config, dict):
            raise TypeError("Expected argument 'config' to be a dict")
        pulumi.set(__self__, "config", config)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)
        if version_tag and not isinstance(version_tag, str):
            raise TypeError("Expected argument 'version_tag' to be a str")
        pulumi.set(__self__, "version_tag", version_tag)

    @property
    @pulumi.getter
    def config(self) -> Optional[Mapping[str, Any]]:
        """
        Configuration for the policy pack.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the policy pack.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the policy pack.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policies(self) -> Optional[Sequence[Mapping[str, str]]]:
        """
        List of policies in this pack.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version number.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="versionTag")
    def version_tag(self) -> Optional[str]:
        """
        The version tag (if any).
        """
        return pulumi.get(self, "version_tag")


class AwaitableGetPolicyPackResult(GetPolicyPackResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyPackResult(
            config=self.config,
            display_name=self.display_name,
            name=self.name,
            policies=self.policies,
            version=self.version,
            version_tag=self.version_tag)


def get_policy_pack(organization_name: Optional[str] = None,
                    policy_pack_name: Optional[str] = None,
                    version: Optional[int] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyPackResult:
    """
    Get details about a specific version of a policy pack.


    :param str organization_name: The name of the Pulumi organization.
    :param str policy_pack_name: The name of the policy pack.
    :param int version: The version number of the policy pack. If not specified, returns the latest version.
    """
    __args__ = dict()
    __args__['organizationName'] = organization_name
    __args__['policyPackName'] = policy_pack_name
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('pulumiservice:index:getPolicyPack', __args__, opts=opts, typ=GetPolicyPackResult).value

    return AwaitableGetPolicyPackResult(
        config=pulumi.get(__ret__, 'config'),
        display_name=pulumi.get(__ret__, 'display_name'),
        name=pulumi.get(__ret__, 'name'),
        policies=pulumi.get(__ret__, 'policies'),
        version=pulumi.get(__ret__, 'version'),
        version_tag=pulumi.get(__ret__, 'version_tag'))
def get_policy_pack_output(organization_name: Optional[pulumi.Input[str]] = None,
                           policy_pack_name: Optional[pulumi.Input[str]] = None,
                           version: Optional[pulumi.Input[Optional[int]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPolicyPackResult]:
    """
    Get details about a specific version of a policy pack.


    :param str organization_name: The name of the Pulumi organization.
    :param str policy_pack_name: The name of the policy pack.
    :param int version: The version number of the policy pack. If not specified, returns the latest version.
    """
    __args__ = dict()
    __args__['organizationName'] = organization_name
    __args__['policyPackName'] = policy_pack_name
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('pulumiservice:index:getPolicyPack', __args__, opts=opts, typ=GetPolicyPackResult)
    return __ret__.apply(lambda __response__: GetPolicyPackResult(
        config=pulumi.get(__response__, 'config'),
        display_name=pulumi.get(__response__, 'display_name'),
        name=pulumi.get(__response__, 'name'),
        policies=pulumi.get(__response__, 'policies'),
        version=pulumi.get(__response__, 'version'),
        version_tag=pulumi.get(__response__, 'version_tag')))
